/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.stream;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ObjectRecord;
import org.springframework.data.redis.connection.stream.Record;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.data.redis.hash.HashMapper;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.lang.Nullable;

public interface ByteBufferRecord
extends MapRecord<ByteBuffer, ByteBuffer, ByteBuffer> {
    @Override
    public ByteBufferRecord withId(RecordId var1);

    public ByteBufferRecord withStreamKey(ByteBuffer var1);

    default public <T> MapRecord<T, T, T> deserialize(@Nullable RedisSerializer<T> serializer) {
        return this.deserialize(serializer, serializer, serializer);
    }

    default public <K, HK, HV> MapRecord<K, HK, HV> deserialize(@Nullable RedisSerializer<? extends K> streamSerializer, @Nullable RedisSerializer<? extends HK> fieldSerializer, @Nullable RedisSerializer<? extends HV> valueSerializer) {
        return this.mapEntries(it -> Collections.singletonMap(fieldSerializer != null ? fieldSerializer.deserialize(ByteUtils.getBytes((ByteBuffer)it.getKey())) : it.getKey(), valueSerializer != null ? valueSerializer.deserialize(ByteUtils.getBytes((ByteBuffer)it.getValue())) : it.getValue()).entrySet().iterator().next()).withStreamKey(streamSerializer != null ? streamSerializer.deserialize(ByteUtils.getBytes((ByteBuffer)this.getStream())) : this.getStream());
    }

    public static ByteBufferRecord of(MapRecord<ByteBuffer, ByteBuffer, ByteBuffer> source) {
        return StreamRecords.newRecord().in((ByteBuffer)source.getStream()).withId(source.getId()).ofBuffer((Map)source.getValue());
    }

    @Override
    default public <OV> ObjectRecord<ByteBuffer, OV> toObjectRecord(HashMapper<? super OV, ? super ByteBuffer, ? super ByteBuffer> mapper) {
        Map<byte[], byte[]> targetMap = ((Map)this.getValue()).entrySet().stream().collect(Collectors.toMap(entry -> ByteUtils.getBytes((ByteBuffer)entry.getKey()), entry -> ByteUtils.getBytes((ByteBuffer)entry.getValue())));
        return Record.of(mapper.fromHash(targetMap)).withId(this.getId()).withStreamKey((ByteBuffer)this.getStream());
    }
}

