/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.stream;

import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.Record;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public final class StreamOffset<K> {
    private final K key;
    private final ReadOffset offset;

    private StreamOffset(K key, ReadOffset offset) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull((Object)offset, (String)"ReadOffset must not be null");
        this.key = key;
        this.offset = offset;
    }

    public static <K> StreamOffset<K> create(K stream, ReadOffset readOffset) {
        return new StreamOffset<K>(stream, readOffset);
    }

    public static <K> StreamOffset<K> latest(K stream) {
        return new StreamOffset<K>(stream, ReadOffset.latest());
    }

    public static <K> StreamOffset<K> fromStart(K stream) {
        return new StreamOffset<K>(stream, ReadOffset.from("0-0"));
    }

    public static <K> StreamOffset<K> from(Record<K, ?> reference) {
        Assert.notNull(reference, (String)"Reference record must not be null");
        return StreamOffset.create(reference.getStream(), ReadOffset.from(reference.getId()));
    }

    public K getKey() {
        return this.key;
    }

    public ReadOffset getOffset() {
        return this.offset;
    }

    public String toString() {
        return "StreamOffset{key=" + this.key + ", offset=" + this.offset + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamOffset that = (StreamOffset)o;
        if (!ObjectUtils.nullSafeEquals(this.key, that.key)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.offset, (Object)that.offset);
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode(this.key);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.offset);
        return result;
    }
}

