/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.stream;

import java.time.Duration;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class StreamReadOptions {
    private static final StreamReadOptions EMPTY = new StreamReadOptions(null, null, false);
    @Nullable
    private final Long block;
    @Nullable
    private final Long count;
    private final boolean noack;

    private StreamReadOptions(@Nullable Long block, @Nullable Long count, boolean noack) {
        this.block = block;
        this.count = count;
        this.noack = noack;
    }

    public static StreamReadOptions empty() {
        return EMPTY;
    }

    public StreamReadOptions noack() {
        return this.autoAcknowledge();
    }

    public StreamReadOptions autoAcknowledge() {
        return new StreamReadOptions(this.block, this.count, true);
    }

    public StreamReadOptions block(Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Block timeout must not be null!");
        Assert.isTrue((!timeout.isNegative() ? 1 : 0) != 0, (String)"Block timeout must not be negative!");
        return new StreamReadOptions(timeout.toMillis(), this.count, this.noack);
    }

    public StreamReadOptions count(long count) {
        Assert.isTrue((count > 0L ? 1 : 0) != 0, (String)"Count must be greater or equal to zero!");
        return new StreamReadOptions(this.block, count, this.noack);
    }

    public boolean isBlocking() {
        return this.getBlock() != null && this.getBlock() >= 0L;
    }

    @Nullable
    public Long getBlock() {
        return this.block;
    }

    @Nullable
    public Long getCount() {
        return this.count;
    }

    public boolean isNoack() {
        return this.noack;
    }

    public String toString() {
        return "StreamReadOptions{block=" + this.block + ", count=" + this.count + ", noack=" + this.noack + ", blocking=" + this.isBlocking() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamReadOptions that = (StreamReadOptions)o;
        if (this.noack != that.noack) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.block, (Object)that.block)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.count, (Object)that.count);
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode((Object)this.block);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.count);
        result = 31 * result + (this.noack ? 1 : 0);
        return result;
    }
}

