/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.data.redis.connection.ReactiveSetCommands;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.core.ReactiveSetOperations;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultReactiveSetOperations<K, V>
implements ReactiveSetOperations<K, V> {
    private final ReactiveRedisTemplate<?, ?> template;
    private final RedisSerializationContext<K, V> serializationContext;

    DefaultReactiveSetOperations(ReactiveRedisTemplate<?, ?> template, RedisSerializationContext<K, V> serializationContext) {
        this.template = template;
        this.serializationContext = serializationContext;
    }

    @Override
    public Mono<Long> add(K key, V ... values) {
        Assert.notNull(key, (String)"Key must not be null!");
        if (values.length == 1) {
            return this.createMono(connection -> connection.sAdd(this.rawKey(key), this.rawValue(values[0])));
        }
        return this.createMono(connection -> Flux.fromArray((Object[])values).map(this::rawValue).collectList().flatMap(serialized -> connection.sAdd(this.rawKey(key), (Collection<ByteBuffer>)serialized)));
    }

    @Override
    public Mono<Long> remove(K key, Object ... values) {
        Assert.notNull(key, (String)"Key must not be null!");
        if (values.length == 1) {
            return this.createMono(connection -> connection.sRem(this.rawKey(key), this.rawValue(values[0])));
        }
        return this.createMono(connection -> Flux.fromArray((Object[])values).map(this::rawValue).collectList().flatMap(serialized -> connection.sRem(this.rawKey(key), (Collection<ByteBuffer>)serialized)));
    }

    @Override
    public Mono<V> pop(K key) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.sPop(this.rawKey(key)).map(this::readValue));
    }

    @Override
    public Flux<V> pop(K key, long count) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createFlux(connection -> connection.sPop(this.rawKey(key), count).map(this::readValue));
    }

    @Override
    public Mono<Boolean> move(K sourceKey, V value, K destKey) {
        Assert.notNull(sourceKey, (String)"Source key must not be null!");
        Assert.notNull(destKey, (String)"Destination key must not be null!");
        return this.createMono(connection -> connection.sMove(this.rawKey(sourceKey), this.rawKey(destKey), this.rawValue(value)));
    }

    @Override
    public Mono<Long> size(K key) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.sCard(this.rawKey(key)));
    }

    @Override
    public Mono<Boolean> isMember(K key, Object o) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.sIsMember(this.rawKey(key), this.rawValue(o)));
    }

    @Override
    public Mono<Map<Object, Boolean>> isMember(K key, Object ... objects) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> Flux.fromArray((Object[])objects).map(this::rawValue).collectList().flatMap(rawValues -> connection.sMIsMember(this.rawKey(key), (List<ByteBuffer>)rawValues)).map(result -> {
            LinkedHashMap<Object, Boolean> isMember = new LinkedHashMap<Object, Boolean>(result.size());
            for (int i = 0; i < objects.length; ++i) {
                isMember.put(objects[i], (Boolean)result.get(i));
            }
            return isMember;
        }));
    }

    @Override
    public Flux<V> intersect(K key, K otherKey) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKey, (String)"Other key must not be null!");
        return this.intersect(key, (Collection<K>)Collections.singleton(otherKey));
    }

    @Override
    public Flux<V> intersect(K key, Collection<K> otherKeys) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKeys, (String)"Other keys must not be null!");
        return this.intersect(this.getKeys(key, otherKeys));
    }

    @Override
    public Flux<V> intersect(Collection<K> keys) {
        Assert.notNull(keys, (String)"Keys must not be null!");
        return this.createFlux(connection -> Flux.fromIterable((Iterable)keys).map(this::rawKey).collectList().flatMapMany(connection::sInter).map(this::readValue));
    }

    @Override
    public Mono<Long> intersectAndStore(K key, K otherKey, K destKey) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKey, (String)"Other key must not be null!");
        Assert.notNull(destKey, (String)"Destination key must not be null!");
        return this.intersectAndStore(key, (Collection<K>)Collections.singleton(otherKey), destKey);
    }

    @Override
    public Mono<Long> intersectAndStore(K key, Collection<K> otherKeys, K destKey) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKeys, (String)"Other keys must not be null!");
        Assert.notNull(destKey, (String)"Destination key must not be null!");
        return this.intersectAndStore(this.getKeys(key, otherKeys), destKey);
    }

    @Override
    public Mono<Long> intersectAndStore(Collection<K> keys, K destKey) {
        Assert.notNull(keys, (String)"Keys must not be null!");
        Assert.notNull(destKey, (String)"Destination key must not be null!");
        return this.createMono(connection -> Flux.fromIterable((Iterable)keys).map(this::rawKey).collectList().flatMap(rawKeys -> connection.sInterStore(this.rawKey(destKey), (Collection<ByteBuffer>)rawKeys)));
    }

    @Override
    public Flux<V> union(K key, K otherKey) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKey, (String)"Other key must not be null!");
        return this.union(key, (Collection<K>)Collections.singleton(otherKey));
    }

    @Override
    public Flux<V> union(K key, Collection<K> otherKeys) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKeys, (String)"Other keys must not be null!");
        return this.union(this.getKeys(key, otherKeys));
    }

    @Override
    public Flux<V> union(Collection<K> keys) {
        Assert.notNull(keys, (String)"Keys must not be null!");
        return this.createFlux(connection -> Flux.fromIterable((Iterable)keys).map(this::rawKey).collectList().flatMapMany(connection::sUnion).map(this::readValue));
    }

    @Override
    public Mono<Long> unionAndStore(K key, K otherKey, K destKey) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKey, (String)"Other key must not be null!");
        Assert.notNull(destKey, (String)"Destination key must not be null!");
        return this.unionAndStore(key, (Collection<K>)Collections.singleton(otherKey), destKey);
    }

    @Override
    public Mono<Long> unionAndStore(K key, Collection<K> otherKeys, K destKey) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKeys, (String)"Other keys must not be null!");
        Assert.notNull(destKey, (String)"Destination key must not be null!");
        return this.unionAndStore(this.getKeys(key, otherKeys), destKey);
    }

    @Override
    public Mono<Long> unionAndStore(Collection<K> keys, K destKey) {
        Assert.notNull(keys, (String)"Keys must not be null!");
        Assert.notNull(destKey, (String)"Destination key must not be null!");
        return this.createMono(connection -> Flux.fromIterable((Iterable)keys).map(this::rawKey).collectList().flatMap(rawKeys -> connection.sUnionStore(this.rawKey(destKey), (Collection<ByteBuffer>)rawKeys)));
    }

    @Override
    public Flux<V> difference(K key, K otherKey) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKey, (String)"Other key must not be null!");
        return this.difference(key, (Collection<K>)Collections.singleton(otherKey));
    }

    @Override
    public Flux<V> difference(K key, Collection<K> otherKeys) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKeys, (String)"Other keys must not be null!");
        return this.difference(this.getKeys(key, otherKeys));
    }

    @Override
    public Flux<V> difference(Collection<K> keys) {
        Assert.notNull(keys, (String)"Keys must not be null!");
        return this.createFlux(connection -> Flux.fromIterable((Iterable)keys).map(this::rawKey).collectList().flatMapMany(connection::sDiff).map(this::readValue));
    }

    @Override
    public Mono<Long> differenceAndStore(K key, K otherKey, K destKey) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKey, (String)"Other key must not be null!");
        Assert.notNull(destKey, (String)"Destination key must not be null!");
        return this.differenceAndStore(key, (Collection<K>)Collections.singleton(otherKey), destKey);
    }

    @Override
    public Mono<Long> differenceAndStore(K key, Collection<K> otherKeys, K destKey) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKeys, (String)"Other keys must not be null!");
        Assert.notNull(destKey, (String)"Destination key must not be null!");
        return this.differenceAndStore(this.getKeys(key, otherKeys), destKey);
    }

    @Override
    public Mono<Long> differenceAndStore(Collection<K> keys, K destKey) {
        Assert.notNull(keys, (String)"Keys must not be null!");
        Assert.notNull(destKey, (String)"Destination key must not be null!");
        return this.createMono(connection -> Flux.fromIterable((Iterable)keys).map(this::rawKey).collectList().flatMap(rawKeys -> connection.sDiffStore(this.rawKey(destKey), (Collection<ByteBuffer>)rawKeys)));
    }

    @Override
    public Flux<V> members(K key) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createFlux(connection -> connection.sMembers(this.rawKey(key)).map(this::readValue));
    }

    @Override
    public Flux<V> scan(K key, ScanOptions options) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull((Object)options, (String)"ScanOptions must not be null!");
        return this.createFlux(connection -> connection.sScan(this.rawKey(key), options).map(this::readValue));
    }

    @Override
    public Mono<V> randomMember(K key) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.sRandMember(this.rawKey(key)).map(this::readValue));
    }

    @Override
    public Flux<V> distinctRandomMembers(K key, long count) {
        Assert.isTrue((count > 0L ? 1 : 0) != 0, (String)"Negative count not supported. Use randomMembers to allow duplicate elements.");
        return this.createFlux(connection -> connection.sRandMember(this.rawKey(key), count).map(this::readValue));
    }

    @Override
    public Flux<V> randomMembers(K key, long count) {
        Assert.isTrue((count > 0L ? 1 : 0) != 0, (String)"Use a positive number for count. This method is already allowing duplicate elements.");
        return this.createFlux(connection -> connection.sRandMember(this.rawKey(key), -count).map(this::readValue));
    }

    @Override
    public Mono<Boolean> delete(K key) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.template.doCreateMono(connection -> connection.keyCommands().del(this.rawKey(key))).map(l -> l != 0L);
    }

    private <T> Mono<T> createMono(Function<ReactiveSetCommands, Publisher<T>> function) {
        Assert.notNull(function, (String)"Function must not be null!");
        return this.template.doCreateMono(connection -> (Publisher)function.apply(connection.setCommands()));
    }

    private <T> Flux<T> createFlux(Function<ReactiveSetCommands, Publisher<T>> function) {
        Assert.notNull(function, (String)"Function must not be null!");
        return this.template.doCreateFlux(connection -> (Publisher)function.apply(connection.setCommands()));
    }

    private ByteBuffer rawKey(K key) {
        return this.serializationContext.getKeySerializationPair().write(key);
    }

    private List<K> getKeys(K key, Collection<K> otherKeys) {
        ArrayList<K> keys = new ArrayList<K>(1 + otherKeys.size());
        keys.add(key);
        keys.addAll(otherKeys);
        return keys;
    }

    private ByteBuffer rawValue(V value) {
        return this.serializationContext.getValueSerializationPair().write(value);
    }

    private V readValue(ByteBuffer buffer) {
        return this.serializationContext.getValueSerializationPair().read(buffer);
    }
}

