/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.repository.support;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.query.KeyValueQuery;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.redis.core.RedisKeyValueTemplate;
import org.springframework.data.redis.core.convert.IndexResolver;
import org.springframework.data.redis.core.convert.PathIndexResolver;
import org.springframework.data.redis.core.mapping.RedisPersistentEntity;
import org.springframework.data.redis.core.mapping.RedisPersistentProperty;
import org.springframework.data.redis.repository.query.ExampleQueryMapper;
import org.springframework.data.redis.repository.query.RedisOperationChain;
import org.springframework.data.redis.repository.support.DtoInstantiatingConverter;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.data.repository.query.QueryByExampleExecutor;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.data.util.Streamable;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class QueryByExampleRedisExecutor<T>
implements QueryByExampleExecutor<T>,
BeanFactoryAware,
BeanClassLoaderAware {
    private final EntityInformation<T, ?> entityInformation;
    private final RedisKeyValueTemplate keyValueTemplate;
    private final ExampleQueryMapper mapper;
    private final SpelAwareProxyProjectionFactory projectionFactory;
    private final EntityInstantiators entityInstantiators = new EntityInstantiators();

    public QueryByExampleRedisExecutor(EntityInformation<T, ?> entityInformation, RedisKeyValueTemplate keyValueTemplate) {
        this(entityInformation, keyValueTemplate, keyValueTemplate.getConverter().getIndexResolver() != null ? keyValueTemplate.getConverter().getIndexResolver() : new PathIndexResolver(keyValueTemplate.getMappingContext()));
    }

    public QueryByExampleRedisExecutor(EntityInformation<T, ?> entityInformation, RedisKeyValueTemplate keyValueTemplate, IndexResolver indexResolver) {
        Assert.notNull(entityInformation, (String)"EntityInformation must not be null!");
        Assert.notNull((Object)((Object)keyValueTemplate), (String)"RedisKeyValueTemplate must not be null!");
        Assert.notNull((Object)indexResolver, (String)"IndexResolver must not be null!");
        this.entityInformation = entityInformation;
        this.keyValueTemplate = keyValueTemplate;
        this.mapper = new ExampleQueryMapper((MappingContext<RedisPersistentEntity<?>, RedisPersistentProperty>)keyValueTemplate.getMappingContext(), indexResolver);
        this.projectionFactory = new SpelAwareProxyProjectionFactory();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.projectionFactory.setBeanFactory(beanFactory);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.projectionFactory.setBeanClassLoader(classLoader);
    }

    public <S extends T> Optional<S> findOne(Example<S> example) {
        return Optional.ofNullable(this.doFindOne(example));
    }

    @Nullable
    private <S extends T> S doFindOne(Example<S> example) {
        Iterator<S> iterator = this.doFind(example);
        if (iterator.hasNext()) {
            S result = iterator.next();
            if (iterator.hasNext()) {
                throw new IncorrectResultSizeDataAccessException(1);
            }
            return result;
        }
        return null;
    }

    private <S extends T> Iterator<S> doFind(Example<S> example) {
        RedisOperationChain operationChain = this.createQuery(example);
        KeyValueQuery query = new KeyValueQuery((Object)operationChain);
        return this.keyValueTemplate.find(query.limit(2), this.entityInformation.getJavaType()).iterator();
    }

    public <S extends T> Iterable<S> findAll(Example<S> example) {
        RedisOperationChain operationChain = this.createQuery(example);
        return this.keyValueTemplate.find(new KeyValueQuery((Object)operationChain), this.entityInformation.getJavaType());
    }

    public <S extends T> Iterable<S> findAll(Example<S> example, Sort sort) {
        throw new UnsupportedOperationException("Ordering is not supported");
    }

    public <S extends T> Page<S> findAll(Example<S> example, Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
        RedisOperationChain operationChain = this.createQuery(example);
        KeyValueQuery query = new KeyValueQuery((Object)operationChain);
        List result = (List)this.keyValueTemplate.find(query.orderBy(pageable.getSort()).skip(pageable.getOffset()).limit(pageable.getPageSize()), this.entityInformation.getJavaType());
        return PageableExecutionUtils.getPage((List)result, (Pageable)pageable, () -> operationChain.isEmpty() ? this.keyValueTemplate.count(this.entityInformation.getJavaType()) : this.keyValueTemplate.count(query, this.entityInformation.getJavaType()));
    }

    public <S extends T> long count(Example<S> example) {
        RedisOperationChain operationChain = this.createQuery(example);
        return this.keyValueTemplate.count(new KeyValueQuery((Object)operationChain), this.entityInformation.getJavaType());
    }

    public <S extends T> boolean exists(Example<S> example) {
        return this.count(example) > 0L;
    }

    public <S extends T, R> R findBy(Example<S> example, Function<FluentQuery.FetchableFluentQuery<S>, R> queryFunction) {
        Assert.notNull(example, (String)"Example must not be null!");
        Assert.notNull(queryFunction, (String)"Query function must not be null!");
        return queryFunction.apply(new FluentQueryByExample(example, example.getProbeType()));
    }

    private <S extends T> RedisOperationChain createQuery(Example<S> example) {
        Assert.notNull(example, (String)"Example must not be null!");
        return this.mapper.getMappedExample(example);
    }

    class FluentQueryByExample<S extends T, R>
    implements FluentQuery.FetchableFluentQuery<R> {
        private final Example<S> example;
        private final Sort sort;
        private final Class<?> domainType;
        private final Class<R> resultType;

        FluentQueryByExample(Example<S> example, Class<R> resultType) {
            this(example, Sort.unsorted(), resultType, resultType);
        }

        FluentQueryByExample(Example<S> example, Sort sort, Class<?> domainType, Class<R> resultType) {
            this.example = example;
            this.sort = sort;
            this.domainType = domainType;
            this.resultType = resultType;
        }

        public FluentQuery.FetchableFluentQuery<R> sortBy(Sort sort) {
            return new FluentQueryByExample<S, R>(this.example, sort, this.domainType, this.resultType);
        }

        public <R1> FluentQuery.FetchableFluentQuery<R1> as(Class<R1> resultType) {
            return new FluentQueryByExample<S, R1>(this.example, this.sort, this.domainType, resultType);
        }

        public FluentQuery.FetchableFluentQuery<R> project(Collection<String> properties) {
            return this;
        }

        @Nullable
        public R oneValue() {
            S one = QueryByExampleRedisExecutor.this.doFindOne(this.example);
            if (one != null) {
                return this.getConversionFunction(QueryByExampleRedisExecutor.this.entityInformation.getJavaType(), this.resultType).apply(one);
            }
            return null;
        }

        @Nullable
        public R firstValue() {
            Iterator<S> iterator = QueryByExampleRedisExecutor.this.doFind(this.example);
            if (iterator.hasNext()) {
                return this.getConversionFunction(QueryByExampleRedisExecutor.this.entityInformation.getJavaType(), this.resultType).apply(iterator.next());
            }
            return null;
        }

        public List<R> all() {
            return this.stream().collect(Collectors.toList());
        }

        public Page<R> page(Pageable pageable) {
            Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
            Function<Object, R> conversionFunction = this.getConversionFunction(QueryByExampleRedisExecutor.this.entityInformation.getJavaType(), this.resultType);
            List content = QueryByExampleRedisExecutor.this.findAll(this.example, pageable).stream().map(conversionFunction).collect(Collectors.toList());
            return PageableExecutionUtils.getPage(content, (Pageable)pageable, this::count);
        }

        public Stream<R> stream() {
            Function<Object, R> conversionFunction = this.getConversionFunction(QueryByExampleRedisExecutor.this.entityInformation.getJavaType(), this.resultType);
            if (this.sort.isSorted()) {
                return QueryByExampleRedisExecutor.this.findAll(this.example, (Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE, (Sort)this.sort)).stream().map(conversionFunction);
            }
            return Streamable.of(QueryByExampleRedisExecutor.this.findAll(this.example)).map(conversionFunction).stream();
        }

        public long count() {
            return QueryByExampleRedisExecutor.this.count(this.example);
        }

        public boolean exists() {
            return QueryByExampleRedisExecutor.this.exists(this.example);
        }

        private <P> Function<Object, P> getConversionFunction(Class<?> inputType, Class<P> targetType) {
            if (targetType.isAssignableFrom(inputType)) {
                return Function.identity();
            }
            if (targetType.isInterface()) {
                return o -> QueryByExampleRedisExecutor.this.projectionFactory.createProjection(targetType, o);
            }
            DtoInstantiatingConverter converter = new DtoInstantiatingConverter(targetType, (MappingContext<? extends RedisPersistentEntity<?>, RedisPersistentProperty>)QueryByExampleRedisExecutor.this.keyValueTemplate.getMappingContext(), QueryByExampleRedisExecutor.this.entityInstantiators);
            return o -> converter.convert(o);
        }
    }
}

