/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.function.BiConsumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.core.log.LogAccessor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.BackOffExecution;

class FailedRecordTracker {
    private final ThreadLocal<FailedRecord> failures = new ThreadLocal();
    private final BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer;
    private final boolean noRetries;
    private final BackOff backOff;
    private final LogAccessor logger;

    FailedRecordTracker(@Nullable BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer, BackOff backOff, LogAccessor logger) {
        Assert.notNull((Object)backOff, (String)"'backOff' cannot be null");
        if (recoverer == null) {
            FailedRecord failedRecord = this.failures.get();
            this.recoverer = (rec, thr) -> logger.error((Throwable)thr, (CharSequence)("Backoff " + (failedRecord == null ? "none" : failedRecord.getBackOffExecution()) + " exhausted for " + rec));
        } else {
            this.recoverer = recoverer;
        }
        this.noRetries = backOff.start().nextBackOff() == -1L;
        this.backOff = backOff;
        this.logger = logger;
    }

    boolean skip(ConsumerRecord<?, ?> record, Exception exception) {
        long nextBackOff;
        if (this.noRetries) {
            this.recover(record, exception);
            return true;
        }
        FailedRecord failedRecord = this.failures.get();
        if (failedRecord == null || this.newFailure(record, failedRecord)) {
            failedRecord = new FailedRecord(record.topic(), record.partition(), record.offset(), this.backOff.start());
            this.failures.set(failedRecord);
        }
        if ((nextBackOff = failedRecord.getBackOffExecution().nextBackOff()) != -1L) {
            try {
                Thread.sleep(nextBackOff);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return false;
        }
        this.recover(record, exception);
        this.failures.remove();
        return true;
    }

    private void recover(ConsumerRecord<?, ?> record, Exception exception) {
        try {
            this.recoverer.accept(record, exception);
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex, (CharSequence)"Recoverer threw exception");
        }
    }

    private boolean newFailure(ConsumerRecord<?, ?> record, FailedRecord failedRecord) {
        return !failedRecord.getTopic().equals(record.topic()) || failedRecord.getPartition() != record.partition() || failedRecord.getOffset() != record.offset();
    }

    void clearThreadState() {
        this.failures.remove();
    }

    BiConsumer<ConsumerRecord<?, ?>, Exception> getRecoverer() {
        return this.recoverer;
    }

    private static final class FailedRecord {
        private final String topic;
        private final int partition;
        private final long offset;
        private final BackOffExecution backOffExecution;

        FailedRecord(String topic, int partition, long offset, BackOffExecution backOffExecution) {
            this.topic = topic;
            this.partition = partition;
            this.offset = offset;
            this.backOffExecution = backOffExecution;
        }

        String getTopic() {
            return this.topic;
        }

        int getPartition() {
            return this.partition;
        }

        long getOffset() {
            return this.offset;
        }

        BackOffExecution getBackOffExecution() {
            return this.backOffExecution;
        }
    }
}

