/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.BeanUtils;
import org.springframework.kafka.support.JacksonMimeTypeModule;
import org.springframework.util.ClassUtils;

public final class JacksonUtils {
    private static final String UNUSED = "unused";

    public static ObjectMapper enhancedObjectMapper() {
        return JacksonUtils.enhancedObjectMapper(ClassUtils.getDefaultClassLoader());
    }

    public static ObjectMapper enhancedObjectMapper(ClassLoader classLoader) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(MapperFeature.DEFAULT_VIEW_INCLUSION, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JacksonUtils.registerWellKnownModulesIfAvailable(objectMapper, classLoader);
        return objectMapper;
    }

    private static void registerWellKnownModulesIfAvailable(ObjectMapper objectMapper, ClassLoader classLoader) {
        objectMapper.registerModule((Module)new JacksonMimeTypeModule());
        try {
            Class jdk8Module = ClassUtils.forName((String)"com.fasterxml.jackson.datatype.jdk8.Jdk8Module", (ClassLoader)classLoader);
            objectMapper.registerModule((Module)BeanUtils.instantiateClass((Class)jdk8Module));
        }
        catch (ClassNotFoundException jdk8Module) {
            // empty catch block
        }
        try {
            Class javaTimeModule = ClassUtils.forName((String)"com.fasterxml.jackson.datatype.jsr310.JavaTimeModule", (ClassLoader)classLoader);
            objectMapper.registerModule((Module)BeanUtils.instantiateClass((Class)javaTimeModule));
        }
        catch (ClassNotFoundException javaTimeModule) {
            // empty catch block
        }
        if (ClassUtils.isPresent((String)"org.joda.time.LocalDate", (ClassLoader)classLoader)) {
            try {
                Class jodaModule = ClassUtils.forName((String)"com.fasterxml.jackson.datatype.joda.JodaModule", (ClassLoader)classLoader);
                objectMapper.registerModule((Module)BeanUtils.instantiateClass((Class)jodaModule));
            }
            catch (ClassNotFoundException jodaModule) {
                // empty catch block
            }
        }
        if (ClassUtils.isPresent((String)"kotlin.Unit", (ClassLoader)classLoader)) {
            try {
                Class kotlinModule = ClassUtils.forName((String)"com.fasterxml.jackson.module.kotlin.KotlinModule", (ClassLoader)classLoader);
                objectMapper.registerModule((Module)BeanUtils.instantiateClass((Class)kotlinModule));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    private JacksonUtils() {
    }
}

