/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.im.server;

import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.TioConfig;
import org.tio.core.exception.TioDecodeException;
import org.tio.core.intf.Packet;
import org.tio.core.utils.ByteBufferUtils;
import org.tio.server.intf.ServerAioHandler;
import org.tio.sitexxx.im.common.Command;
import org.tio.sitexxx.im.common.ImPacket;
import org.tio.sitexxx.im.server.PacketDispatcher;
import org.tio.utils.json.Json;

public class TioSiteImServerAioHandler
implements ServerAioHandler {
    private static Logger log = LoggerFactory.getLogger(TioSiteImServerAioHandler.class);
    private PacketDispatcher packetDispatcher;

    public TioSiteImServerAioHandler(PacketDispatcher packetDispatcher) {
        this.setPacketDispatcher(packetDispatcher);
    }

    public ImPacket decode(ByteBuffer buffer, int limit, int position, int readableLength, ChannelContext channelContext) throws TioDecodeException {
        int headerLength = 5;
        if (readableLength < headerLength) {
            return null;
        }
        short bodyLength = ByteBufferUtils.readShort((ByteBuffer)buffer);
        if (bodyLength > 0x219999 || bodyLength < 0) {
            throw new TioDecodeException("bodyLength [" + bodyLength + "] is not right, remote:" + channelContext.getClientNode());
        }
        int neededLength = headerLength + bodyLength;
        if (readableLength < neededLength) {
            channelContext.setPacketNeededLength(Integer.valueOf(neededLength));
            return null;
        }
        short commandValue = ByteBufferUtils.readShort((ByteBuffer)buffer);
        Command command = Command.from((Short)commandValue);
        if (command == null) {
            throw new TioDecodeException("\u6d88\u606f\u547d\u4ee4\u7801\u3010" + commandValue + "\u3011\u4e0d\u6b63\u786e");
        }
        byte gzip = ByteBufferUtils.read((ByteBuffer)buffer);
        ImPacket imPacket = new ImPacket();
        imPacket.setCommand(command);
        if (bodyLength > 0) {
            boolean isGzipped;
            byte[] dst = new byte[bodyLength];
            buffer.get(dst);
            boolean bl = isGzipped = gzip == 1;
            if (isGzipped) {
                try {
                    byte[] unGzippedBytes = ZipUtil.unGzip((byte[])dst);
                    imPacket.setBody(unGzippedBytes);
                }
                catch (Throwable e) {
                    log.error("{}, \u89e3\u538b\u5931\u8d25, bodyLength:{}, buffer:{}", new Object[]{channelContext, (int)bodyLength, buffer});
                    throw new TioDecodeException(e);
                }
            } else {
                imPacket.setBody(dst);
            }
            try {
                imPacket.setBodyStr(new String(imPacket.getBody(), "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                log.error("", (Throwable)e);
            }
        }
        return imPacket;
    }

    public ByteBuffer encode(Packet packet, TioConfig tioConfig, ChannelContext channelContext) {
        ImPacket imPacket = (ImPacket)packet;
        byte[] body = imPacket.getBody();
        if (body == null) {
            Object bodyObj;
            String bodyStr = imPacket.getBodyStr();
            if (StrUtil.isBlank((CharSequence)bodyStr) && (bodyObj = imPacket.getBodyObj()) != null) {
                bodyStr = Json.toJson((Object)bodyObj);
            }
            if (StrUtil.isNotBlank((CharSequence)bodyStr)) {
                try {
                    body = bodyStr.getBytes("utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    log.error("", (Throwable)e);
                }
            }
        }
        int bodyLen = 0;
        boolean isCompress = false;
        if (body != null && (bodyLen = body.length) > 300) {
            try {
                byte[] gzipedbody = ZipUtil.gzip((byte[])body);
                if (gzipedbody.length < body.length) {
                    log.info("\u538b\u7f29\u524d:{}, \u538b\u7f29\u540e:{}", (Object)body.length, (Object)gzipedbody.length);
                    body = gzipedbody;
                    bodyLen = gzipedbody.length;
                    isCompress = true;
                }
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
        }
        int allLen = 5 + bodyLen;
        ByteBuffer buffer = ByteBuffer.allocate(allLen);
        buffer.order(tioConfig.getByteOrder());
        buffer.putShort((short)bodyLen);
        buffer.putShort(imPacket.getCommand().getValue());
        if (isCompress) {
            buffer.put((byte)1);
        } else {
            buffer.put((byte)0);
        }
        if (body != null) {
            buffer.put(body);
        }
        return buffer;
    }

    public void handler(Packet packet, ChannelContext channelContext) throws Exception {
        ImPacket imPacket = (ImPacket)packet;
        this.packetDispatcher.dispatch(imPacket, channelContext, false);
    }

    public PacketDispatcher getPacketDispatcher() {
        return this.packetDispatcher;
    }

    public void setPacketDispatcher(PacketDispatcher packetDispatcher) {
        this.packetDispatcher = packetDispatcher;
    }
}

