/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.im.server.handler;

import cn.hutool.core.util.StrUtil;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.sitexxx.im.common.Command;
import org.tio.sitexxx.im.common.CommandHandler;
import org.tio.sitexxx.im.common.ImPacket;
import org.tio.sitexxx.im.common.ImSessionContext;
import org.tio.sitexxx.im.common.bs.HandshakeReq;
import org.tio.sitexxx.im.common.bs.UpdateTokenReq;
import org.tio.sitexxx.im.common.utils.ImUtils;
import org.tio.sitexxx.im.server.Ims;
import org.tio.sitexxx.im.server.handler.ImServerHandler;
import org.tio.sitexxx.service.model.system.User;
import org.tio.utils.json.Json;

@CommandHandler(value=Command.UpdateTokenReq)
public class UpdateTokenReqHandler
implements ImServerHandler {
    private static Logger log = LoggerFactory.getLogger(UpdateTokenReqHandler.class);
    private static final ImPacket updateTokenRespPacket = new ImPacket(Command.UpdateTokenResp);

    @Override
    public void handler(ImPacket packet, ChannelContext channelContext, boolean isWebsocket) throws Exception {
        ImSessionContext imSessionContext = ImUtils.getImSessionContext((ChannelContext)channelContext);
        UpdateTokenReq updateTokenReq = (UpdateTokenReq)Json.toBean((String)packet.getBodyStr(), UpdateTokenReq.class);
        String newToken = updateTokenReq.getT();
        HandshakeReq handshakeReq = ImUtils.getHandshakeReq((ChannelContext)channelContext);
        String oldToken = handshakeReq.getToken();
        handshakeReq.setToken(newToken);
        User user = null;
        if (!Objects.equals(newToken, oldToken)) {
            Tio.unbindToken((ChannelContext)channelContext);
            Tio.unbindUser((ChannelContext)channelContext);
        }
        if (StrUtil.isNotBlank((CharSequence)newToken)) {
            Tio.bindToken((ChannelContext)channelContext, (String)newToken);
            String userid = null;
            user = ImUtils.getUser((String)newToken);
            if (user != null) {
                userid = user.getId();
            }
            if (userid != null) {
                Tio.bindUser((ChannelContext)channelContext, (String)(userid + ""));
                imSessionContext.setUid(userid);
            }
        }
        ImUtils.rebindGroups((ChannelContext)channelContext);
        Ims.send(channelContext, updateTokenRespPacket);
    }
}

