/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.im.server.handler.wx;

import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.jfinal.kit.Ret;
import org.tio.sitexxx.im.server.TioSiteImServerStarter;
import org.tio.sitexxx.im.server.handler.wx.WxChatApi;
import org.tio.sitexxx.im.server.handler.wx.WxSynApi;
import org.tio.sitexxx.service.model.main.WxGroup;
import org.tio.sitexxx.service.model.main.WxGroupMsg;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.service.chat.ChatMsgService;
import org.tio.sitexxx.service.utils.RetUtils;
import org.tio.sitexxx.service.vo.AfterGroupMsgSendVo;
import org.tio.sitexxx.service.vo.Devicetype;
import org.tio.sitexxx.service.vo.wx.FocusVo;
import org.tio.utils.BinaryUtils;
import org.tio.utils.json.Json;
import org.tio.utils.lock.LockUtils;

public class WxChatQueueApi {
    private static Logger log = LoggerFactory.getLogger(WxChatQueueApi.class);
    public static final WxChatQueueApi me = new WxChatQueueApi();
    private static final int focusIndex = 5;
    private static ArrayList<LinkedBlockingQueue<FocusVo>> focusQueue = new ArrayList();
    private static final int groupSendMsgAfterIndex = 10;
    private static ArrayList<LinkedBlockingQueue<AfterGroupMsgSendVo>> groupSendMsgAfterQueue = new ArrayList();

    public static void wxQueueInit() {
        WxChatQueueApi.focusQueueInit();
        WxChatQueueApi.groupSendMsgAfterQueueInit();
    }

    public static void focusQueueInit() {
        int i = 0;
        while (i < 5) {
            final int qindex = i++;
            focusQueue.add(new LinkedBlockingQueue());
            new Thread(new Runnable(){

                @Override
                public void run() {
                    int error = 0;
                    block9: while (true) {
                        FocusVo focusVo = null;
                        try {
                            focusVo = (FocusVo)((LinkedBlockingQueue)focusQueue.get(qindex)).take();
                            error = 0;
                        }
                        catch (InterruptedException e1) {
                            log.error("\u961f\u5217\u83b7\u53d6\u7126\u70b9\u5bf9\u8c61\u5931\u8d25\uff0c\u961f\u5217index:{}\uff0c\u9519\u8bef\u6b21\u6570\uff1a{}", new Object[]{qindex, ++error, e1});
                            if (error < 5) continue;
                            log.error("\u961f\u5217\u8054\u7cfb\u83b7\u53d6\u7126\u70b9\u5bf9\u8c615\u6b21\u5931\u8d25\uff0c\u9000\u51fa\u5faa\u73af\uff0c\u961f\u5217index:{}", (Object)qindex);
                            break;
                        }
                        try {
                            if (focusVo == null) {
                                log.error("\u7126\u70b9\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u961f\u5217index:{}", (Object)qindex);
                                continue;
                            }
                            if (focusVo.getOper() == null) {
                                log.error("\u7126\u70b9\u5bf9\u8c61\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a,focusvo:{}", (Object)Json.toJson((Object)focusVo));
                                continue;
                            }
                            switch (focusVo.getOper()) {
                                case 1: {
                                    Ret ret = ChatMsgService.joinDeal((FocusVo)focusVo);
                                    Byte chatmode = focusVo.getChatmode();
                                    String uid = focusVo.getUid();
                                    WxChatApi.focusNtf(uid, focusVo.getRchatlinkid());
                                    ChannelContext channelContext = Tio.getByChannelContextId((TioConfig)TioSiteImServerStarter.serverTioConfigWs, (String)focusVo.getChannelid());
                                    if (ret.isFail()) {
                                        if (Objects.equals(chatmode, (byte)2)) {
                                            WxChatApi.sendFriendErrorMsg(channelContext, uid, uid, uid, focusVo.getRchatlinkid(), (Integer)30001, RetUtils.getRetMsg((Ret)ret));
                                            continue block9;
                                        }
                                        WxChatApi.sendFriendErrorMsg(channelContext, uid, uid, uid, focusVo.getRchatlinkid(), (Integer)20001, RetUtils.getRetMsg((Ret)ret));
                                        continue block9;
                                    }
                                    boolean isToRead = (Boolean)RetUtils.getOkTData((Ret)ret);
                                    if (!isToRead) continue block9;
                                    Long tochatlinkid = (Long)RetUtils.getOkTData((Ret)ret, (String)"tochatlinkid");
                                    String touid = (String)RetUtils.getOkTData((Ret)ret, (String)"touid");
                                    if (WxSynApi.isSynVersion()) {
                                        if (!Objects.equals(chatmode, (byte)1)) continue block9;
                                        WxSynApi.synMsgFocusJoin(tochatlinkid, touid, focusVo);
                                        break;
                                    }
                                    if (Objects.equals(chatmode, (byte)2)) {
                                        WxChatApi.userChatOper(channelContext, focusVo.getUid(), -focusVo.getGroupid().longValue(), (byte)7, "\u4f60\u5df2\u8bfb\u7fa4\u6d88\u606f", focusVo.getChannelid());
                                        break;
                                    }
                                    WxChatApi.userChatOper(channelContext, touid, tochatlinkid, (byte)7, "\u597d\u53cb\u5df2\u8bfb\u4f60\u7684\u6d88\u606f", focusVo.getChannelid());
                                    break;
                                }
                                case 2: {
                                    ChatMsgService.leaveDeal((FocusVo)focusVo);
                                    WxChatApi.focusNtf(focusVo.getUid(), null);
                                    break;
                                }
                                case 3: {
                                    ChatMsgService.refreshDeal((FocusVo)focusVo);
                                    break;
                                }
                                default: {
                                    log.error("\u65e0\u6548\u7126\u70b9\u64cd\u4f5c\uff1aopercode:{}", (Object)focusVo.getOper());
                                }
                            }
                        }
                        catch (Exception e) {
                            log.error("", (Throwable)e);
                        }
                    }
                }
            }).start();
        }
    }

    public static void groupSendMsgAfterQueueInit() {
        int i = 0;
        while (i < 10) {
            final int qindex = i++;
            groupSendMsgAfterQueue.add(new LinkedBlockingQueue());
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int error = 0;
                    while (true) {
                        AfterGroupMsgSendVo afterVo = null;
                        try {
                            afterVo = (AfterGroupMsgSendVo)((LinkedBlockingQueue)groupSendMsgAfterQueue.get(qindex)).take();
                            error = 0;
                        }
                        catch (InterruptedException e1) {
                            log.error("\u961f\u5217\u83b7\u53d6\u7fa4\u53d1\u9001\u5bf9\u8c61\u5931\u8d25\uff0c\u961f\u5217index:{}\uff0c\u9519\u8bef\u6b21\u6570\uff1a{}", new Object[]{qindex, ++error, e1});
                            if (error < 5) continue;
                            log.error("\u961f\u5217\u8054\u7cfb\u83b7\u53d6\u7fa4\u53d1\u9001\u5bf9\u8c615\u6b21\u5931\u8d25\uff0c\u9000\u51fa\u5faa\u73af\uff0c\u961f\u5217index:{}", (Object)qindex);
                            break;
                        }
                        try {
                            if (afterVo == null) {
                                log.error("\u7fa4\u6d88\u606f\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u961f\u5217index:{}", (Object)qindex);
                                continue;
                            }
                            if (afterVo.getMsg() == null) {
                                log.error("\u7fa4\u6d88\u606f\u5bf9\u8c61\u6d88\u606f\u4e3a\u7a7a,focusvo:{}", (Object)Json.toJson((Object)afterVo));
                                continue;
                            }
                            ReentrantReadWriteLock rwLock = LockUtils.getReentrantReadWriteLock((String)("chat.queue.lock.." + afterVo.getMsg().getGroupid()), WxGroup.class);
                            ReentrantReadWriteLock.WriteLock writeLock = rwLock.writeLock();
                            writeLock.lock();
                            try {
                                ChatMsgService.me.afterSendGroupChatMsg(afterVo.getMsg(), Short.valueOf((short)1), afterVo.getViewflag());
                                ChatMsgService.me.afterSendGroupChatMsg(afterVo.getMsg(), null, afterVo.getViewflag());
                                if (StrUtil.isNotBlank((CharSequence)afterVo.getAts())) {
                                    ChatMsgService.me.afterSendGroupAtMsg(afterVo.getMsg(), afterVo.getAts(), Short.valueOf((short)1), Byte.valueOf((byte)1));
                                }
                                ChatMsgService.me.groupMetaStat(afterVo.getMsg().getGroupid(), afterVo.getMsg().getId(), false);
                            }
                            catch (Exception exception) {}
                            continue;
                            finally {
                                writeLock.unlock();
                            }
                        }
                        catch (Exception e) {
                            log.error("", (Throwable)e);
                        }
                    }
                }
            }).start();
        }
    }

    public static void leaveFocusQueue(User curr, Byte devicetype, String cid) {
        FocusVo focusVo = new FocusVo();
        focusVo.setUid(curr.getId());
        focusVo.setDevicetype(devicetype);
        focusVo.setOper(Byte.valueOf((byte)2));
        focusVo.setChannelid(cid);
        int queueindex = BinaryUtils.uidIndex((String)curr.getId()) % 5;
        try {
            focusQueue.get(queueindex).put(focusVo);
        }
        catch (InterruptedException e) {
            log.error("", (Throwable)e);
        }
    }

    public static void refreshFocusQueue(User curr, Byte devicetype, String cid) {
        FocusVo focusVo = new FocusVo();
        focusVo.setUid(curr.getId());
        focusVo.setDevicetype(devicetype);
        focusVo.setOper(Byte.valueOf((byte)3));
        focusVo.setChannelid(cid);
        int queueindex = BinaryUtils.uidIndex((String)curr.getId()) % 5;
        try {
            focusQueue.get(queueindex).put(focusVo);
        }
        catch (InterruptedException e) {
            log.error("", (Throwable)e);
        }
    }

    public static void joinFocusQueue(ChannelContext channelContext, User curr, Long chatlinkid, Long groupid, Byte chatmode, Byte devicetype, Integer ipid) {
        if (Objects.equals(devicetype, Devicetype.IOS.getValue()) || Objects.equals(devicetype, Devicetype.ANDROID.getValue())) {
            devicetype = Devicetype.APP.getValue();
        }
        FocusVo focusVo = new FocusVo();
        focusVo.setChannelid(channelContext.getId());
        focusVo.setUid(curr.getId());
        focusVo.setChatlinkid(chatlinkid);
        focusVo.setDevicetype(devicetype);
        focusVo.setChatmode(chatmode);
        focusVo.setIpid(ipid);
        focusVo.setGroupid(groupid);
        focusVo.setOper(Byte.valueOf((byte)1));
        int queueindex = BinaryUtils.uidIndex((String)curr.getId()) % 5;
        try {
            focusQueue.get(queueindex).put(focusVo);
        }
        catch (InterruptedException e) {
            log.error("", (Throwable)e);
        }
    }

    public static void joinGroupSendMsgAfterQueue(Long groupid, WxGroupMsg msg, Short notreadcount, Byte viewflag, String ats) {
        AfterGroupMsgSendVo sendVo = new AfterGroupMsgSendVo(msg, notreadcount, viewflag, ats);
        Long queueindex = groupid % 10L;
        try {
            groupSendMsgAfterQueue.get(queueindex.intValue()).put(sendVo);
        }
        catch (InterruptedException e) {
            log.error("", (Throwable)e);
        }
    }
}

