/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.im.server.handler.wx.call;

import cn.hutool.core.util.StrUtil;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.core.intf.Packet;
import org.tio.sitexxx.im.common.Command;
import org.tio.sitexxx.im.common.CommandHandler;
import org.tio.sitexxx.im.common.ImPacket;
import org.tio.sitexxx.im.common.bs.wx.webrtc.WxCall02_2CancelNtf;
import org.tio.sitexxx.im.common.bs.wx.webrtc.WxCall14EndNtf;
import org.tio.sitexxx.im.server.TioSiteImServerStarter;
import org.tio.sitexxx.im.server.handler.AbsImServerHandler;
import org.tio.sitexxx.im.server.handler.wx.WxChatApi;
import org.tio.sitexxx.im.server.handler.wx.call.WxCallUtils;
import org.tio.sitexxx.service.cache.CacheConfig;
import org.tio.sitexxx.service.cache.Caches;
import org.tio.sitexxx.service.model.main.WxCallItem;
import org.tio.sitexxx.service.model.main.WxChatUserItem;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.service.chat.ChatIndexService;
import org.tio.sitexxx.service.service.chat.ChatService;
import org.tio.sitexxx.service.service.wx.WxCallItemService;
import org.tio.sitexxx.service.vo.SimpleUser;
import org.tio.sitexxx.service.vo.wx.WxCallItemVo;
import org.tio.utils.cache.ICache;
import org.tio.utils.json.Json;
import org.tio.utils.lock.LockUtils;
import org.tio.utils.lock.ReadWriteLockHandler;

@CommandHandler(value=Command.WxCall02_1CancelReq)
public class WxCall02_1CancelReqHandler
extends AbsImServerHandler {
    private static Logger log = LoggerFactory.getLogger(WxCall02_1CancelReqHandler.class);
    public static final WxCall02_1CancelReqHandler me = new WxCall02_1CancelReqHandler();

    @Override
    public void handler(ImPacket packet, final ChannelContext channelContext, boolean isWebsocket, final User curr, SimpleUser currSimpleUser) throws Exception {
        try {
            LockUtils.runWriteOrWaitRead((String)("wx_call_cancel" + curr.getId()), WxCallUtils.class, (ReadWriteLockHandler)new ReadWriteLockHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void write() throws Exception {
                    block19: {
                        WxCallItem wxCallItem = WxCallItemService.me.getCanceledItem(curr.getId());
                        if (wxCallItem == null) {
                            log.error("\u53d6\u6d88\u4f1a\u8bdd\u4e3a\u7a7a");
                            return;
                        }
                        log.error("status-{},{}", (Object)wxCallItem.getStatus(), (Object)Json.toJson((Object)wxCallItem));
                        if (Objects.equals((byte)1, wxCallItem.getStatus())) {
                            WxCallItem newCallItem = WxCallUtils.endCall(channelContext, wxCallItem.getId(), curr.getId(), (byte)10);
                            WxCall02_2CancelNtf ntf = new WxCall02_2CancelNtf();
                            if (newCallItem == null) {
                                ntf.fill(wxCallItem);
                            } else {
                                ntf.fill(newCallItem);
                            }
                            ImPacket toPacket = new ImPacket(Command.WxCall02_2CancelNtf, (Object)ntf);
                            Tio.sendToId((TioConfig)TioSiteImServerStarter.serverTioConfigApp, (String)ntf.getFromcid(), (Packet)toPacket);
                            Tio.sendToUser((TioConfig)TioSiteImServerStarter.serverTioConfigApp, (String)(ntf.getTouid() + ""), (Packet)toPacket);
                        } else {
                            try {
                                if (Objects.equals(wxCallItem.getStatus(), (byte)4)) {
                                    return;
                                }
                                wxCallItem.setHangupuid(curr.getId());
                                wxCallItem.setHanguptype(Byte.valueOf((byte)10));
                                Date date = new Date();
                                wxCallItem.setStatus(Byte.valueOf((byte)4));
                                wxCallItem.setEndtime(date);
                                if (wxCallItem.getConnectedtime() != null) {
                                    wxCallItem.setCallduration(Long.valueOf(date.getTime() - wxCallItem.getConnectedtime().getTime()));
                                }
                                WxCall14EndNtf ntf = new WxCall14EndNtf();
                                ntf.fill(wxCallItem);
                                ImPacket toPacket = new ImPacket(Command.WxCall14EndNtf, (Object)ntf);
                                Tio.sendToId((TioConfig)TioSiteImServerStarter.serverTioConfigApp, (String)ntf.getFromcid(), (Packet)toPacket);
                                if (StrUtil.isNotBlank((CharSequence)ntf.getTocid())) {
                                    Tio.sendToId((TioConfig)TioSiteImServerStarter.serverTioConfigApp, (String)ntf.getTocid(), (Packet)toPacket);
                                } else {
                                    Tio.sendToUser((TioConfig)TioSiteImServerStarter.serverTioConfigApp, (String)(ntf.getTouid() + ""), (Packet)toPacket);
                                }
                                wxCallItem.update();
                                WxCallUtils.clearCallId(wxCallItem.getFromcid());
                                WxCallUtils.clearCallId(wxCallItem.getTocid());
                                try {
                                    WxCallItemVo callItemVo = new WxCallItemVo();
                                    Byte contenttype = 10;
                                    if (Objects.equals(wxCallItem.getType(), (byte)1)) {
                                        contenttype = 11;
                                    }
                                    callItemVo.setCalltype(contenttype);
                                    callItemVo.setDuration(wxCallItem.getCallduration());
                                    callItemVo.setHanguptype(Byte.valueOf((byte)10));
                                    callItemVo.setHangupuid(curr.getId());
                                    callItemVo.setDevicetype(wxCallItem.getTodevice());
                                    WxChatUserItem userItem = ChatIndexService.fdUserIndex((String)wxCallItem.getFromuid(), (String)wxCallItem.getTouid());
                                    if (!ChatService.friendExistChat((WxChatUserItem)userItem)) {
                                        log.error("\u97f3\u89c6\u9891\u901a\u8bdd\u5f02\u5e38,\u4f1a\u8bdd\u672a\u6fc0\u6d3b\uff1auid:{},touid:{},callid:{}", new Object[]{wxCallItem.getFromuid(), wxCallItem.getTouid(), wxCallItem.getId()});
                                        break block19;
                                    }
                                    WxChatApi.sendFdMsgEach(channelContext, Json.toJson((Object)callItemVo), contenttype, wxCallItem.getFromuid(), wxCallItem.getTouid(), userItem.getChatlinkid(), (Byte)2);
                                }
                                catch (Exception e) {
                                    log.error("", (Throwable)e);
                                }
                            }
                            catch (Exception e) {
                                log.error("", (Throwable)e);
                            }
                            finally {
                                ICache cache = Caches.getCache((CacheConfig)CacheConfig.WX_IS_CALLING);
                                cache.remove(wxCallItem.getFromuid() + "");
                                cache.remove(wxCallItem.getTouid() + "");
                                cache.remove(wxCallItem.getFromuid() + "_" + wxCallItem.getFromdevice());
                                cache.remove(wxCallItem.getTouid() + "_" + wxCallItem.getTodevice());
                                WxCallItemService.me.clearWxCallItem(wxCallItem.getId());
                            }
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }
}

