/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.im.server.handler.wx.call;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.core.intf.Packet;
import org.tio.sitexxx.im.common.Command;
import org.tio.sitexxx.im.common.CommandHandler;
import org.tio.sitexxx.im.common.ImPacket;
import org.tio.sitexxx.im.common.ImSessionContext;
import org.tio.sitexxx.im.common.bs.wx.webrtc.WxCall03ReplyReq;
import org.tio.sitexxx.im.common.bs.wx.webrtc.WxCall04ReplyNtf;
import org.tio.sitexxx.im.common.bs.wx.webrtc.WxCallRespNtf;
import org.tio.sitexxx.im.common.bs.wx.webrtc.base.WxCallBase;
import org.tio.sitexxx.im.common.utils.ImUtils;
import org.tio.sitexxx.im.server.handler.AbsImServerHandler;
import org.tio.sitexxx.im.server.handler.wx.WxChatApi;
import org.tio.sitexxx.im.server.handler.wx.call.WxCallUtils;
import org.tio.sitexxx.service.cache.CacheConfig;
import org.tio.sitexxx.service.cache.Caches;
import org.tio.sitexxx.service.model.main.WxCallItem;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.service.base.IpInfoService;
import org.tio.sitexxx.service.service.wx.WxCallItemService;
import org.tio.sitexxx.service.vo.SimpleUser;
import org.tio.utils.cache.ICache;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.json.Json;
import org.tio.utils.lock.LockUtils;
import org.tio.utils.lock.ReadWriteLockHandler;

@CommandHandler(value=Command.WxCall03ReplyReq)
public class WxCall03ReplyReqHandler
extends AbsImServerHandler {
    private static Logger log = LoggerFactory.getLogger(WxCall03ReplyReqHandler.class);
    public static final WxCall03ReplyReqHandler me = new WxCall03ReplyReqHandler();

    @Override
    public void handler(final ImPacket packet, final ChannelContext channelContext, final boolean isWebsocket, final User curr, SimpleUser currSimpleUser) throws Exception {
        final WxCall03ReplyReq req = (WxCall03ReplyReq)Json.toBean((String)packet.getBodyStr(), WxCall03ReplyReq.class);
        WxCallItem wxCallItem = WxCallItemService.me.getById(req.getId());
        if (wxCallItem == null) {
            return;
        }
        Long callId = wxCallItem.getId();
        try {
            LockUtils.runWriteOrWaitRead((String)("wx_call_reply" + callId), WxCallUtils.class, (ReadWriteLockHandler)new ReadWriteLockHandler(){

                public void write() throws Exception {
                    WxCallItem wxCallItem = WxCallItemService.me.getById(req.getId());
                    Byte devicetype = ImUtils.getDevicetype((ChannelContext)channelContext).getValue();
                    if (wxCallItem == null) {
                        return;
                    }
                    if (!Objects.equals(wxCallItem.getStatus(), (byte)1)) {
                        return;
                    }
                    if (Objects.equals(req.getResult(), (byte)3) && WxChatApi.isManyOnline(curr.getId(), devicetype)) {
                        return;
                    }
                    ImSessionContext imSessionContext = ImUtils.getImSessionContext((ChannelContext)channelContext);
                    imSessionContext.setCallId(wxCallItem.getId());
                    Date date = new Date();
                    wxCallItem.setTocid(channelContext.getId());
                    wxCallItem.setTodevice(devicetype);
                    wxCallItem.setResptime(date);
                    wxCallItem.setStatus(Byte.valueOf((byte)2));
                    wxCallItem.setRespwait(Long.valueOf(date.getTime() - wxCallItem.getCalltime().getTime()));
                    wxCallItem.setToipid(IpInfoService.ME.save(channelContext.getClientNode().getIp()).getId());
                    wxCallItem.update();
                    WxCallItemService.me.clearWxCallItem(wxCallItem.getId());
                    String summary = Command.WxCall03ReplyReq.name();
                    WxCallUtils.saveCallLog(packet, channelContext, isWebsocket, curr, (WxCallBase)req, summary);
                    String fromcid = wxCallItem.getFromcid();
                    WxCall04ReplyNtf ntf = new WxCall04ReplyNtf();
                    ntf.fill(wxCallItem);
                    ntf.setResult(req.getResult());
                    WxCallItem endCallItem = null;
                    if (!Objects.equals(req.getResult(), (byte)1)) {
                        if (StrUtil.isNotBlank((CharSequence)req.getReason())) {
                            ntf.setReason(req.getReason());
                        } else if (Objects.equals(req.getResult(), (byte)2)) {
                            ntf.setReason("\u5bf9\u65b9\u6682\u65f6\u4e0d\u65b9\u4fbf\u63a5\u542c");
                        } else if (Objects.equals(req.getResult(), (byte)3)) {
                            ntf.setReason("\u5bf9\u65b9\u6ca1\u6709\u901a\u8bdd\u7684\u8bbe\u5907");
                            ntf.setResult(Byte.valueOf((byte)2));
                        }
                        endCallItem = WxCallUtils.endCall(channelContext, req.getId(), curr.getId(), (byte)2);
                    }
                    ImPacket toPacket = new ImPacket(Command.WxCall04ReplyNtf, (Object)ntf);
                    Tio.sendToId((TioConfig)channelContext.tioConfig, (String)fromcid, (Packet)toPacket);
                    WxCallRespNtf resp = new WxCallRespNtf();
                    if (endCallItem != null) {
                        resp.fill(endCallItem);
                    } else {
                        resp.fill(wxCallItem);
                    }
                    resp.setContextid(channelContext.getId());
                    resp.setResult(req.getResult());
                    resp.setSelf(Byte.valueOf((byte)1));
                    ICache cache = Caches.getCache((CacheConfig)CacheConfig.WX_IS_CALLING);
                    cache.put(curr.getId() + "_" + devicetype, (Serializable)req.getId());
                    ImPacket selfPacket = new ImPacket(Command.WxCallRespNtf, (Object)resp);
                    Tio.sendToUser((TioConfig)channelContext.tioConfig, (String)(curr.getId() + ""), (Packet)selfPacket);
                }
            });
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }
}

