/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.im.server.handler.wx.call;

import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.core.intf.Packet;
import org.tio.sitexxx.im.common.Command;
import org.tio.sitexxx.im.common.CommandHandler;
import org.tio.sitexxx.im.common.ImPacket;
import org.tio.sitexxx.im.common.bs.wx.webrtc.WxCall07AnswerSdpReq;
import org.tio.sitexxx.im.common.bs.wx.webrtc.WxCall08AnswerSdpNtf;
import org.tio.sitexxx.im.common.bs.wx.webrtc.base.WxCallBase;
import org.tio.sitexxx.im.server.handler.AbsImServerHandler;
import org.tio.sitexxx.im.server.handler.wx.call.WxCallUtils;
import org.tio.sitexxx.service.model.main.WxCallItem;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.service.wx.WxCallItemService;
import org.tio.sitexxx.service.vo.SimpleUser;
import org.tio.utils.json.Json;

@CommandHandler(value=Command.WxCall07AnswerSdpReq)
public class WxCall07AnswerSdpReqHandler
extends AbsImServerHandler {
    private static Logger log = LoggerFactory.getLogger(WxCall07AnswerSdpReqHandler.class);
    public static final WxCall07AnswerSdpReqHandler me = new WxCall07AnswerSdpReqHandler();

    @Override
    public void handler(ImPacket packet, ChannelContext channelContext, boolean isWebsocket, User curr, SimpleUser currSimpleUser) throws Exception {
        WxCall07AnswerSdpReq req = (WxCall07AnswerSdpReq)Json.toBean((String)packet.getBodyStr(), WxCall07AnswerSdpReq.class);
        WxCallItem wxCallItem = WxCallItemService.me.getById(req.getId());
        String summary = Command.WxCall07AnswerSdpReq.name();
        WxCallUtils.saveCallLog(packet, channelContext, isWebsocket, curr, (WxCallBase)req, summary);
        WxCall08AnswerSdpNtf ntf = new WxCall08AnswerSdpNtf();
        ntf.fill(wxCallItem);
        ntf.setSdp(req.getSdp());
        ImPacket toPacket = new ImPacket(Command.WxCall08AnswerSdpNtf, (Object)ntf);
        Tio.sendToId((TioConfig)channelContext.tioConfig, (String)ntf.getFromcid(), (Packet)toPacket);
        WxCall07AnswerSdpReqHandler.updateStatusWhenStreamFinished(wxCallItem);
    }

    public static void updateStatusWhenStreamFinished(WxCallItem wxCallItem) {
        if (!Objects.equals(wxCallItem.getStatus(), (byte)3)) {
            Date date = new Date();
            wxCallItem.setStatus(Byte.valueOf((byte)3));
            wxCallItem.setConnectedtime(date);
            wxCallItem.setStreamwait(Long.valueOf(date.getTime() - wxCallItem.getResptime().getTime()));
            WxCallUtils.updateItem(wxCallItem);
        }
    }
}

