/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.SimpleDateFormatSerializer;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.hutool.StrUtil;

public class Json {
    private static Logger log = LoggerFactory.getLogger(Json.class);
    private static SerializeConfig mapping = new SerializeConfig();

    public static SerializeConfig put(Class<?> clazz, SerializeFilter filter) {
        mapping.addFilter(clazz, filter);
        return mapping;
    }

    public static SerializeConfig put(Class<?> clazz, ObjectSerializer serializer) {
        mapping.put(clazz, serializer);
        return mapping;
    }

    public static <T> T toBean(String jsonString, Class<T> tt) {
        Object t = JSON.parseObject((String)jsonString, tt);
        return (T)t;
    }

    public static <T> T toBean(String jsonString, TypeReference<T> typeReference) {
        if (StrUtil.isBlank(jsonString)) {
            return null;
        }
        return (T)JSON.parseObject((String)jsonString, typeReference, (Feature[])new Feature[0]);
    }

    public static <T> List<T> toList(String jsonString, Class<T> clazz) {
        try {
            if (StrUtil.isBlank(jsonString)) {
                return null;
            }
            List list = JSON.parseArray((String)jsonString, clazz);
            return list;
        }
        catch (Exception e) {
            log.error(jsonString, (Throwable)e);
            return null;
        }
    }

    public static String toFormatedJson(Object bean) {
        return JSON.toJSONString((Object)bean, (SerializeConfig)mapping, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.PrettyFormat});
    }

    public static String toJson(Object bean) {
        return JSON.toJSONString((Object)bean, (SerializeConfig)mapping, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
    }

    public static String toJsonAboutNull(Object bean) {
        return JSON.toJSONString((Object)bean, (SerializeConfig)mapping, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteNullStringAsEmpty});
    }

    public static String toJson(Object bean, SerializeFilter serializeFilter) {
        if (serializeFilter != null) {
            return JSON.toJSONString((Object)bean, (SerializeConfig)mapping, (SerializeFilter)serializeFilter, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        }
        return JSON.toJSONString((Object)bean, (SerializeConfig)mapping, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
    }

    static {
        mapping.put(Date.class, (ObjectSerializer)new SimpleDateFormatSerializer("yyyy-MM-dd HH:mm:ss"));
        mapping.put(java.sql.Date.class, (ObjectSerializer)new SimpleDateFormatSerializer("yyyy-MM-dd HH:mm:ss"));
        mapping.put(Timestamp.class, (ObjectSerializer)new SimpleDateFormatSerializer("yyyy-MM-dd HH:mm:ss"));
        mapping.put(Time.class, (ObjectSerializer)new SimpleDateFormatSerializer("HH:mm:ss"));
    }
}

