/*
 * Decompiled with CFR 0.152.
 */
package org.tio.websocket.client.kit;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.PacketSendMode;
import org.tio.core.intf.Packet;
import org.tio.core.intf.PacketMeta;

public class TioKit {
    private static Logger log = LoggerFactory.getLogger(TioKit.class);

    public static Boolean bSend(ChannelContext channelContext, Packet packet, int timeout, TimeUnit timeUnit) {
        if (channelContext == null) {
            return false;
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        PacketSendMode packetSendMode = PacketSendMode.SINGLE_BLOCK;
        try {
            if (packet == null || channelContext == null) {
                if (countDownLatch != null) {
                    countDownLatch.countDown();
                }
                return false;
            }
            if (channelContext.isVirtual) {
                if (countDownLatch != null) {
                    countDownLatch.countDown();
                }
                return true;
            }
            if (channelContext.isClosed || channelContext.isRemoved) {
                if (countDownLatch != null) {
                    countDownLatch.countDown();
                }
                if (channelContext != null) {
                    log.info("can't send data, {}, isClosed:{}, isRemoved:{}", new Object[]{channelContext, channelContext.isClosed, channelContext.isRemoved});
                }
                return false;
            }
            boolean isSingleBlock = countDownLatch != null && packetSendMode == PacketSendMode.SINGLE_BLOCK;
            boolean isAdded = false;
            if (countDownLatch != null) {
                PacketMeta meta = new PacketMeta();
                meta.setCountDownLatch(countDownLatch);
                packet.setMeta(meta);
            }
            if (!(isAdded = channelContext.tioConfig.useQueueSend ? channelContext.sendRunnable.addMsg(packet) : channelContext.sendRunnable.sendPacket(packet))) {
                if (countDownLatch != null) {
                    countDownLatch.countDown();
                }
                return false;
            }
            if (channelContext.tioConfig.useQueueSend) {
                channelContext.sendRunnable.execute();
            }
            if (isSingleBlock) {
                try {
                    Boolean awaitFlag = countDownLatch.await(timeout, timeUnit);
                    if (!awaitFlag.booleanValue()) {
                        log.error("{}, \u963b\u585e\u53d1\u9001\u8d85\u65f6, timeout:{}s, packet:{}", new Object[]{channelContext, timeUnit.toSeconds(timeout), packet.logstr()});
                    }
                }
                catch (InterruptedException e) {
                    log.error("", (Throwable)e);
                }
                Boolean isSentSuccess = packet.getMeta().getIsSentSuccess();
                return isSentSuccess;
            }
            return true;
        }
        catch (Throwable e) {
            log.error(channelContext + ", " + e.toString(), e);
            return false;
        }
    }
}

