/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.Column;
import software.amazon.awssdk.services.glue.model.ColumnListCopier;
import software.amazon.awssdk.services.glue.model.ParametersMapCopier;
import software.amazon.awssdk.services.glue.model.StorageDescriptor;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableInput> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TableInput.getter(TableInput::name)).setter(TableInput.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TableInput.getter(TableInput::description)).setter(TableInput.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TableInput.getter(TableInput::owner)).setter(TableInput.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final SdkField<Instant> LAST_ACCESS_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(TableInput.getter(TableInput::lastAccessTime)).setter(TableInput.setter(Builder::lastAccessTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAccessTime").build()}).build();
    private static final SdkField<Instant> LAST_ANALYZED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(TableInput.getter(TableInput::lastAnalyzedTime)).setter(TableInput.setter(Builder::lastAnalyzedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAnalyzedTime").build()}).build();
    private static final SdkField<Integer> RETENTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(TableInput.getter(TableInput::retention)).setter(TableInput.setter(Builder::retention)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Retention").build()}).build();
    private static final SdkField<StorageDescriptor> STORAGE_DESCRIPTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TableInput.getter(TableInput::storageDescriptor)).setter(TableInput.setter(Builder::storageDescriptor)).constructor(StorageDescriptor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageDescriptor").build()}).build();
    private static final SdkField<List<Column>> PARTITION_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TableInput.getter(TableInput::partitionKeys)).setter(TableInput.setter(Builder::partitionKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Column::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VIEW_ORIGINAL_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TableInput.getter(TableInput::viewOriginalText)).setter(TableInput.setter(Builder::viewOriginalText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewOriginalText").build()}).build();
    private static final SdkField<String> VIEW_EXPANDED_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TableInput.getter(TableInput::viewExpandedText)).setter(TableInput.setter(Builder::viewExpandedText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewExpandedText").build()}).build();
    private static final SdkField<String> TABLE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TableInput.getter(TableInput::tableType)).setter(TableInput.setter(Builder::tableType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableType").build()}).build();
    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(TableInput.getter(TableInput::parameters)).setter(TableInput.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, OWNER_FIELD, LAST_ACCESS_TIME_FIELD, LAST_ANALYZED_TIME_FIELD, RETENTION_FIELD, STORAGE_DESCRIPTOR_FIELD, PARTITION_KEYS_FIELD, VIEW_ORIGINAL_TEXT_FIELD, VIEW_EXPANDED_TEXT_FIELD, TABLE_TYPE_FIELD, PARAMETERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final String owner;
    private final Instant lastAccessTime;
    private final Instant lastAnalyzedTime;
    private final Integer retention;
    private final StorageDescriptor storageDescriptor;
    private final List<Column> partitionKeys;
    private final String viewOriginalText;
    private final String viewExpandedText;
    private final String tableType;
    private final Map<String, String> parameters;

    private TableInput(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.owner = builder.owner;
        this.lastAccessTime = builder.lastAccessTime;
        this.lastAnalyzedTime = builder.lastAnalyzedTime;
        this.retention = builder.retention;
        this.storageDescriptor = builder.storageDescriptor;
        this.partitionKeys = builder.partitionKeys;
        this.viewOriginalText = builder.viewOriginalText;
        this.viewExpandedText = builder.viewExpandedText;
        this.tableType = builder.tableType;
        this.parameters = builder.parameters;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String owner() {
        return this.owner;
    }

    public Instant lastAccessTime() {
        return this.lastAccessTime;
    }

    public Instant lastAnalyzedTime() {
        return this.lastAnalyzedTime;
    }

    public Integer retention() {
        return this.retention;
    }

    public StorageDescriptor storageDescriptor() {
        return this.storageDescriptor;
    }

    public boolean hasPartitionKeys() {
        return this.partitionKeys != null && !(this.partitionKeys instanceof SdkAutoConstructList);
    }

    public List<Column> partitionKeys() {
        return this.partitionKeys;
    }

    public String viewOriginalText() {
        return this.viewOriginalText;
    }

    public String viewExpandedText() {
        return this.viewExpandedText;
    }

    public String tableType() {
        return this.tableType;
    }

    public boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAccessTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAnalyzedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.retention());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageDescriptor());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionKeys());
        hashCode = 31 * hashCode + Objects.hashCode(this.viewOriginalText());
        hashCode = 31 * hashCode + Objects.hashCode(this.viewExpandedText());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableType());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableInput)) {
            return false;
        }
        TableInput other = (TableInput)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.lastAccessTime(), other.lastAccessTime()) && Objects.equals(this.lastAnalyzedTime(), other.lastAnalyzedTime()) && Objects.equals(this.retention(), other.retention()) && Objects.equals(this.storageDescriptor(), other.storageDescriptor()) && Objects.equals(this.partitionKeys(), other.partitionKeys()) && Objects.equals(this.viewOriginalText(), other.viewOriginalText()) && Objects.equals(this.viewExpandedText(), other.viewExpandedText()) && Objects.equals(this.tableType(), other.tableType()) && Objects.equals(this.parameters(), other.parameters());
    }

    public String toString() {
        return ToString.builder((String)"TableInput").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Owner", (Object)this.owner()).add("LastAccessTime", (Object)this.lastAccessTime()).add("LastAnalyzedTime", (Object)this.lastAnalyzedTime()).add("Retention", (Object)this.retention()).add("StorageDescriptor", (Object)this.storageDescriptor()).add("PartitionKeys", this.partitionKeys()).add("ViewOriginalText", (Object)this.viewOriginalText()).add("ViewExpandedText", (Object)this.viewExpandedText()).add("TableType", (Object)this.tableType()).add("Parameters", this.parameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "LastAccessTime": {
                return Optional.ofNullable(clazz.cast(this.lastAccessTime()));
            }
            case "LastAnalyzedTime": {
                return Optional.ofNullable(clazz.cast(this.lastAnalyzedTime()));
            }
            case "Retention": {
                return Optional.ofNullable(clazz.cast(this.retention()));
            }
            case "StorageDescriptor": {
                return Optional.ofNullable(clazz.cast(this.storageDescriptor()));
            }
            case "PartitionKeys": {
                return Optional.ofNullable(clazz.cast(this.partitionKeys()));
            }
            case "ViewOriginalText": {
                return Optional.ofNullable(clazz.cast(this.viewOriginalText()));
            }
            case "ViewExpandedText": {
                return Optional.ofNullable(clazz.cast(this.viewExpandedText()));
            }
            case "TableType": {
                return Optional.ofNullable(clazz.cast(this.tableType()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableInput, T> g) {
        return obj -> g.apply((TableInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String owner;
        private Instant lastAccessTime;
        private Instant lastAnalyzedTime;
        private Integer retention;
        private StorageDescriptor storageDescriptor;
        private List<Column> partitionKeys = DefaultSdkAutoConstructList.getInstance();
        private String viewOriginalText;
        private String viewExpandedText;
        private String tableType;
        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TableInput model) {
            this.name(model.name);
            this.description(model.description);
            this.owner(model.owner);
            this.lastAccessTime(model.lastAccessTime);
            this.lastAnalyzedTime(model.lastAnalyzedTime);
            this.retention(model.retention);
            this.storageDescriptor(model.storageDescriptor);
            this.partitionKeys(model.partitionKeys);
            this.viewOriginalText(model.viewOriginalText);
            this.viewExpandedText(model.viewExpandedText);
            this.tableType(model.tableType);
            this.parameters(model.parameters);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final Instant getLastAccessTime() {
            return this.lastAccessTime;
        }

        @Override
        public final Builder lastAccessTime(Instant lastAccessTime) {
            this.lastAccessTime = lastAccessTime;
            return this;
        }

        public final void setLastAccessTime(Instant lastAccessTime) {
            this.lastAccessTime = lastAccessTime;
        }

        public final Instant getLastAnalyzedTime() {
            return this.lastAnalyzedTime;
        }

        @Override
        public final Builder lastAnalyzedTime(Instant lastAnalyzedTime) {
            this.lastAnalyzedTime = lastAnalyzedTime;
            return this;
        }

        public final void setLastAnalyzedTime(Instant lastAnalyzedTime) {
            this.lastAnalyzedTime = lastAnalyzedTime;
        }

        public final Integer getRetention() {
            return this.retention;
        }

        @Override
        public final Builder retention(Integer retention) {
            this.retention = retention;
            return this;
        }

        public final void setRetention(Integer retention) {
            this.retention = retention;
        }

        public final StorageDescriptor.Builder getStorageDescriptor() {
            return this.storageDescriptor != null ? this.storageDescriptor.toBuilder() : null;
        }

        @Override
        public final Builder storageDescriptor(StorageDescriptor storageDescriptor) {
            this.storageDescriptor = storageDescriptor;
            return this;
        }

        public final void setStorageDescriptor(StorageDescriptor.BuilderImpl storageDescriptor) {
            this.storageDescriptor = storageDescriptor != null ? storageDescriptor.build() : null;
        }

        public final Collection<Column.Builder> getPartitionKeys() {
            return this.partitionKeys != null ? (Collection)this.partitionKeys.stream().map(Column::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder partitionKeys(Collection<Column> partitionKeys) {
            this.partitionKeys = ColumnListCopier.copy(partitionKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionKeys(Column ... partitionKeys) {
            this.partitionKeys(Arrays.asList(partitionKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionKeys(Consumer<Column.Builder> ... partitionKeys) {
            this.partitionKeys(Stream.of(partitionKeys).map(c -> (Column)((Column.Builder)Column.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPartitionKeys(Collection<Column.BuilderImpl> partitionKeys) {
            this.partitionKeys = ColumnListCopier.copyFromBuilder(partitionKeys);
        }

        public final String getViewOriginalText() {
            return this.viewOriginalText;
        }

        @Override
        public final Builder viewOriginalText(String viewOriginalText) {
            this.viewOriginalText = viewOriginalText;
            return this;
        }

        public final void setViewOriginalText(String viewOriginalText) {
            this.viewOriginalText = viewOriginalText;
        }

        public final String getViewExpandedText() {
            return this.viewExpandedText;
        }

        @Override
        public final Builder viewExpandedText(String viewExpandedText) {
            this.viewExpandedText = viewExpandedText;
            return this;
        }

        public final void setViewExpandedText(String viewExpandedText) {
            this.viewExpandedText = viewExpandedText;
        }

        public final String getTableType() {
            return this.tableType;
        }

        @Override
        public final Builder tableType(String tableType) {
            this.tableType = tableType;
            return this;
        }

        public final void setTableType(String tableType) {
            this.tableType = tableType;
        }

        public final Map<String, String> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        public TableInput build() {
            return new TableInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableInput> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder owner(String var1);

        public Builder lastAccessTime(Instant var1);

        public Builder lastAnalyzedTime(Instant var1);

        public Builder retention(Integer var1);

        public Builder storageDescriptor(StorageDescriptor var1);

        default public Builder storageDescriptor(Consumer<StorageDescriptor.Builder> storageDescriptor) {
            return this.storageDescriptor((StorageDescriptor)((StorageDescriptor.Builder)StorageDescriptor.builder().applyMutation(storageDescriptor)).build());
        }

        public Builder partitionKeys(Collection<Column> var1);

        public Builder partitionKeys(Column ... var1);

        public Builder partitionKeys(Consumer<Column.Builder> ... var1);

        public Builder viewOriginalText(String var1);

        public Builder viewExpandedText(String var1);

        public Builder tableType(String var1);

        public Builder parameters(Map<String, String> var1);
    }
}

