/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.UpdateCsvClassifierRequest;
import software.amazon.awssdk.services.glue.model.UpdateGrokClassifierRequest;
import software.amazon.awssdk.services.glue.model.UpdateJsonClassifierRequest;
import software.amazon.awssdk.services.glue.model.UpdateXMLClassifierRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateClassifierRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, UpdateClassifierRequest> {
    private static final SdkField<UpdateGrokClassifierRequest> GROK_CLASSIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateClassifierRequest.getter(UpdateClassifierRequest::grokClassifier)).setter(UpdateClassifierRequest.setter(Builder::grokClassifier)).constructor(UpdateGrokClassifierRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrokClassifier").build()}).build();
    private static final SdkField<UpdateXMLClassifierRequest> XML_CLASSIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateClassifierRequest.getter(UpdateClassifierRequest::xmlClassifier)).setter(UpdateClassifierRequest.setter(Builder::xmlClassifier)).constructor(UpdateXMLClassifierRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XMLClassifier").build()}).build();
    private static final SdkField<UpdateJsonClassifierRequest> JSON_CLASSIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateClassifierRequest.getter(UpdateClassifierRequest::jsonClassifier)).setter(UpdateClassifierRequest.setter(Builder::jsonClassifier)).constructor(UpdateJsonClassifierRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JsonClassifier").build()}).build();
    private static final SdkField<UpdateCsvClassifierRequest> CSV_CLASSIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateClassifierRequest.getter(UpdateClassifierRequest::csvClassifier)).setter(UpdateClassifierRequest.setter(Builder::csvClassifier)).constructor(UpdateCsvClassifierRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CsvClassifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROK_CLASSIFIER_FIELD, XML_CLASSIFIER_FIELD, JSON_CLASSIFIER_FIELD, CSV_CLASSIFIER_FIELD));
    private final UpdateGrokClassifierRequest grokClassifier;
    private final UpdateXMLClassifierRequest xmlClassifier;
    private final UpdateJsonClassifierRequest jsonClassifier;
    private final UpdateCsvClassifierRequest csvClassifier;

    private UpdateClassifierRequest(BuilderImpl builder) {
        super(builder);
        this.grokClassifier = builder.grokClassifier;
        this.xmlClassifier = builder.xmlClassifier;
        this.jsonClassifier = builder.jsonClassifier;
        this.csvClassifier = builder.csvClassifier;
    }

    public UpdateGrokClassifierRequest grokClassifier() {
        return this.grokClassifier;
    }

    public UpdateXMLClassifierRequest xmlClassifier() {
        return this.xmlClassifier;
    }

    public UpdateJsonClassifierRequest jsonClassifier() {
        return this.jsonClassifier;
    }

    public UpdateCsvClassifierRequest csvClassifier() {
        return this.csvClassifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.grokClassifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.xmlClassifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.jsonClassifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.csvClassifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateClassifierRequest)) {
            return false;
        }
        UpdateClassifierRequest other = (UpdateClassifierRequest)((Object)obj);
        return Objects.equals(this.grokClassifier(), other.grokClassifier()) && Objects.equals(this.xmlClassifier(), other.xmlClassifier()) && Objects.equals(this.jsonClassifier(), other.jsonClassifier()) && Objects.equals(this.csvClassifier(), other.csvClassifier());
    }

    public String toString() {
        return ToString.builder((String)"UpdateClassifierRequest").add("GrokClassifier", (Object)this.grokClassifier()).add("XMLClassifier", (Object)this.xmlClassifier()).add("JsonClassifier", (Object)this.jsonClassifier()).add("CsvClassifier", (Object)this.csvClassifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GrokClassifier": {
                return Optional.ofNullable(clazz.cast(this.grokClassifier()));
            }
            case "XMLClassifier": {
                return Optional.ofNullable(clazz.cast(this.xmlClassifier()));
            }
            case "JsonClassifier": {
                return Optional.ofNullable(clazz.cast(this.jsonClassifier()));
            }
            case "CsvClassifier": {
                return Optional.ofNullable(clazz.cast(this.csvClassifier()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateClassifierRequest, T> g) {
        return obj -> g.apply((UpdateClassifierRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private UpdateGrokClassifierRequest grokClassifier;
        private UpdateXMLClassifierRequest xmlClassifier;
        private UpdateJsonClassifierRequest jsonClassifier;
        private UpdateCsvClassifierRequest csvClassifier;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateClassifierRequest model) {
            super(model);
            this.grokClassifier(model.grokClassifier);
            this.xmlClassifier(model.xmlClassifier);
            this.jsonClassifier(model.jsonClassifier);
            this.csvClassifier(model.csvClassifier);
        }

        public final UpdateGrokClassifierRequest.Builder getGrokClassifier() {
            return this.grokClassifier != null ? this.grokClassifier.toBuilder() : null;
        }

        @Override
        public final Builder grokClassifier(UpdateGrokClassifierRequest grokClassifier) {
            this.grokClassifier = grokClassifier;
            return this;
        }

        public final void setGrokClassifier(UpdateGrokClassifierRequest.BuilderImpl grokClassifier) {
            this.grokClassifier = grokClassifier != null ? grokClassifier.build() : null;
        }

        public final UpdateXMLClassifierRequest.Builder getXmlClassifier() {
            return this.xmlClassifier != null ? this.xmlClassifier.toBuilder() : null;
        }

        @Override
        public final Builder xmlClassifier(UpdateXMLClassifierRequest xmlClassifier) {
            this.xmlClassifier = xmlClassifier;
            return this;
        }

        public final void setXmlClassifier(UpdateXMLClassifierRequest.BuilderImpl xmlClassifier) {
            this.xmlClassifier = xmlClassifier != null ? xmlClassifier.build() : null;
        }

        public final UpdateJsonClassifierRequest.Builder getJsonClassifier() {
            return this.jsonClassifier != null ? this.jsonClassifier.toBuilder() : null;
        }

        @Override
        public final Builder jsonClassifier(UpdateJsonClassifierRequest jsonClassifier) {
            this.jsonClassifier = jsonClassifier;
            return this;
        }

        public final void setJsonClassifier(UpdateJsonClassifierRequest.BuilderImpl jsonClassifier) {
            this.jsonClassifier = jsonClassifier != null ? jsonClassifier.build() : null;
        }

        public final UpdateCsvClassifierRequest.Builder getCsvClassifier() {
            return this.csvClassifier != null ? this.csvClassifier.toBuilder() : null;
        }

        @Override
        public final Builder csvClassifier(UpdateCsvClassifierRequest csvClassifier) {
            this.csvClassifier = csvClassifier;
            return this;
        }

        public final void setCsvClassifier(UpdateCsvClassifierRequest.BuilderImpl csvClassifier) {
            this.csvClassifier = csvClassifier != null ? csvClassifier.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateClassifierRequest build() {
            return new UpdateClassifierRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateClassifierRequest> {
        public Builder grokClassifier(UpdateGrokClassifierRequest var1);

        default public Builder grokClassifier(Consumer<UpdateGrokClassifierRequest.Builder> grokClassifier) {
            return this.grokClassifier((UpdateGrokClassifierRequest)((UpdateGrokClassifierRequest.Builder)UpdateGrokClassifierRequest.builder().applyMutation(grokClassifier)).build());
        }

        public Builder xmlClassifier(UpdateXMLClassifierRequest var1);

        default public Builder xmlClassifier(Consumer<UpdateXMLClassifierRequest.Builder> xmlClassifier) {
            return this.xmlClassifier((UpdateXMLClassifierRequest)((UpdateXMLClassifierRequest.Builder)UpdateXMLClassifierRequest.builder().applyMutation(xmlClassifier)).build());
        }

        public Builder jsonClassifier(UpdateJsonClassifierRequest var1);

        default public Builder jsonClassifier(Consumer<UpdateJsonClassifierRequest.Builder> jsonClassifier) {
            return this.jsonClassifier((UpdateJsonClassifierRequest)((UpdateJsonClassifierRequest.Builder)UpdateJsonClassifierRequest.builder().applyMutation(jsonClassifier)).build());
        }

        public Builder csvClassifier(UpdateCsvClassifierRequest var1);

        default public Builder csvClassifier(Consumer<UpdateCsvClassifierRequest.Builder> csvClassifier) {
            return this.csvClassifier((UpdateCsvClassifierRequest)((UpdateCsvClassifierRequest.Builder)UpdateCsvClassifierRequest.builder().applyMutation(csvClassifier)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

