/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.ConnectionsList;
import software.amazon.awssdk.services.glue.model.ExecutionProperty;
import software.amazon.awssdk.services.glue.model.GenericMapCopier;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.JobCommand;
import software.amazon.awssdk.services.glue.model.NotificationProperty;
import software.amazon.awssdk.services.glue.model.TagsMapCopier;
import software.amazon.awssdk.services.glue.model.WorkerType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateJobRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, CreateJobRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateJobRequest.getter(CreateJobRequest::name)).setter(CreateJobRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateJobRequest.getter(CreateJobRequest::description)).setter(CreateJobRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> LOG_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogUri").getter(CreateJobRequest.getter(CreateJobRequest::logUri)).setter(CreateJobRequest.setter(Builder::logUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogUri").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(CreateJobRequest.getter(CreateJobRequest::role)).setter(CreateJobRequest.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<ExecutionProperty> EXECUTION_PROPERTY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExecutionProperty").getter(CreateJobRequest.getter(CreateJobRequest::executionProperty)).setter(CreateJobRequest.setter(Builder::executionProperty)).constructor(ExecutionProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionProperty").build()}).build();
    private static final SdkField<JobCommand> COMMAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Command").getter(CreateJobRequest.getter(CreateJobRequest::command)).setter(CreateJobRequest.setter(Builder::command)).constructor(JobCommand::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Command").build()}).build();
    private static final SdkField<Map<String, String>> DEFAULT_ARGUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("DefaultArguments").getter(CreateJobRequest.getter(CreateJobRequest::defaultArguments)).setter(CreateJobRequest.setter(Builder::defaultArguments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultArguments").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> NON_OVERRIDABLE_ARGUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("NonOverridableArguments").getter(CreateJobRequest.getter(CreateJobRequest::nonOverridableArguments)).setter(CreateJobRequest.setter(Builder::nonOverridableArguments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonOverridableArguments").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<ConnectionsList> CONNECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Connections").getter(CreateJobRequest.getter(CreateJobRequest::connections)).setter(CreateJobRequest.setter(Builder::connections)).constructor(ConnectionsList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Connections").build()}).build();
    private static final SdkField<Integer> MAX_RETRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxRetries").getter(CreateJobRequest.getter(CreateJobRequest::maxRetries)).setter(CreateJobRequest.setter(Builder::maxRetries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRetries").build()}).build();
    private static final SdkField<Integer> ALLOCATED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AllocatedCapacity").getter(CreateJobRequest.getter(CreateJobRequest::allocatedCapacity)).setter(CreateJobRequest.setter(Builder::allocatedCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedCapacity").build()}).build();
    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Timeout").getter(CreateJobRequest.getter(CreateJobRequest::timeout)).setter(CreateJobRequest.setter(Builder::timeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()}).build();
    private static final SdkField<Double> MAX_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MaxCapacity").getter(CreateJobRequest.getter(CreateJobRequest::maxCapacity)).setter(CreateJobRequest.setter(Builder::maxCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()}).build();
    private static final SdkField<String> SECURITY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityConfiguration").getter(CreateJobRequest.getter(CreateJobRequest::securityConfiguration)).setter(CreateJobRequest.setter(Builder::securityConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfiguration").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateJobRequest.getter(CreateJobRequest::tags)).setter(CreateJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<NotificationProperty> NOTIFICATION_PROPERTY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NotificationProperty").getter(CreateJobRequest.getter(CreateJobRequest::notificationProperty)).setter(CreateJobRequest.setter(Builder::notificationProperty)).constructor(NotificationProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationProperty").build()}).build();
    private static final SdkField<String> GLUE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlueVersion").getter(CreateJobRequest.getter(CreateJobRequest::glueVersion)).setter(CreateJobRequest.setter(Builder::glueVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlueVersion").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_WORKERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfWorkers").getter(CreateJobRequest.getter(CreateJobRequest::numberOfWorkers)).setter(CreateJobRequest.setter(Builder::numberOfWorkers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfWorkers").build()}).build();
    private static final SdkField<String> WORKER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkerType").getter(CreateJobRequest.getter(CreateJobRequest::workerTypeAsString)).setter(CreateJobRequest.setter(Builder::workerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkerType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, LOG_URI_FIELD, ROLE_FIELD, EXECUTION_PROPERTY_FIELD, COMMAND_FIELD, DEFAULT_ARGUMENTS_FIELD, NON_OVERRIDABLE_ARGUMENTS_FIELD, CONNECTIONS_FIELD, MAX_RETRIES_FIELD, ALLOCATED_CAPACITY_FIELD, TIMEOUT_FIELD, MAX_CAPACITY_FIELD, SECURITY_CONFIGURATION_FIELD, TAGS_FIELD, NOTIFICATION_PROPERTY_FIELD, GLUE_VERSION_FIELD, NUMBER_OF_WORKERS_FIELD, WORKER_TYPE_FIELD));
    private final String name;
    private final String description;
    private final String logUri;
    private final String role;
    private final ExecutionProperty executionProperty;
    private final JobCommand command;
    private final Map<String, String> defaultArguments;
    private final Map<String, String> nonOverridableArguments;
    private final ConnectionsList connections;
    private final Integer maxRetries;
    private final Integer allocatedCapacity;
    private final Integer timeout;
    private final Double maxCapacity;
    private final String securityConfiguration;
    private final Map<String, String> tags;
    private final NotificationProperty notificationProperty;
    private final String glueVersion;
    private final Integer numberOfWorkers;
    private final String workerType;

    private CreateJobRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.logUri = builder.logUri;
        this.role = builder.role;
        this.executionProperty = builder.executionProperty;
        this.command = builder.command;
        this.defaultArguments = builder.defaultArguments;
        this.nonOverridableArguments = builder.nonOverridableArguments;
        this.connections = builder.connections;
        this.maxRetries = builder.maxRetries;
        this.allocatedCapacity = builder.allocatedCapacity;
        this.timeout = builder.timeout;
        this.maxCapacity = builder.maxCapacity;
        this.securityConfiguration = builder.securityConfiguration;
        this.tags = builder.tags;
        this.notificationProperty = builder.notificationProperty;
        this.glueVersion = builder.glueVersion;
        this.numberOfWorkers = builder.numberOfWorkers;
        this.workerType = builder.workerType;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String logUri() {
        return this.logUri;
    }

    public String role() {
        return this.role;
    }

    public ExecutionProperty executionProperty() {
        return this.executionProperty;
    }

    public JobCommand command() {
        return this.command;
    }

    public boolean hasDefaultArguments() {
        return this.defaultArguments != null && !(this.defaultArguments instanceof SdkAutoConstructMap);
    }

    public Map<String, String> defaultArguments() {
        return this.defaultArguments;
    }

    public boolean hasNonOverridableArguments() {
        return this.nonOverridableArguments != null && !(this.nonOverridableArguments instanceof SdkAutoConstructMap);
    }

    public Map<String, String> nonOverridableArguments() {
        return this.nonOverridableArguments;
    }

    public ConnectionsList connections() {
        return this.connections;
    }

    public Integer maxRetries() {
        return this.maxRetries;
    }

    public Integer allocatedCapacity() {
        return this.allocatedCapacity;
    }

    public Integer timeout() {
        return this.timeout;
    }

    public Double maxCapacity() {
        return this.maxCapacity;
    }

    public String securityConfiguration() {
        return this.securityConfiguration;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public NotificationProperty notificationProperty() {
        return this.notificationProperty;
    }

    public String glueVersion() {
        return this.glueVersion;
    }

    public Integer numberOfWorkers() {
        return this.numberOfWorkers;
    }

    public WorkerType workerType() {
        return WorkerType.fromValue(this.workerType);
    }

    public String workerTypeAsString() {
        return this.workerType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.logUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionProperty());
        hashCode = 31 * hashCode + Objects.hashCode(this.command());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefaultArguments() ? this.defaultArguments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNonOverridableArguments() ? this.nonOverridableArguments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.connections());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRetries());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationProperty());
        hashCode = 31 * hashCode + Objects.hashCode(this.glueVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(this.workerTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobRequest)) {
            return false;
        }
        CreateJobRequest other = (CreateJobRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.logUri(), other.logUri()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.executionProperty(), other.executionProperty()) && Objects.equals(this.command(), other.command()) && this.hasDefaultArguments() == other.hasDefaultArguments() && Objects.equals(this.defaultArguments(), other.defaultArguments()) && this.hasNonOverridableArguments() == other.hasNonOverridableArguments() && Objects.equals(this.nonOverridableArguments(), other.nonOverridableArguments()) && Objects.equals(this.connections(), other.connections()) && Objects.equals(this.maxRetries(), other.maxRetries()) && Objects.equals(this.allocatedCapacity(), other.allocatedCapacity()) && Objects.equals(this.timeout(), other.timeout()) && Objects.equals(this.maxCapacity(), other.maxCapacity()) && Objects.equals(this.securityConfiguration(), other.securityConfiguration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.notificationProperty(), other.notificationProperty()) && Objects.equals(this.glueVersion(), other.glueVersion()) && Objects.equals(this.numberOfWorkers(), other.numberOfWorkers()) && Objects.equals(this.workerTypeAsString(), other.workerTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"CreateJobRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("LogUri", (Object)this.logUri()).add("Role", (Object)this.role()).add("ExecutionProperty", (Object)this.executionProperty()).add("Command", (Object)this.command()).add("DefaultArguments", this.hasDefaultArguments() ? this.defaultArguments() : null).add("NonOverridableArguments", this.hasNonOverridableArguments() ? this.nonOverridableArguments() : null).add("Connections", (Object)this.connections()).add("MaxRetries", (Object)this.maxRetries()).add("AllocatedCapacity", (Object)this.allocatedCapacity()).add("Timeout", (Object)this.timeout()).add("MaxCapacity", (Object)this.maxCapacity()).add("SecurityConfiguration", (Object)this.securityConfiguration()).add("Tags", this.hasTags() ? this.tags() : null).add("NotificationProperty", (Object)this.notificationProperty()).add("GlueVersion", (Object)this.glueVersion()).add("NumberOfWorkers", (Object)this.numberOfWorkers()).add("WorkerType", (Object)this.workerTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "LogUri": {
                return Optional.ofNullable(clazz.cast(this.logUri()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "ExecutionProperty": {
                return Optional.ofNullable(clazz.cast(this.executionProperty()));
            }
            case "Command": {
                return Optional.ofNullable(clazz.cast(this.command()));
            }
            case "DefaultArguments": {
                return Optional.ofNullable(clazz.cast(this.defaultArguments()));
            }
            case "NonOverridableArguments": {
                return Optional.ofNullable(clazz.cast(this.nonOverridableArguments()));
            }
            case "Connections": {
                return Optional.ofNullable(clazz.cast(this.connections()));
            }
            case "MaxRetries": {
                return Optional.ofNullable(clazz.cast(this.maxRetries()));
            }
            case "AllocatedCapacity": {
                return Optional.ofNullable(clazz.cast(this.allocatedCapacity()));
            }
            case "Timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
            case "MaxCapacity": {
                return Optional.ofNullable(clazz.cast(this.maxCapacity()));
            }
            case "SecurityConfiguration": {
                return Optional.ofNullable(clazz.cast(this.securityConfiguration()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "NotificationProperty": {
                return Optional.ofNullable(clazz.cast(this.notificationProperty()));
            }
            case "GlueVersion": {
                return Optional.ofNullable(clazz.cast(this.glueVersion()));
            }
            case "NumberOfWorkers": {
                return Optional.ofNullable(clazz.cast(this.numberOfWorkers()));
            }
            case "WorkerType": {
                return Optional.ofNullable(clazz.cast(this.workerTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateJobRequest, T> g) {
        return obj -> g.apply((CreateJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String logUri;
        private String role;
        private ExecutionProperty executionProperty;
        private JobCommand command;
        private Map<String, String> defaultArguments = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> nonOverridableArguments = DefaultSdkAutoConstructMap.getInstance();
        private ConnectionsList connections;
        private Integer maxRetries;
        private Integer allocatedCapacity;
        private Integer timeout;
        private Double maxCapacity;
        private String securityConfiguration;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private NotificationProperty notificationProperty;
        private String glueVersion;
        private Integer numberOfWorkers;
        private String workerType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.logUri(model.logUri);
            this.role(model.role);
            this.executionProperty(model.executionProperty);
            this.command(model.command);
            this.defaultArguments(model.defaultArguments);
            this.nonOverridableArguments(model.nonOverridableArguments);
            this.connections(model.connections);
            this.maxRetries(model.maxRetries);
            this.allocatedCapacity(model.allocatedCapacity);
            this.timeout(model.timeout);
            this.maxCapacity(model.maxCapacity);
            this.securityConfiguration(model.securityConfiguration);
            this.tags(model.tags);
            this.notificationProperty(model.notificationProperty);
            this.glueVersion(model.glueVersion);
            this.numberOfWorkers(model.numberOfWorkers);
            this.workerType(model.workerType);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getLogUri() {
            return this.logUri;
        }

        @Override
        public final Builder logUri(String logUri) {
            this.logUri = logUri;
            return this;
        }

        public final void setLogUri(String logUri) {
            this.logUri = logUri;
        }

        public final String getRole() {
            return this.role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final ExecutionProperty.Builder getExecutionProperty() {
            return this.executionProperty != null ? this.executionProperty.toBuilder() : null;
        }

        @Override
        public final Builder executionProperty(ExecutionProperty executionProperty) {
            this.executionProperty = executionProperty;
            return this;
        }

        public final void setExecutionProperty(ExecutionProperty.BuilderImpl executionProperty) {
            this.executionProperty = executionProperty != null ? executionProperty.build() : null;
        }

        public final JobCommand.Builder getCommand() {
            return this.command != null ? this.command.toBuilder() : null;
        }

        @Override
        public final Builder command(JobCommand command) {
            this.command = command;
            return this;
        }

        public final void setCommand(JobCommand.BuilderImpl command) {
            this.command = command != null ? command.build() : null;
        }

        public final Map<String, String> getDefaultArguments() {
            if (this.defaultArguments instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.defaultArguments;
        }

        @Override
        public final Builder defaultArguments(Map<String, String> defaultArguments) {
            this.defaultArguments = GenericMapCopier.copy(defaultArguments);
            return this;
        }

        public final void setDefaultArguments(Map<String, String> defaultArguments) {
            this.defaultArguments = GenericMapCopier.copy(defaultArguments);
        }

        public final Map<String, String> getNonOverridableArguments() {
            if (this.nonOverridableArguments instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.nonOverridableArguments;
        }

        @Override
        public final Builder nonOverridableArguments(Map<String, String> nonOverridableArguments) {
            this.nonOverridableArguments = GenericMapCopier.copy(nonOverridableArguments);
            return this;
        }

        public final void setNonOverridableArguments(Map<String, String> nonOverridableArguments) {
            this.nonOverridableArguments = GenericMapCopier.copy(nonOverridableArguments);
        }

        public final ConnectionsList.Builder getConnections() {
            return this.connections != null ? this.connections.toBuilder() : null;
        }

        @Override
        public final Builder connections(ConnectionsList connections) {
            this.connections = connections;
            return this;
        }

        public final void setConnections(ConnectionsList.BuilderImpl connections) {
            this.connections = connections != null ? connections.build() : null;
        }

        public final Integer getMaxRetries() {
            return this.maxRetries;
        }

        @Override
        public final Builder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public final void setMaxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
        }

        public final Integer getAllocatedCapacity() {
            return this.allocatedCapacity;
        }

        @Override
        public final Builder allocatedCapacity(Integer allocatedCapacity) {
            this.allocatedCapacity = allocatedCapacity;
            return this;
        }

        public final void setAllocatedCapacity(Integer allocatedCapacity) {
            this.allocatedCapacity = allocatedCapacity;
        }

        public final Integer getTimeout() {
            return this.timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public final Double getMaxCapacity() {
            return this.maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Double maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final void setMaxCapacity(Double maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        public final String getSecurityConfiguration() {
            return this.securityConfiguration;
        }

        @Override
        public final Builder securityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        public final void setSecurityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        public final NotificationProperty.Builder getNotificationProperty() {
            return this.notificationProperty != null ? this.notificationProperty.toBuilder() : null;
        }

        @Override
        public final Builder notificationProperty(NotificationProperty notificationProperty) {
            this.notificationProperty = notificationProperty;
            return this;
        }

        public final void setNotificationProperty(NotificationProperty.BuilderImpl notificationProperty) {
            this.notificationProperty = notificationProperty != null ? notificationProperty.build() : null;
        }

        public final String getGlueVersion() {
            return this.glueVersion;
        }

        @Override
        public final Builder glueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
            return this;
        }

        public final void setGlueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
        }

        public final Integer getNumberOfWorkers() {
            return this.numberOfWorkers;
        }

        @Override
        public final Builder numberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
            return this;
        }

        public final void setNumberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
        }

        public final String getWorkerType() {
            return this.workerType;
        }

        @Override
        public final Builder workerType(String workerType) {
            this.workerType = workerType;
            return this;
        }

        @Override
        public final Builder workerType(WorkerType workerType) {
            this.workerType(workerType == null ? null : workerType.toString());
            return this;
        }

        public final void setWorkerType(String workerType) {
            this.workerType = workerType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateJobRequest build() {
            return new CreateJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateJobRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder logUri(String var1);

        public Builder role(String var1);

        public Builder executionProperty(ExecutionProperty var1);

        default public Builder executionProperty(Consumer<ExecutionProperty.Builder> executionProperty) {
            return this.executionProperty((ExecutionProperty)((ExecutionProperty.Builder)ExecutionProperty.builder().applyMutation(executionProperty)).build());
        }

        public Builder command(JobCommand var1);

        default public Builder command(Consumer<JobCommand.Builder> command) {
            return this.command((JobCommand)((JobCommand.Builder)JobCommand.builder().applyMutation(command)).build());
        }

        public Builder defaultArguments(Map<String, String> var1);

        public Builder nonOverridableArguments(Map<String, String> var1);

        public Builder connections(ConnectionsList var1);

        default public Builder connections(Consumer<ConnectionsList.Builder> connections) {
            return this.connections((ConnectionsList)((ConnectionsList.Builder)ConnectionsList.builder().applyMutation(connections)).build());
        }

        public Builder maxRetries(Integer var1);

        public Builder allocatedCapacity(Integer var1);

        public Builder timeout(Integer var1);

        public Builder maxCapacity(Double var1);

        public Builder securityConfiguration(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder notificationProperty(NotificationProperty var1);

        default public Builder notificationProperty(Consumer<NotificationProperty.Builder> notificationProperty) {
            return this.notificationProperty((NotificationProperty)((NotificationProperty.Builder)NotificationProperty.builder().applyMutation(notificationProperty)).build());
        }

        public Builder glueVersion(String var1);

        public Builder numberOfWorkers(Integer var1);

        public Builder workerType(String var1);

        public Builder workerType(WorkerType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

