/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.DecimalNumber;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DecimalColumnStatisticsData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DecimalColumnStatisticsData> {
    private static final SdkField<DecimalNumber> MINIMUM_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MinimumValue").getter(DecimalColumnStatisticsData.getter(DecimalColumnStatisticsData::minimumValue)).setter(DecimalColumnStatisticsData.setter(Builder::minimumValue)).constructor(DecimalNumber::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumValue").build()}).build();
    private static final SdkField<DecimalNumber> MAXIMUM_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MaximumValue").getter(DecimalColumnStatisticsData.getter(DecimalColumnStatisticsData::maximumValue)).setter(DecimalColumnStatisticsData.setter(Builder::maximumValue)).constructor(DecimalNumber::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumValue").build()}).build();
    private static final SdkField<Long> NUMBER_OF_NULLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NumberOfNulls").getter(DecimalColumnStatisticsData.getter(DecimalColumnStatisticsData::numberOfNulls)).setter(DecimalColumnStatisticsData.setter(Builder::numberOfNulls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfNulls").build()}).build();
    private static final SdkField<Long> NUMBER_OF_DISTINCT_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NumberOfDistinctValues").getter(DecimalColumnStatisticsData.getter(DecimalColumnStatisticsData::numberOfDistinctValues)).setter(DecimalColumnStatisticsData.setter(Builder::numberOfDistinctValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfDistinctValues").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MINIMUM_VALUE_FIELD, MAXIMUM_VALUE_FIELD, NUMBER_OF_NULLS_FIELD, NUMBER_OF_DISTINCT_VALUES_FIELD));
    private static final long serialVersionUID = 1L;
    private final DecimalNumber minimumValue;
    private final DecimalNumber maximumValue;
    private final Long numberOfNulls;
    private final Long numberOfDistinctValues;

    private DecimalColumnStatisticsData(BuilderImpl builder) {
        this.minimumValue = builder.minimumValue;
        this.maximumValue = builder.maximumValue;
        this.numberOfNulls = builder.numberOfNulls;
        this.numberOfDistinctValues = builder.numberOfDistinctValues;
    }

    public DecimalNumber minimumValue() {
        return this.minimumValue;
    }

    public DecimalNumber maximumValue() {
        return this.maximumValue;
    }

    public Long numberOfNulls() {
        return this.numberOfNulls;
    }

    public Long numberOfDistinctValues() {
        return this.numberOfDistinctValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfNulls());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfDistinctValues());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecimalColumnStatisticsData)) {
            return false;
        }
        DecimalColumnStatisticsData other = (DecimalColumnStatisticsData)obj;
        return Objects.equals(this.minimumValue(), other.minimumValue()) && Objects.equals(this.maximumValue(), other.maximumValue()) && Objects.equals(this.numberOfNulls(), other.numberOfNulls()) && Objects.equals(this.numberOfDistinctValues(), other.numberOfDistinctValues());
    }

    public String toString() {
        return ToString.builder((String)"DecimalColumnStatisticsData").add("MinimumValue", (Object)this.minimumValue()).add("MaximumValue", (Object)this.maximumValue()).add("NumberOfNulls", (Object)this.numberOfNulls()).add("NumberOfDistinctValues", (Object)this.numberOfDistinctValues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MinimumValue": {
                return Optional.ofNullable(clazz.cast(this.minimumValue()));
            }
            case "MaximumValue": {
                return Optional.ofNullable(clazz.cast(this.maximumValue()));
            }
            case "NumberOfNulls": {
                return Optional.ofNullable(clazz.cast(this.numberOfNulls()));
            }
            case "NumberOfDistinctValues": {
                return Optional.ofNullable(clazz.cast(this.numberOfDistinctValues()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DecimalColumnStatisticsData, T> g) {
        return obj -> g.apply((DecimalColumnStatisticsData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DecimalNumber minimumValue;
        private DecimalNumber maximumValue;
        private Long numberOfNulls;
        private Long numberOfDistinctValues;

        private BuilderImpl() {
        }

        private BuilderImpl(DecimalColumnStatisticsData model) {
            this.minimumValue(model.minimumValue);
            this.maximumValue(model.maximumValue);
            this.numberOfNulls(model.numberOfNulls);
            this.numberOfDistinctValues(model.numberOfDistinctValues);
        }

        public final DecimalNumber.Builder getMinimumValue() {
            return this.minimumValue != null ? this.minimumValue.toBuilder() : null;
        }

        @Override
        public final Builder minimumValue(DecimalNumber minimumValue) {
            this.minimumValue = minimumValue;
            return this;
        }

        public final void setMinimumValue(DecimalNumber.BuilderImpl minimumValue) {
            this.minimumValue = minimumValue != null ? minimumValue.build() : null;
        }

        public final DecimalNumber.Builder getMaximumValue() {
            return this.maximumValue != null ? this.maximumValue.toBuilder() : null;
        }

        @Override
        public final Builder maximumValue(DecimalNumber maximumValue) {
            this.maximumValue = maximumValue;
            return this;
        }

        public final void setMaximumValue(DecimalNumber.BuilderImpl maximumValue) {
            this.maximumValue = maximumValue != null ? maximumValue.build() : null;
        }

        public final Long getNumberOfNulls() {
            return this.numberOfNulls;
        }

        @Override
        public final Builder numberOfNulls(Long numberOfNulls) {
            this.numberOfNulls = numberOfNulls;
            return this;
        }

        public final void setNumberOfNulls(Long numberOfNulls) {
            this.numberOfNulls = numberOfNulls;
        }

        public final Long getNumberOfDistinctValues() {
            return this.numberOfDistinctValues;
        }

        @Override
        public final Builder numberOfDistinctValues(Long numberOfDistinctValues) {
            this.numberOfDistinctValues = numberOfDistinctValues;
            return this;
        }

        public final void setNumberOfDistinctValues(Long numberOfDistinctValues) {
            this.numberOfDistinctValues = numberOfDistinctValues;
        }

        public DecimalColumnStatisticsData build() {
            return new DecimalColumnStatisticsData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DecimalColumnStatisticsData> {
        public Builder minimumValue(DecimalNumber var1);

        default public Builder minimumValue(Consumer<DecimalNumber.Builder> minimumValue) {
            return this.minimumValue((DecimalNumber)((DecimalNumber.Builder)DecimalNumber.builder().applyMutation(minimumValue)).build());
        }

        public Builder maximumValue(DecimalNumber var1);

        default public Builder maximumValue(Consumer<DecimalNumber.Builder> maximumValue) {
            return this.maximumValue((DecimalNumber)((DecimalNumber.Builder)DecimalNumber.builder().applyMutation(maximumValue)).build());
        }

        public Builder numberOfNulls(Long var1);

        public Builder numberOfDistinctValues(Long var1);
    }
}

