/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType;
import software.amazon.awssdk.services.opensearch.model.RecurringCharge;
import software.amazon.awssdk.services.opensearch.model.RecurringChargeListCopier;
import software.amazon.awssdk.services.opensearch.model.ReservedInstancePaymentOption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReservedInstance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReservedInstance> {
    private static final SdkField<String> RESERVATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservationName").getter(ReservedInstance.getter(ReservedInstance::reservationName)).setter(ReservedInstance.setter(Builder::reservationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservationName").build()}).build();
    private static final SdkField<String> RESERVED_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedInstanceId").getter(ReservedInstance.getter(ReservedInstance::reservedInstanceId)).setter(ReservedInstance.setter(Builder::reservedInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstanceId").build()}).build();
    private static final SdkField<Long> BILLING_SUBSCRIPTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BillingSubscriptionId").getter(ReservedInstance.getter(ReservedInstance::billingSubscriptionId)).setter(ReservedInstance.setter(Builder::billingSubscriptionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingSubscriptionId").build()}).build();
    private static final SdkField<String> RESERVED_INSTANCE_OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedInstanceOfferingId").getter(ReservedInstance.getter(ReservedInstance::reservedInstanceOfferingId)).setter(ReservedInstance.setter(Builder::reservedInstanceOfferingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstanceOfferingId").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(ReservedInstance.getter(ReservedInstance::instanceTypeAsString)).setter(ReservedInstance.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(ReservedInstance.getter(ReservedInstance::startTime)).setter(ReservedInstance.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Integer> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Duration").getter(ReservedInstance.getter(ReservedInstance::duration)).setter(ReservedInstance.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<Double> FIXED_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("FixedPrice").getter(ReservedInstance.getter(ReservedInstance::fixedPrice)).setter(ReservedInstance.setter(Builder::fixedPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FixedPrice").build()}).build();
    private static final SdkField<Double> USAGE_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("UsagePrice").getter(ReservedInstance.getter(ReservedInstance::usagePrice)).setter(ReservedInstance.setter(Builder::usagePrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsagePrice").build()}).build();
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrencyCode").getter(ReservedInstance.getter(ReservedInstance::currencyCode)).setter(ReservedInstance.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()}).build();
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstanceCount").getter(ReservedInstance.getter(ReservedInstance::instanceCount)).setter(ReservedInstance.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ReservedInstance.getter(ReservedInstance::state)).setter(ReservedInstance.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PaymentOption").getter(ReservedInstance.getter(ReservedInstance::paymentOptionAsString)).setter(ReservedInstance.setter(Builder::paymentOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentOption").build()}).build();
    private static final SdkField<List<RecurringCharge>> RECURRING_CHARGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RecurringCharges").getter(ReservedInstance.getter(ReservedInstance::recurringCharges)).setter(ReservedInstance.setter(Builder::recurringCharges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurringCharges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecurringCharge::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVATION_NAME_FIELD, RESERVED_INSTANCE_ID_FIELD, BILLING_SUBSCRIPTION_ID_FIELD, RESERVED_INSTANCE_OFFERING_ID_FIELD, INSTANCE_TYPE_FIELD, START_TIME_FIELD, DURATION_FIELD, FIXED_PRICE_FIELD, USAGE_PRICE_FIELD, CURRENCY_CODE_FIELD, INSTANCE_COUNT_FIELD, STATE_FIELD, PAYMENT_OPTION_FIELD, RECURRING_CHARGES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReservedInstance.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String reservationName;
    private final String reservedInstanceId;
    private final Long billingSubscriptionId;
    private final String reservedInstanceOfferingId;
    private final String instanceType;
    private final Instant startTime;
    private final Integer duration;
    private final Double fixedPrice;
    private final Double usagePrice;
    private final String currencyCode;
    private final Integer instanceCount;
    private final String state;
    private final String paymentOption;
    private final List<RecurringCharge> recurringCharges;

    private ReservedInstance(BuilderImpl builder) {
        this.reservationName = builder.reservationName;
        this.reservedInstanceId = builder.reservedInstanceId;
        this.billingSubscriptionId = builder.billingSubscriptionId;
        this.reservedInstanceOfferingId = builder.reservedInstanceOfferingId;
        this.instanceType = builder.instanceType;
        this.startTime = builder.startTime;
        this.duration = builder.duration;
        this.fixedPrice = builder.fixedPrice;
        this.usagePrice = builder.usagePrice;
        this.currencyCode = builder.currencyCode;
        this.instanceCount = builder.instanceCount;
        this.state = builder.state;
        this.paymentOption = builder.paymentOption;
        this.recurringCharges = builder.recurringCharges;
    }

    public final String reservationName() {
        return this.reservationName;
    }

    public final String reservedInstanceId() {
        return this.reservedInstanceId;
    }

    public final Long billingSubscriptionId() {
        return this.billingSubscriptionId;
    }

    public final String reservedInstanceOfferingId() {
        return this.reservedInstanceOfferingId;
    }

    public final OpenSearchPartitionInstanceType instanceType() {
        return OpenSearchPartitionInstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Integer duration() {
        return this.duration;
    }

    public final Double fixedPrice() {
        return this.fixedPrice;
    }

    public final Double usagePrice() {
        return this.usagePrice;
    }

    public final String currencyCode() {
        return this.currencyCode;
    }

    public final Integer instanceCount() {
        return this.instanceCount;
    }

    public final String state() {
        return this.state;
    }

    public final ReservedInstancePaymentOption paymentOption() {
        return ReservedInstancePaymentOption.fromValue(this.paymentOption);
    }

    public final String paymentOptionAsString() {
        return this.paymentOption;
    }

    public final boolean hasRecurringCharges() {
        return this.recurringCharges != null && !(this.recurringCharges instanceof SdkAutoConstructList);
    }

    public final List<RecurringCharge> recurringCharges() {
        return this.recurringCharges;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingSubscriptionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstanceOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixedPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.usagePrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.paymentOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecurringCharges() ? this.recurringCharges() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstance)) {
            return false;
        }
        ReservedInstance other = (ReservedInstance)obj;
        return Objects.equals(this.reservationName(), other.reservationName()) && Objects.equals(this.reservedInstanceId(), other.reservedInstanceId()) && Objects.equals(this.billingSubscriptionId(), other.billingSubscriptionId()) && Objects.equals(this.reservedInstanceOfferingId(), other.reservedInstanceOfferingId()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.fixedPrice(), other.fixedPrice()) && Objects.equals(this.usagePrice(), other.usagePrice()) && Objects.equals(this.currencyCode(), other.currencyCode()) && Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.paymentOptionAsString(), other.paymentOptionAsString()) && this.hasRecurringCharges() == other.hasRecurringCharges() && Objects.equals(this.recurringCharges(), other.recurringCharges());
    }

    public final String toString() {
        return ToString.builder((String)"ReservedInstance").add("ReservationName", (Object)this.reservationName()).add("ReservedInstanceId", (Object)this.reservedInstanceId()).add("BillingSubscriptionId", (Object)this.billingSubscriptionId()).add("ReservedInstanceOfferingId", (Object)this.reservedInstanceOfferingId()).add("InstanceType", (Object)this.instanceTypeAsString()).add("StartTime", (Object)this.startTime()).add("Duration", (Object)this.duration()).add("FixedPrice", (Object)this.fixedPrice()).add("UsagePrice", (Object)this.usagePrice()).add("CurrencyCode", (Object)this.currencyCode()).add("InstanceCount", (Object)this.instanceCount()).add("State", (Object)this.state()).add("PaymentOption", (Object)this.paymentOptionAsString()).add("RecurringCharges", this.hasRecurringCharges() ? this.recurringCharges() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservationName": {
                return Optional.ofNullable(clazz.cast(this.reservationName()));
            }
            case "ReservedInstanceId": {
                return Optional.ofNullable(clazz.cast(this.reservedInstanceId()));
            }
            case "BillingSubscriptionId": {
                return Optional.ofNullable(clazz.cast(this.billingSubscriptionId()));
            }
            case "ReservedInstanceOfferingId": {
                return Optional.ofNullable(clazz.cast(this.reservedInstanceOfferingId()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "FixedPrice": {
                return Optional.ofNullable(clazz.cast(this.fixedPrice()));
            }
            case "UsagePrice": {
                return Optional.ofNullable(clazz.cast(this.usagePrice()));
            }
            case "CurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCode()));
            }
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "PaymentOption": {
                return Optional.ofNullable(clazz.cast(this.paymentOptionAsString()));
            }
            case "RecurringCharges": {
                return Optional.ofNullable(clazz.cast(this.recurringCharges()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReservationName", RESERVATION_NAME_FIELD);
        map.put("ReservedInstanceId", RESERVED_INSTANCE_ID_FIELD);
        map.put("BillingSubscriptionId", BILLING_SUBSCRIPTION_ID_FIELD);
        map.put("ReservedInstanceOfferingId", RESERVED_INSTANCE_OFFERING_ID_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("Duration", DURATION_FIELD);
        map.put("FixedPrice", FIXED_PRICE_FIELD);
        map.put("UsagePrice", USAGE_PRICE_FIELD);
        map.put("CurrencyCode", CURRENCY_CODE_FIELD);
        map.put("InstanceCount", INSTANCE_COUNT_FIELD);
        map.put("State", STATE_FIELD);
        map.put("PaymentOption", PAYMENT_OPTION_FIELD);
        map.put("RecurringCharges", RECURRING_CHARGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReservedInstance, T> g) {
        return obj -> g.apply((ReservedInstance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String reservationName;
        private String reservedInstanceId;
        private Long billingSubscriptionId;
        private String reservedInstanceOfferingId;
        private String instanceType;
        private Instant startTime;
        private Integer duration;
        private Double fixedPrice;
        private Double usagePrice;
        private String currencyCode;
        private Integer instanceCount;
        private String state;
        private String paymentOption;
        private List<RecurringCharge> recurringCharges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstance model) {
            this.reservationName(model.reservationName);
            this.reservedInstanceId(model.reservedInstanceId);
            this.billingSubscriptionId(model.billingSubscriptionId);
            this.reservedInstanceOfferingId(model.reservedInstanceOfferingId);
            this.instanceType(model.instanceType);
            this.startTime(model.startTime);
            this.duration(model.duration);
            this.fixedPrice(model.fixedPrice);
            this.usagePrice(model.usagePrice);
            this.currencyCode(model.currencyCode);
            this.instanceCount(model.instanceCount);
            this.state(model.state);
            this.paymentOption(model.paymentOption);
            this.recurringCharges(model.recurringCharges);
        }

        public final String getReservationName() {
            return this.reservationName;
        }

        public final void setReservationName(String reservationName) {
            this.reservationName = reservationName;
        }

        @Override
        public final Builder reservationName(String reservationName) {
            this.reservationName = reservationName;
            return this;
        }

        public final String getReservedInstanceId() {
            return this.reservedInstanceId;
        }

        public final void setReservedInstanceId(String reservedInstanceId) {
            this.reservedInstanceId = reservedInstanceId;
        }

        @Override
        public final Builder reservedInstanceId(String reservedInstanceId) {
            this.reservedInstanceId = reservedInstanceId;
            return this;
        }

        public final Long getBillingSubscriptionId() {
            return this.billingSubscriptionId;
        }

        public final void setBillingSubscriptionId(Long billingSubscriptionId) {
            this.billingSubscriptionId = billingSubscriptionId;
        }

        @Override
        public final Builder billingSubscriptionId(Long billingSubscriptionId) {
            this.billingSubscriptionId = billingSubscriptionId;
            return this;
        }

        public final String getReservedInstanceOfferingId() {
            return this.reservedInstanceOfferingId;
        }

        public final void setReservedInstanceOfferingId(String reservedInstanceOfferingId) {
            this.reservedInstanceOfferingId = reservedInstanceOfferingId;
        }

        @Override
        public final Builder reservedInstanceOfferingId(String reservedInstanceOfferingId) {
            this.reservedInstanceOfferingId = reservedInstanceOfferingId;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(OpenSearchPartitionInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final Double getFixedPrice() {
            return this.fixedPrice;
        }

        public final void setFixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        @Override
        public final Builder fixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final Double getUsagePrice() {
            return this.usagePrice;
        }

        public final void setUsagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
        }

        @Override
        public final Builder usagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
            return this;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getPaymentOption() {
            return this.paymentOption;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(ReservedInstancePaymentOption paymentOption) {
            this.paymentOption(paymentOption == null ? null : paymentOption.toString());
            return this;
        }

        public final List<RecurringCharge.Builder> getRecurringCharges() {
            List<RecurringCharge.Builder> result = RecurringChargeListCopier.copyToBuilder(this.recurringCharges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecurringCharges(Collection<RecurringCharge.BuilderImpl> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copyFromBuilder(recurringCharges);
        }

        @Override
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge ... recurringCharges) {
            this.recurringCharges(Arrays.asList(recurringCharges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(Consumer<RecurringCharge.Builder> ... recurringCharges) {
            this.recurringCharges(Stream.of(recurringCharges).map(c -> (RecurringCharge)((RecurringCharge.Builder)RecurringCharge.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ReservedInstance build() {
            return new ReservedInstance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReservedInstance> {
        public Builder reservationName(String var1);

        public Builder reservedInstanceId(String var1);

        public Builder billingSubscriptionId(Long var1);

        public Builder reservedInstanceOfferingId(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(OpenSearchPartitionInstanceType var1);

        public Builder startTime(Instant var1);

        public Builder duration(Integer var1);

        public Builder fixedPrice(Double var1);

        public Builder usagePrice(Double var1);

        public Builder currencyCode(String var1);

        public Builder instanceCount(Integer var1);

        public Builder state(String var1);

        public Builder paymentOption(String var1);

        public Builder paymentOption(ReservedInstancePaymentOption var1);

        public Builder recurringCharges(Collection<RecurringCharge> var1);

        public Builder recurringCharges(RecurringCharge ... var1);

        public Builder recurringCharges(Consumer<RecurringCharge.Builder> ... var1);
    }
}

