/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldb.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum S3ObjectEncryptionType {
    SSE_KMS("SSE_KMS"),
    SSE_S3("SSE_S3"),
    NO_ENCRYPTION("NO_ENCRYPTION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private S3ObjectEncryptionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static S3ObjectEncryptionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(S3ObjectEncryptionType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<S3ObjectEncryptionType> knownValues() {
        return Stream.of(S3ObjectEncryptionType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

