/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.MonitoringExecutionSummary;
import software.amazon.awssdk.services.sagemaker.model.MonitoringExecutionSummaryListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMonitoringExecutionsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListMonitoringExecutionsResponse> {
    private static final SdkField<List<MonitoringExecutionSummary>> MONITORING_EXECUTION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListMonitoringExecutionsResponse.getter(ListMonitoringExecutionsResponse::monitoringExecutionSummaries)).setter(ListMonitoringExecutionsResponse.setter(Builder::monitoringExecutionSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringExecutionSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MonitoringExecutionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListMonitoringExecutionsResponse.getter(ListMonitoringExecutionsResponse::nextToken)).setter(ListMonitoringExecutionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITORING_EXECUTION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<MonitoringExecutionSummary> monitoringExecutionSummaries;
    private final String nextToken;

    private ListMonitoringExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.monitoringExecutionSummaries = builder.monitoringExecutionSummaries;
        this.nextToken = builder.nextToken;
    }

    public boolean hasMonitoringExecutionSummaries() {
        return this.monitoringExecutionSummaries != null && !(this.monitoringExecutionSummaries instanceof SdkAutoConstructList);
    }

    public List<MonitoringExecutionSummary> monitoringExecutionSummaries() {
        return this.monitoringExecutionSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringExecutionSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMonitoringExecutionsResponse)) {
            return false;
        }
        ListMonitoringExecutionsResponse other = (ListMonitoringExecutionsResponse)((Object)obj);
        return Objects.equals(this.monitoringExecutionSummaries(), other.monitoringExecutionSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListMonitoringExecutionsResponse").add("MonitoringExecutionSummaries", this.monitoringExecutionSummaries()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MonitoringExecutionSummaries": {
                return Optional.ofNullable(clazz.cast(this.monitoringExecutionSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMonitoringExecutionsResponse, T> g) {
        return obj -> g.apply((ListMonitoringExecutionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<MonitoringExecutionSummary> monitoringExecutionSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMonitoringExecutionsResponse model) {
            super(model);
            this.monitoringExecutionSummaries(model.monitoringExecutionSummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<MonitoringExecutionSummary.Builder> getMonitoringExecutionSummaries() {
            return this.monitoringExecutionSummaries != null ? (Collection)this.monitoringExecutionSummaries.stream().map(MonitoringExecutionSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder monitoringExecutionSummaries(Collection<MonitoringExecutionSummary> monitoringExecutionSummaries) {
            this.monitoringExecutionSummaries = MonitoringExecutionSummaryListCopier.copy(monitoringExecutionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitoringExecutionSummaries(MonitoringExecutionSummary ... monitoringExecutionSummaries) {
            this.monitoringExecutionSummaries(Arrays.asList(monitoringExecutionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitoringExecutionSummaries(Consumer<MonitoringExecutionSummary.Builder> ... monitoringExecutionSummaries) {
            this.monitoringExecutionSummaries(Stream.of(monitoringExecutionSummaries).map(c -> (MonitoringExecutionSummary)((MonitoringExecutionSummary.Builder)MonitoringExecutionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMonitoringExecutionSummaries(Collection<MonitoringExecutionSummary.BuilderImpl> monitoringExecutionSummaries) {
            this.monitoringExecutionSummaries = MonitoringExecutionSummaryListCopier.copyFromBuilder(monitoringExecutionSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListMonitoringExecutionsResponse build() {
            return new ListMonitoringExecutionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMonitoringExecutionsResponse> {
        public Builder monitoringExecutionSummaries(Collection<MonitoringExecutionSummary> var1);

        public Builder monitoringExecutionSummaries(MonitoringExecutionSummary ... var1);

        public Builder monitoringExecutionSummaries(Consumer<MonitoringExecutionSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

