/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wafv2.model.Wafv2Response;
import software.amazon.awssdk.services.wafv2.model.WebACL;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetWebAclResponse
extends Wafv2Response
implements ToCopyableBuilder<Builder, GetWebAclResponse> {
    private static final SdkField<WebACL> WEB_ACL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetWebAclResponse.getter(GetWebAclResponse::webACL)).setter(GetWebAclResponse.setter(Builder::webACL)).constructor(WebACL::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebACL").build()}).build();
    private static final SdkField<String> LOCK_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetWebAclResponse.getter(GetWebAclResponse::lockToken)).setter(GetWebAclResponse.setter(Builder::lockToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_ACL_FIELD, LOCK_TOKEN_FIELD));
    private final WebACL webACL;
    private final String lockToken;

    private GetWebAclResponse(BuilderImpl builder) {
        super(builder);
        this.webACL = builder.webACL;
        this.lockToken = builder.lockToken;
    }

    public WebACL webACL() {
        return this.webACL;
    }

    public String lockToken() {
        return this.lockToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.webACL());
        hashCode = 31 * hashCode + Objects.hashCode(this.lockToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWebAclResponse)) {
            return false;
        }
        GetWebAclResponse other = (GetWebAclResponse)((Object)obj);
        return Objects.equals(this.webACL(), other.webACL()) && Objects.equals(this.lockToken(), other.lockToken());
    }

    public String toString() {
        return ToString.builder((String)"GetWebAclResponse").add("WebACL", (Object)this.webACL()).add("LockToken", (Object)this.lockToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WebACL": {
                return Optional.ofNullable(clazz.cast(this.webACL()));
            }
            case "LockToken": {
                return Optional.ofNullable(clazz.cast(this.lockToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWebAclResponse, T> g) {
        return obj -> g.apply((GetWebAclResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Wafv2Response.BuilderImpl
    implements Builder {
        private WebACL webACL;
        private String lockToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWebAclResponse model) {
            super(model);
            this.webACL(model.webACL);
            this.lockToken(model.lockToken);
        }

        public final WebACL.Builder getWebACL() {
            return this.webACL != null ? this.webACL.toBuilder() : null;
        }

        @Override
        public final Builder webACL(WebACL webACL) {
            this.webACL = webACL;
            return this;
        }

        public final void setWebACL(WebACL.BuilderImpl webACL) {
            this.webACL = webACL != null ? webACL.build() : null;
        }

        public final String getLockToken() {
            return this.lockToken;
        }

        @Override
        public final Builder lockToken(String lockToken) {
            this.lockToken = lockToken;
            return this;
        }

        public final void setLockToken(String lockToken) {
            this.lockToken = lockToken;
        }

        @Override
        public GetWebAclResponse build() {
            return new GetWebAclResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Wafv2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetWebAclResponse> {
        public Builder webACL(WebACL var1);

        default public Builder webACL(Consumer<WebACL.Builder> webACL) {
            return this.webACL((WebACL)((WebACL.Builder)WebACL.builder().applyMutation(webACL)).build());
        }

        public Builder lockToken(String var1);
    }
}

