/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.web.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Optional;
import java.util.TimeZone;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import tech.powerjob.common.model.WorkerAppInfo;
import tech.powerjob.common.request.ServerDiscoveryRequest;
import tech.powerjob.common.response.ResultDTO;
import tech.powerjob.common.utils.CommonUtils;
import tech.powerjob.common.utils.NetUtils;
import tech.powerjob.server.common.aware.ServerInfoAware;
import tech.powerjob.server.common.module.ServerInfo;
import tech.powerjob.server.persistence.remote.repository.AppInfoRepository;
import tech.powerjob.server.remote.server.election.ServerElectionService;
import tech.powerjob.server.remote.transporter.TransportService;
import tech.powerjob.server.remote.worker.WorkerClusterQueryService;

@RestController
@RequestMapping(value={"/server"})
public class ServerController
implements ServerInfoAware {
    private ServerInfo serverInfo;
    private final TransportService transportService;
    private final ServerElectionService serverElectionService;
    private final AppInfoRepository appInfoRepository;
    private final WorkerClusterQueryService workerClusterQueryService;

    @GetMapping(value={"/assert"})
    public ResultDTO<Long> assertAppName(String appName) {
        Optional appInfoOpt = this.appInfoRepository.findByAppName(appName);
        return appInfoOpt.map(appInfoDO -> ResultDTO.success((Object)appInfoDO.getId())).orElseGet(() -> ResultDTO.failed((String)String.format("app(%s) is not registered! Please register the app in oms-console first.", appName)));
    }

    @GetMapping(value={"/assertV2"})
    public ResultDTO<WorkerAppInfo> assertAppNameV2(String appName) {
        Optional appInfoOpt = this.appInfoRepository.findByAppName(appName);
        return appInfoOpt.map(appInfoDO -> {
            WorkerAppInfo workerAppInfo = new WorkerAppInfo().setAppId(appInfoDO.getId());
            return ResultDTO.success((Object)workerAppInfo);
        }).orElseGet(() -> ResultDTO.failed((String)String.format("app(%s) is not registered! Please register the app in oms-console first.", appName)));
    }

    @GetMapping(value={"/acquire"})
    public ResultDTO<String> acquireServer(ServerDiscoveryRequest request) {
        return ResultDTO.success((Object)this.serverElectionService.elect(request));
    }

    @GetMapping(value={"/hello"})
    public ResultDTO<JSONObject> ping(@RequestParam(required=false) boolean debug) {
        JSONObject res = new JSONObject();
        res.put("localHost", (Object)NetUtils.getLocalHost());
        res.put("serverInfo", (Object)this.serverInfo);
        res.put("serverTime", (Object)CommonUtils.formatTime((Long)System.currentTimeMillis()));
        res.put("serverTimeTs", (Object)System.currentTimeMillis());
        res.put("serverTimeZone", (Object)TimeZone.getDefault().getDisplayName());
        res.put("appIds", this.workerClusterQueryService.getAppId2ClusterStatus().keySet());
        if (debug) {
            res.put("appId2ClusterInfo", (Object)JSON.parseObject((String)JSON.toJSONString((Object)this.workerClusterQueryService.getAppId2ClusterStatus())));
        }
        try {
            res.put("defaultAddress", JSONObject.toJSON((Object)this.transportService.defaultProtocol()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ResultDTO.success((Object)res);
    }

    public void setServerInfo(ServerInfo serverInfo) {
        this.serverInfo = serverInfo;
    }

    public ServerController(TransportService transportService, ServerElectionService serverElectionService, AppInfoRepository appInfoRepository, WorkerClusterQueryService workerClusterQueryService) {
        this.transportService = transportService;
        this.serverElectionService = serverElectionService;
        this.appInfoRepository = appInfoRepository;
        this.workerClusterQueryService = workerClusterQueryService;
    }
}

