/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.web.controller;

import java.text.ParseException;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import tech.powerjob.common.request.http.SaveWorkflowNodeRequest;
import tech.powerjob.common.request.http.SaveWorkflowRequest;
import tech.powerjob.common.response.ResultDTO;
import tech.powerjob.server.common.constants.SwitchableStatus;
import tech.powerjob.server.core.workflow.WorkflowService;
import tech.powerjob.server.persistence.PageResult;
import tech.powerjob.server.persistence.remote.model.WorkflowInfoDO;
import tech.powerjob.server.persistence.remote.model.WorkflowNodeInfoDO;
import tech.powerjob.server.persistence.remote.repository.WorkflowInfoRepository;
import tech.powerjob.server.web.request.QueryWorkflowInfoRequest;
import tech.powerjob.server.web.response.WorkflowInfoVO;

@RestController
@RequestMapping(value={"/workflow"})
public class WorkflowController {
    @Resource
    private WorkflowService workflowService;
    @Resource
    private WorkflowInfoRepository workflowInfoRepository;

    @PostMapping(value={"/save"})
    public ResultDTO<Long> save(@RequestBody SaveWorkflowRequest req) throws ParseException {
        return ResultDTO.success((Object)this.workflowService.saveWorkflow(req));
    }

    @PostMapping(value={"/copy"})
    public ResultDTO<Long> copy(Long workflowId, Long appId) {
        return ResultDTO.success((Object)this.workflowService.copyWorkflow(workflowId, appId));
    }

    @GetMapping(value={"/disable"})
    public ResultDTO<Void> disableWorkflow(Long workflowId, Long appId) {
        this.workflowService.disableWorkflow(workflowId, appId);
        return ResultDTO.success(null);
    }

    @GetMapping(value={"/enable"})
    public ResultDTO<Void> enableWorkflow(Long workflowId, Long appId) {
        this.workflowService.enableWorkflow(workflowId, appId);
        return ResultDTO.success(null);
    }

    @GetMapping(value={"/delete"})
    public ResultDTO<Void> deleteWorkflow(Long workflowId, Long appId) {
        this.workflowService.deleteWorkflow(workflowId, appId);
        return ResultDTO.success(null);
    }

    @PostMapping(value={"/list"})
    public ResultDTO<PageResult<WorkflowInfoVO>> list(@RequestBody QueryWorkflowInfoRequest req) {
        Page wfPage;
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"gmtCreate"});
        PageRequest pageRequest = PageRequest.of((int)req.getIndex(), (int)req.getPageSize(), (Sort)sort);
        int nStatus = SwitchableStatus.DELETED.getV();
        if (req.getWorkflowId() == null && StringUtils.isEmpty((CharSequence)req.getKeyword())) {
            wfPage = this.workflowInfoRepository.findByAppIdAndStatusNot(req.getAppId(), nStatus, (Pageable)pageRequest);
        } else if (req.getWorkflowId() != null) {
            wfPage = this.workflowInfoRepository.findByIdAndStatusNot(req.getWorkflowId(), nStatus, (Pageable)pageRequest);
        } else {
            String condition = "%" + req.getKeyword() + "%";
            wfPage = this.workflowInfoRepository.findByAppIdAndStatusNotAndWfNameLike(req.getAppId(), nStatus, condition, (Pageable)pageRequest);
        }
        return ResultDTO.success(WorkflowController.convertPage((Page<WorkflowInfoDO>)wfPage));
    }

    @GetMapping(value={"/run"})
    public ResultDTO<Long> runWorkflow(Long workflowId, Long appId, @RequestParam(required=false, defaultValue="0") Long delay, @RequestParam(required=false) String initParams) {
        return ResultDTO.success((Object)this.workflowService.runWorkflow(workflowId, appId, initParams, delay));
    }

    @GetMapping(value={"/fetch"})
    public ResultDTO<WorkflowInfoVO> fetchWorkflow(Long workflowId, Long appId) {
        WorkflowInfoDO workflowInfoDO = this.workflowService.fetchWorkflow(workflowId, appId);
        return ResultDTO.success((Object)WorkflowInfoVO.from(workflowInfoDO));
    }

    @PostMapping(value={"/saveNode"})
    public ResultDTO<List<WorkflowNodeInfoDO>> addWorkflowNode(@RequestBody List<SaveWorkflowNodeRequest> request) {
        return ResultDTO.success((Object)this.workflowService.saveWorkflowNode(request));
    }

    private static PageResult<WorkflowInfoVO> convertPage(Page<WorkflowInfoDO> originPage) {
        PageResult newPage = new PageResult(originPage);
        newPage.setData(originPage.getContent().stream().map(WorkflowInfoVO::from).collect(Collectors.toList()));
        return newPage;
    }
}

