/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil;

public final class ByteUtil {
    private ByteUtil() {
    }

    public static int compareSortedBytes(byte[] bytes1, byte[] bytes2) {
        int minLength = Math.min(bytes1.length, bytes2.length);
        for (int i = 0; i < minLength; ++i) {
            if (bytes1[i] == bytes2[i]) continue;
            return Byte.compare(bytes1[i], bytes2[i]);
        }
        return bytes1.length - bytes2.length;
    }

    public static boolean areSortedBytesEqual(byte[] bytes1, byte[] bytes2) {
        if (bytes1 == bytes2) {
            return true;
        }
        int last = bytes1.length;
        if (last != bytes2.length) {
            return false;
        }
        if (0 == last) {
            return true;
        }
        if (bytes1[--last] == bytes2[last]) {
            for (int i = 0; i < last; ++i) {
                if (bytes1[i] == bytes2[i]) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }
}

