/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil.iterable;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import uk.gov.gchq.gaffer.commonutil.OneOrMore;
import uk.gov.gchq.gaffer.commonutil.ToStringBuilder;
import uk.gov.gchq.gaffer.commonutil.iterable.ChainedIterable;

public class LimitedInMemorySortedIterable<E>
implements Iterable<E> {
    private final Comparator<E> comparator;
    private final boolean deduplicate;
    private final Integer limit;
    private final TreeMap<E, OneOrMore<E>> backingMap;
    private int size;

    public LimitedInMemorySortedIterable(Comparator<E> comparator) {
        this(comparator, null);
    }

    public LimitedInMemorySortedIterable(Comparator<E> comparator, Integer limit) {
        this(comparator, limit, false);
    }

    public LimitedInMemorySortedIterable(Comparator<E> comparator, Integer limit, boolean deduplicate) {
        if (null == comparator) {
            throw new IllegalArgumentException("Comparator is required");
        }
        if (null != limit && 1 > limit) {
            throw new IllegalArgumentException("Limit cannot be less than or equal to 0");
        }
        this.comparator = comparator;
        this.deduplicate = deduplicate;
        this.limit = limit;
        this.backingMap = new TreeMap(comparator);
        this.size = 0;
    }

    public boolean add(E e) {
        boolean skipItem;
        boolean result = false;
        OneOrMore<E> values = this.backingMap.get(e);
        boolean bl = skipItem = this.deduplicate && null != values && values.contains(e);
        if (!skipItem) {
            if (null != this.limit && this.size >= this.limit) {
                Map.Entry<E, OneOrMore<E>> last = this.backingMap.lastEntry();
                if (0 < this.comparator.compare(last.getKey(), e)) {
                    if (1 < last.getValue().size()) {
                        last.getValue().removeAnyItem();
                    } else {
                        this.backingMap.remove(last.getKey());
                    }
                    --this.size;
                } else {
                    skipItem = true;
                }
            }
            if (!skipItem) {
                if (null == values) {
                    this.backingMap.put(e, new OneOrMore<E>(this.deduplicate, e));
                    ++this.size;
                    result = true;
                } else if (values.add(e)) {
                    ++this.size;
                    result = true;
                }
            }
        }
        return result;
    }

    public boolean addAll(Iterable<E> items) {
        boolean result = false;
        for (E item : items) {
            if (!this.add(item)) continue;
            result = true;
        }
        return result;
    }

    public int size() {
        return this.size;
    }

    @Override
    public Iterator<E> iterator() {
        if (this.backingMap.isEmpty()) {
            return Collections.emptyIterator();
        }
        Iterable[] values = (Iterable[])Iterables.toArray(this.backingMap.values(), Iterable.class);
        if (0 == values.length) {
            return Collections.emptyIterator();
        }
        return new ChainedIterable(values).iterator();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || this.getClass() != obj.getClass()) {
            return false;
        }
        LimitedInMemorySortedIterable that = (LimitedInMemorySortedIterable)obj;
        return new EqualsBuilder().append(this.size, that.size).append((Object)this.limit, (Object)that.limit).append(this.deduplicate, that.deduplicate).append(this.backingMap, that.backingMap).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.size).append((Object)this.limit).append(this.deduplicate).append(this.backingMap).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder(this).append("size", this.size).append("limit", (Object)this.limit).append("deduplicate", this.deduplicate).append("backingMap", this.backingMap).toString();
    }
}

