/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil.iterable;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import uk.gov.gchq.gaffer.commonutil.CloseableUtil;
import uk.gov.gchq.gaffer.commonutil.iterable.CloseableIterable;
import uk.gov.gchq.gaffer.commonutil.iterable.CloseableIterator;
import uk.gov.gchq.gaffer.commonutil.iterable.WrappedCloseableIterable;

public class SuppliedIterable<T>
implements CloseableIterable<T> {
    private List<Iterable<T>> closeables = new ArrayList<Iterable<T>>();
    private final Supplier<? extends Iterable<T>> supplier;

    public SuppliedIterable(Supplier<? extends Iterable<T>> supplier) {
        if (null == supplier) {
            throw new IllegalArgumentException("Supplier is required");
        }
        this.supplier = supplier;
    }

    @Override
    public CloseableIterator<T> iterator() {
        Iterable<T> iterable = this.supplier.get();
        this.closeables.add(iterable);
        return new WrappedCloseableIterable<T>(iterable).iterator();
    }

    @Override
    public void close() {
        this.closeables.forEach(CloseableUtil::close);
    }
}

