/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.jsonserialisation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.BeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.datatype.jsr310.JSR310Module;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.jsonserialisation.JSONSerialiserModules;
import uk.gov.gchq.gaffer.jsonserialisation.jackson.CloseableIterableDeserializer;
import uk.gov.gchq.koryphe.impl.binaryoperator.StringDeduplicateConcat;
import uk.gov.gchq.koryphe.serialisation.json.SimpleClassNameCache;
import uk.gov.gchq.koryphe.serialisation.json.SimpleClassNameIdResolver;

public class JSONSerialiser {
    public static final String JSON_SERIALISER_CLASS_KEY = "gaffer.serialiser.json.class";
    public static final String JSON_SERIALISER_MODULES = "gaffer.serialiser.json.modules";
    public static final String DEFAULT_SERIALISER_CLASS_NAME = JSONSerialiser.class.getName();
    public static final String STRICT_JSON = "gaffer.serialiser.json.strict";
    public static final boolean STRICT_JSON_DEFAULT = false;
    private static final String STRICT_JSON_DEFAULT_STR = Boolean.toString(false);
    public static final String FILTER_FIELDS_BY_NAME = "filterFieldsByName";
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private static final Logger LOGGER = LoggerFactory.getLogger(JSONSerialiser.class);
    private static JSONSerialiser instance;
    private final ObjectMapper mapper;

    protected JSONSerialiser() {
        this(JSONSerialiser.createDefaultMapper());
    }

    protected JSONSerialiser(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    protected void registerModules(Module ... modules) {
        for (Module module : modules) {
            this.mapper.registerModule(module);
        }
    }

    protected void registerModules(Collection<Module> modules) {
        modules.forEach(arg_0 -> ((ObjectMapper)this.mapper).registerModule(arg_0));
    }

    public static void addSimpleClassNames(boolean includeSubtypes, Class ... classes) {
        SimpleClassNameCache.addSimpleClassNames((boolean)includeSubtypes, (Class[])classes);
    }

    @Deprecated
    public static void update(String jsonSerialiserClass, String jsonSerialiserModules) {
        JSONSerialiser.update(jsonSerialiserClass, jsonSerialiserModules, null);
    }

    public static void update(String jsonSerialiserClass, String jsonSerialiserModules, Boolean strictJson) {
        if (StringUtils.isNotBlank((CharSequence)jsonSerialiserModules)) {
            String modulesCsv = (String)new StringDeduplicateConcat().apply((Object)System.getProperty(JSON_SERIALISER_MODULES), (Object)jsonSerialiserModules);
            System.setProperty(JSON_SERIALISER_MODULES, modulesCsv);
        }
        if (null != jsonSerialiserClass) {
            System.setProperty(JSON_SERIALISER_CLASS_KEY, jsonSerialiserClass);
        }
        if (null != strictJson) {
            System.setProperty(STRICT_JSON, strictJson.toString());
        }
        JSONSerialiser.update();
    }

    public static void update() {
        JSONSerialiser newInstance;
        String jsonSerialiserClass = System.getProperty(JSON_SERIALISER_CLASS_KEY, DEFAULT_SERIALISER_CLASS_NAME);
        try {
            newInstance = Class.forName(jsonSerialiserClass).asSubclass(JSONSerialiser.class).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Property gaffer.serialiser.json.class must be set to a class that is a sub class of " + JSONSerialiser.class.getName() + ". This class is not valid: " + jsonSerialiserClass, e);
        }
        String moduleFactories = System.getProperty(JSON_SERIALISER_MODULES, "");
        HashSet factoryClasses = Sets.newHashSet((Object[])moduleFactories.split(","));
        factoryClasses.remove("");
        for (String factoryClass : factoryClasses) {
            JSONSerialiserModules factory;
            try {
                factory = Class.forName(factoryClass).asSubclass(JSONSerialiserModules.class).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException("Property gaffer.serialiser.json.modules must be set to a csv of classes that are a sub class of " + JSONSerialiserModules.class.getName() + ". These classes are not valid: " + factoryClass, e);
            }
            List<Module> modules = factory.getModules();
            if (null == modules) continue;
            newInstance.mapper.registerModules(modules);
        }
        newInstance.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, Boolean.parseBoolean(System.getProperty(STRICT_JSON, STRICT_JSON_DEFAULT_STR)));
        instance = newInstance;
        LOGGER.debug("Updated json serialiser to use: {}, and modules: {}", (Object)jsonSerialiserClass, (Object)moduleFactories);
    }

    public static ObjectMapper createDefaultMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(SerializationFeature.CLOSE_CLOSEABLE, true);
        mapper.disable(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE);
        mapper.registerModule((Module)CloseableIterableDeserializer.getModule());
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.registerModule((Module)new JSR310Module());
        mapper.setFilters(JSONSerialiser.getFilterProvider(new String[0]));
        SimpleClassNameCache.setUseFullNameForSerialisation((boolean)true);
        SimpleClassNameIdResolver.configureObjectMapper((ObjectMapper)mapper);
        return mapper;
    }

    public static FilterProvider getFilterProvider(String ... fieldsToExclude) {
        if (null == fieldsToExclude || fieldsToExclude.length == 0) {
            return new SimpleFilterProvider().addFilter(FILTER_FIELDS_BY_NAME, (BeanPropertyFilter)SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[0]));
        }
        return new SimpleFilterProvider().addFilter(FILTER_FIELDS_BY_NAME, (BeanPropertyFilter)SimpleBeanPropertyFilter.serializeAllExcept((String[])fieldsToExclude));
    }

    public static boolean canHandle(Class clazz) {
        return JSONSerialiser.getInstance().mapper.canSerialize(clazz);
    }

    public static byte[] serialise(Object object, String ... fieldsToExclude) throws SerialisationException {
        return JSONSerialiser.serialise(object, false, fieldsToExclude);
    }

    public static byte[] serialise(Object object, boolean prettyPrint, String ... fieldsToExclude) throws SerialisationException {
        ByteArrayBuilder byteArrayBuilder = new ByteArrayBuilder();
        try {
            JSONSerialiser.serialise(object, JSON_FACTORY.createGenerator((OutputStream)byteArrayBuilder, JsonEncoding.UTF8), prettyPrint, fieldsToExclude);
        }
        catch (IOException e) {
            throw new SerialisationException(e.getMessage(), e);
        }
        return byteArrayBuilder.toByteArray();
    }

    public static void serialise(Object object, JsonGenerator jsonGenerator, boolean prettyPrint, String ... fieldsToExclude) throws SerialisationException {
        if (prettyPrint) {
            jsonGenerator.useDefaultPrettyPrinter();
        }
        ObjectWriter writer = JSONSerialiser.getInstance().mapper.writer(JSONSerialiser.getFilterProvider(fieldsToExclude));
        try {
            writer.writeValue(jsonGenerator, object);
        }
        catch (IOException e) {
            throw new SerialisationException("Failed to serialise object to json: " + e.getMessage(), e);
        }
    }

    public static <T> T deserialise(String json, Class<T> clazz) throws SerialisationException {
        try {
            return (T)JSONSerialiser.getInstance().mapper.readValue(json, clazz);
        }
        catch (IOException e) {
            throw new SerialisationException(e.getMessage(), e);
        }
    }

    public static <T> T deserialise(byte[] bytes, Class<T> clazz) throws SerialisationException {
        try {
            return (T)JSONSerialiser.getInstance().mapper.readValue(bytes, clazz);
        }
        catch (IOException e) {
            throw new SerialisationException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T deserialise(InputStream stream, Class<T> clazz) throws SerialisationException {
        try (InputStream stream2 = stream;){
            byte[] bytes = IOUtils.toByteArray((InputStream)stream2);
            T t = JSONSerialiser.deserialise(bytes, clazz);
            return t;
        }
        catch (IOException e) {
            throw new SerialisationException(e.getMessage(), e);
        }
    }

    public static <T> T deserialise(byte[] bytes, TypeReference<T> type) throws SerialisationException {
        try {
            return (T)JSONSerialiser.getInstance().mapper.readValue(bytes, type);
        }
        catch (IOException e) {
            throw new SerialisationException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T deserialise(InputStream stream, TypeReference<T> type) throws SerialisationException {
        try (InputStream stream2 = stream;){
            byte[] bytes = IOUtils.toByteArray((InputStream)stream2);
            T t = JSONSerialiser.deserialise(bytes, type);
            return t;
        }
        catch (IOException e) {
            throw new SerialisationException(e.getMessage(), e);
        }
    }

    public static JsonNode getJsonNodeFromString(String content) throws SerialisationException {
        try {
            return JSONSerialiser.getInstance().mapper.readTree(content);
        }
        catch (IOException e) {
            throw new SerialisationException(e.getMessage(), e);
        }
    }

    @JsonIgnore
    public static ObjectMapper getMapper() {
        return JSONSerialiser.getInstance().mapper;
    }

    @JsonIgnore
    public static JSONSerialiser getInstance() {
        if (null == instance) {
            JSONSerialiser.update();
        }
        return instance;
    }
}

