/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.implementation;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialiser;
import uk.gov.gchq.gaffer.serialisation.util.LengthValueBytesSerialiserUtil;
import uk.gov.gchq.koryphe.serialisation.json.SimpleClassNameIdResolver;

public class MapSerialiser
implements ToBytesSerialiser<Map> {
    private static final long serialVersionUID = 323888878024609587L;
    private ToBytesSerialiser keySerialiser;
    private ToBytesSerialiser valueSerialiser;
    private Class<? extends Map> mapClass;

    @Override
    public boolean canHandle(Class clazz) {
        return Map.class.isAssignableFrom(clazz);
    }

    @Override
    public byte[] serialise(Map object) throws SerialisationException {
        LengthValueBytesSerialiserUtil.LengthValueBuilder builder = new LengthValueBytesSerialiserUtil.LengthValueBuilder();
        try {
            for (Map.Entry o : object.entrySet()) {
                if (o instanceof Map.Entry) {
                    Map.Entry entry = o;
                    ToBytesSerialiser keySerialiser = this.getKeySerialiser();
                    ToBytesSerialiser valueSerialiser = this.getValueSerialiser();
                    this.checkSerialiers(keySerialiser, valueSerialiser);
                    builder.appendLengthValueFromObjectToByteStream(keySerialiser, entry.getKey());
                    builder.appendLengthValueFromObjectToByteStream(valueSerialiser, entry.getValue());
                    continue;
                }
                throw new SerialisationException("Was not able to process EntrySet of Map");
            }
        }
        catch (IOException e) {
            throw new SerialisationException(e.getMessage(), e);
        }
        return builder.toArray();
    }

    protected void checkSerialiers(ToBytesSerialiser keySerialiser, ToBytesSerialiser valueSerialiser) {
        Objects.requireNonNull(keySerialiser, "keySerialiser has to been set.");
        Objects.requireNonNull(valueSerialiser, "valueSerialiser has to been set.");
    }

    @Override
    public Map<? extends Object, ? extends Object> deserialise(byte[] bytes) throws SerialisationException {
        Map map;
        if (null == this.getMapClass()) {
            map = new HashMap();
        } else {
            try {
                map = this.getMapClass().newInstance();
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException e) {
                throw new SerialisationException("Failed to create map instance" + e.getMessage(), e);
            }
        }
        int arrayLength = bytes.length;
        int carriage = 0;
        while (carriage < arrayLength) {
            ToBytesSerialiser keySerialiser = this.getKeySerialiser();
            ToBytesSerialiser valueSerialiser = this.getValueSerialiser();
            this.checkSerialiers(keySerialiser, valueSerialiser);
            LengthValueBytesSerialiserUtil.ObjectCarriage c = LengthValueBytesSerialiserUtil.deserialiseNextObject(keySerialiser, carriage, bytes);
            LengthValueBytesSerialiserUtil.ObjectCarriage c2 = LengthValueBytesSerialiserUtil.deserialiseNextObject(valueSerialiser, c.getCarriage(), bytes);
            map.put(c.getObject(), c2.getObject());
            carriage = c2.getCarriage();
        }
        return map;
    }

    @Override
    public Map<? extends Object, ? extends Object> deserialiseEmpty() throws SerialisationException {
        return null;
    }

    @Override
    public boolean preservesObjectOrdering() {
        return false;
    }

    @Override
    public boolean isConsistent() {
        return false;
    }

    @Override
    public byte[] serialiseNull() {
        return new byte[0];
    }

    @JsonIgnore
    public ToBytesSerialiser getKeySerialiser() {
        return this.keySerialiser;
    }

    @JsonIgnore
    public void setKeySerialiser(ToBytesSerialiser keySerialiser) {
        this.keySerialiser = keySerialiser;
    }

    @JsonGetter(value="keySerialiser")
    public String getKeySerialiserClassString() {
        return null != this.keySerialiser ? SimpleClassNameIdResolver.getSimpleClassName(this.keySerialiser.getClass()) : null;
    }

    @JsonSetter(value="keySerialiser")
    public void setKeySerialiserClassString(String classType) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.keySerialiser = null != classType ? Class.forName(SimpleClassNameIdResolver.getClassName((String)classType)).asSubclass(ToBytesSerialiser.class).newInstance() : null;
    }

    @JsonIgnore
    public ToBytesSerialiser getValueSerialiser() {
        return this.valueSerialiser;
    }

    @JsonIgnore
    public void setValueSerialiser(ToBytesSerialiser valueSerialiser) {
        this.valueSerialiser = valueSerialiser;
    }

    @JsonGetter(value="valueSerialiser")
    public String getValueSerialiserClassString() {
        return null != this.valueSerialiser ? SimpleClassNameIdResolver.getSimpleClassName(this.valueSerialiser.getClass()) : null;
    }

    @JsonSetter(value="valueSerialiser")
    public void setValueSerialiserClassString(String classType) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.valueSerialiser = null != classType ? Class.forName(SimpleClassNameIdResolver.getClassName((String)classType)).asSubclass(ToBytesSerialiser.class).newInstance() : null;
    }

    @JsonGetter(value="mapClass")
    public String getMapClassString() {
        return null != this.mapClass ? SimpleClassNameIdResolver.getSimpleClassName(this.mapClass) : null;
    }

    @JsonSetter(value="mapClass")
    public void setMapClassString(String classType) throws ClassNotFoundException {
        this.mapClass = null != classType ? Class.forName(SimpleClassNameIdResolver.getClassName((String)classType)).asSubclass(Map.class) : null;
    }

    @JsonIgnore
    public Class<? extends Map> getMapClass() {
        return this.mapClass;
    }

    public void setMapClass(Class<? extends Map> mapClass) {
        this.mapClass = mapClass;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || this.getClass() != obj.getClass()) {
            return false;
        }
        MapSerialiser serialiser = (MapSerialiser)obj;
        return new EqualsBuilder().append((Object)this.keySerialiser, (Object)serialiser.keySerialiser).append((Object)this.valueSerialiser, (Object)serialiser.valueSerialiser).append(this.mapClass, serialiser.mapClass).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.keySerialiser).append((Object)this.valueSerialiser).append(this.mapClass).toHashCode();
    }
}

