/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.implementation;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialiser;
import uk.gov.gchq.gaffer.serialisation.util.LengthValueBytesSerialiserUtil;
import uk.gov.gchq.koryphe.serialisation.json.SimpleClassNameIdResolver;

public class SetSerialiser
implements ToBytesSerialiser<Set<? extends Object>> {
    private static final long serialVersionUID = -8681798703430202402L;
    private ToBytesSerialiser objectSerialiser;
    private Class<? extends Set> setClass;

    public SetSerialiser() {
    }

    public SetSerialiser(ToBytesSerialiser objectSerialiser) {
        this.objectSerialiser = objectSerialiser;
    }

    @Override
    public boolean canHandle(Class clazz) {
        return Set.class.isAssignableFrom(clazz);
    }

    @Override
    public byte[] serialise(Set<? extends Object> object) throws SerialisationException {
        LengthValueBytesSerialiserUtil.LengthValueBuilder builder = new LengthValueBytesSerialiserUtil.LengthValueBuilder();
        try {
            for (Object object2 : object) {
                builder.appendLengthValueFromObjectToByteStream(this.getObjectSerialiser(), object2);
            }
        }
        catch (IOException e) {
            throw new SerialisationException(e.getMessage(), e);
        }
        return builder.toArray();
    }

    @Override
    public Set<? extends Object> deserialise(byte[] bytes) throws SerialisationException {
        Set set;
        if (null == this.getSetClass()) {
            set = new HashSet();
        } else {
            try {
                set = this.getSetClass().newInstance();
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException e) {
                throw new SerialisationException("Failed to create map instance" + e.getMessage(), e);
            }
        }
        int arrayLength = bytes.length;
        int carriage = 0;
        while (carriage < arrayLength) {
            LengthValueBytesSerialiserUtil.ObjectCarriage c = LengthValueBytesSerialiserUtil.deserialiseNextObject(this.getObjectSerialiser(), carriage, bytes);
            set.add(c.getObject());
            carriage = c.getCarriage();
        }
        return set;
    }

    @Override
    public Set<? extends Object> deserialiseEmpty() throws SerialisationException {
        Set set;
        if (null == this.getSetClass()) {
            set = new HashSet();
        } else {
            try {
                set = this.getSetClass().newInstance();
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException e) {
                throw new SerialisationException("Failed to create map instance" + e.getMessage(), e);
            }
        }
        return set;
    }

    @Override
    public boolean preservesObjectOrdering() {
        return false;
    }

    @Override
    public boolean isConsistent() {
        return false;
    }

    @Override
    public byte[] serialiseNull() {
        return new byte[0];
    }

    @JsonIgnore
    public ToBytesSerialiser getObjectSerialiser() {
        return this.objectSerialiser;
    }

    @JsonIgnore
    public void setObjectSerialiser(ToBytesSerialiser objectSerialiser) {
        this.objectSerialiser = objectSerialiser;
    }

    @JsonGetter(value="objectSerialiser")
    public String getObjectSerialiserClassString() {
        return null != this.objectSerialiser ? SimpleClassNameIdResolver.getSimpleClassName(this.objectSerialiser.getClass()) : null;
    }

    @JsonSetter(value="objectSerialiser")
    public void setObjectSerialiserClassString(String classType) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.objectSerialiser = null != classType ? Class.forName(SimpleClassNameIdResolver.getClassName((String)classType)).asSubclass(ToBytesSerialiser.class).newInstance() : null;
    }

    @JsonGetter(value="setClass")
    public String getSetClassString() {
        return null != this.setClass ? SimpleClassNameIdResolver.getSimpleClassName(this.setClass) : null;
    }

    @JsonSetter(value="setClass")
    public void setSetClassString(String classType) throws ClassNotFoundException {
        this.setClass = null != classType ? Class.forName(SimpleClassNameIdResolver.getClassName((String)classType)).asSubclass(Set.class) : null;
    }

    @JsonIgnore
    public Class<? extends Set> getSetClass() {
        return this.setClass;
    }

    @JsonIgnore
    public void setSetClass(Class<? extends Set> setClass) {
        this.setClass = setClass;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || this.getClass() != obj.getClass()) {
            return false;
        }
        SetSerialiser serialiser = (SetSerialiser)obj;
        return new EqualsBuilder().append((Object)this.objectSerialiser, (Object)serialiser.objectSerialiser).append(this.setClass, serialiser.setClass).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.objectSerialiser).append(this.setClass).toHashCode();
    }
}

