/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.implementation.ordered;

import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialiser;
import uk.gov.gchq.gaffer.serialisation.implementation.ordered.OrderedLongSerialiser;

public class OrderedDoubleSerialiser
implements ToBytesSerialiser<Double> {
    private static final long serialVersionUID = -4750738170126596560L;
    private static final OrderedLongSerialiser LONG_SERIALISER = new OrderedLongSerialiser();

    @Override
    public byte[] serialise(Double object) {
        long l = Double.doubleToRawLongBits(object);
        l = l < 0L ? (l ^= 0xFFFFFFFFFFFFFFFFL) : (l ^= Long.MIN_VALUE);
        return LONG_SERIALISER.serialise(l);
    }

    @Override
    public Double deserialise(byte[] bytes) throws SerialisationException {
        long l = LONG_SERIALISER.deserialise(bytes);
        l = l < 0L ? (l ^= Long.MIN_VALUE) : (l ^= 0xFFFFFFFFFFFFFFFFL);
        return Double.longBitsToDouble(l);
    }

    @Override
    public Double deserialiseEmpty() {
        return null;
    }

    @Override
    public boolean preservesObjectOrdering() {
        return true;
    }

    @Override
    public boolean isConsistent() {
        return true;
    }

    @Override
    public boolean canHandle(Class clazz) {
        return Double.class.equals((Object)clazz);
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass();
    }

    public int hashCode() {
        return OrderedDoubleSerialiser.class.getName().hashCode();
    }
}

