/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.implementation.raw;

import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialiser;
import uk.gov.gchq.gaffer.serialisation.implementation.raw.CompactRawSerialisationUtils;

public class CompactRawIntegerSerialiser
implements ToBytesSerialiser<Integer> {
    private static final long serialVersionUID = -2874472098583724627L;

    @Override
    public boolean canHandle(Class clazz) {
        return Integer.class.equals((Object)clazz);
    }

    @Override
    public byte[] serialise(Integer i) throws SerialisationException {
        return CompactRawSerialisationUtils.writeLong(i.intValue());
    }

    @Override
    public Integer deserialise(byte[] allBytes, int offset, int length) throws SerialisationException {
        long result = CompactRawSerialisationUtils.readLong(allBytes, offset);
        if (result > Integer.MAX_VALUE || result < Integer.MIN_VALUE) {
            throw new SerialisationException("Value too long to fit in integer");
        }
        return (int)result;
    }

    @Override
    public Integer deserialise(byte[] bytes) throws SerialisationException {
        return this.deserialise(bytes, 0, bytes.length);
    }

    @Override
    public Integer deserialiseEmpty() {
        return null;
    }

    @Override
    public boolean preservesObjectOrdering() {
        return false;
    }

    @Override
    public boolean isConsistent() {
        return true;
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass();
    }

    public int hashCode() {
        return CompactRawIntegerSerialiser.class.getName().hashCode();
    }
}

