/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2;

import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.xml.namespace.QName;
import org.apache.axis2.fault.FaultCode;
import org.apache.axis2.fault.FaultReasonList;
import org.apache.axis2.om.OMElement;
import org.apache.axis2.soap.SOAPFault;
import org.apache.axis2.soap.SOAPFaultCode;
import org.apache.axis2.soap.SOAPHeader;

public class AxisFault
extends RemoteException {
    private static final long serialVersionUID = -374933082062124907L;
    private FaultCode faultCode = new FaultCode();
    private FaultReasonList reasons = new FaultReasonList();
    private List headers = new ArrayList(0);
    private OMElement detail;
    private String nodeURI;
    private SOAPFault soapFault;

    public AxisFault(SOAPFault fault) {
        this.soapFault = fault;
        this.init(this.soapFault);
    }

    public AxisFault(String message) {
        super(message);
        this.addReason(message);
    }

    public AxisFault(Throwable cause) {
        this(cause != null ? cause.getMessage() : null, cause);
    }

    public AxisFault(String messageText, String faultCode) {
        this(messageText);
        this.setFaultCode(faultCode);
    }

    public AxisFault(String message, Throwable cause) {
        super(message, cause);
        if (message != null) {
            this.addReason(message);
        }
    }

    public AxisFault(String messageText, QName faultCode, Throwable cause) {
        this(messageText, cause);
        this.setFaultCode(faultCode);
    }

    public AxisFault(String messageText, String faultCode, Throwable cause) {
        this(messageText, cause);
        this.setFaultCode(faultCode);
    }

    public void addHeader(SOAPHeader header) {
        this.headers.add(header);
    }

    public void addReason(String text) {
        this.addReason(text, "");
    }

    public void addReason(String text, String language) {
        this.reasons.add(text, language);
    }

    public ListIterator headerIterator() {
        return this.headers.listIterator();
    }

    public List headers() {
        return this.headers;
    }

    private void init(SOAPFault fault) {
        SOAPFaultCode faultcodesource = fault.getCode();
        this.faultCode = new FaultCode(faultcodesource);
        this.detail = fault.getDetail();
        fault.getNode();
    }

    public static AxisFault makeFault(Exception e) {
        Throwable t;
        if (e instanceof InvocationTargetException && (t = ((InvocationTargetException)e).getTargetException()) instanceof Exception) {
            e = (Exception)t;
        }
        if (e instanceof AxisFault) {
            return (AxisFault)e;
        }
        return new AxisFault(e);
    }

    public OMElement getDetail() {
        return this.detail;
    }

    public String getFaultCode() {
        return this.faultCode.getValueString();
    }

    public String getNodeURI() {
        return this.nodeURI;
    }

    public void setDetail(OMElement detail) {
        this.detail = detail;
    }

    public void setFaultCode(QName soapFaultCode) {
        this.faultCode.setValue(soapFaultCode);
    }

    public void setFaultCode(String soapFaultCode) {
        this.faultCode.setValueString(soapFaultCode);
    }

    public void setNodeURI(String nodeURI) {
        this.nodeURI = nodeURI;
    }
}

