/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.addressing;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis2.om.OMAbstractFactory;
import org.apache.axis2.om.OMElement;

public class EndpointReference
implements Serializable {
    private static final long serialVersionUID = 5278892171162372439L;
    private String address;
    private OMElement metaData;
    private OMElement policy;
    private QName portType;
    private Map referenceParameters;
    private Map referenceProperties;

    public EndpointReference(String address) {
        this.address = address;
    }

    public void addReferenceParameter(OMElement omElement) {
        if (omElement == null) {
            return;
        }
        if (this.referenceParameters == null) {
            this.referenceParameters = new HashMap();
        }
        this.referenceParameters.put(omElement.getQName(), omElement);
    }

    public void addReferenceParameter(QName qname, String value) {
        if (qname == null) {
            return;
        }
        OMElement omElement = OMAbstractFactory.getOMFactory().createOMElement(qname, null);
        omElement.setText(value);
        this.addReferenceParameter(omElement);
    }

    public void addReferenceProperty(OMElement omElement) {
        if (omElement == null) {
            return;
        }
        if (this.referenceProperties == null) {
            this.referenceProperties = new HashMap();
        }
        this.referenceProperties.put(omElement.getQName(), omElement);
    }

    public void addReferenceProperty(QName qname, String value) {
        if (qname == null) {
            return;
        }
        OMElement omElement = OMAbstractFactory.getOMFactory().createOMElement(qname, null);
        omElement.setText(value);
        this.addReferenceProperty(omElement);
    }

    public String getAddress() {
        return this.address;
    }

    public Map getAllReferenceParameters() {
        return this.referenceParameters;
    }

    public Map getAllReferenceProperties() {
        return this.referenceProperties;
    }

    public OMElement getMetaData() {
        return this.metaData;
    }

    public OMElement getPolicy() {
        return this.policy;
    }

    public QName getPortType() {
        return this.portType;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setMetaData(OMElement metaData) {
        this.metaData = metaData;
    }

    public void setPolicy(OMElement policy) {
        this.policy = policy;
    }

    public void setPortType(QName portType) {
        this.portType = portType;
    }

    public void setReferenceParameters(Map referenceParameters) {
        this.referenceParameters = referenceParameters;
    }

    public void setReferenceProperties(HashMap referenceProperties) {
        this.referenceProperties = referenceProperties;
    }
}

