/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.attachments;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.HashMap;
import javax.activation.DataHandler;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import org.apache.axis2.attachments.MIMEBodyPartInputStream;
import org.apache.axis2.attachments.Part;
import org.apache.axis2.attachments.PartOnFile;
import org.apache.axis2.attachments.PartOnMemory;
import org.apache.axis2.attachments.PushbackFilePartInputStream;
import org.apache.axis2.om.OMException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MIMEHelper {
    ContentType contentType;
    byte[] boundary;
    String applicationType;
    PushbackInputStream pushbackInStream;
    HashMap bodyPartsMap;
    int partIndex = 0;
    boolean endOfStreamReached;
    String firstPartId;
    boolean fileCacheEnable;
    String attachmentRepoDir;
    int fileStorageThreshold;
    protected Log log = LogFactory.getLog(this.getClass());

    public MIMEHelper(InputStream inStream, String contentTypeString, boolean fileCacheEnable, String attachmentRepoDir, String fileThreshold) throws OMException {
        this.attachmentRepoDir = attachmentRepoDir;
        this.fileCacheEnable = fileCacheEnable;
        this.fileStorageThreshold = fileThreshold != null && !"".equals(fileThreshold) ? Integer.parseInt(fileThreshold) : 1;
        this.bodyPartsMap = new HashMap();
        try {
            this.contentType = new ContentType(contentTypeString);
        }
        catch (ParseException e) {
            throw new OMException("Invalid Content Type Field in the Mime Message", e);
        }
        this.boundary = ("--" + this.contentType.getParameter("boundary")).getBytes();
        this.pushbackInStream = new PushbackInputStream(inStream, this.boundary.length + 2);
        try {
            block7: {
                while (true) {
                    int value;
                    if ((byte)(value = this.pushbackInStream.read()) == this.boundary[0]) {
                        int boundaryIndex;
                        for (boundaryIndex = 0; boundaryIndex < this.boundary.length && (byte)value == this.boundary[boundaryIndex]; ++boundaryIndex) {
                            value = this.pushbackInStream.read();
                            if (value != -1) continue;
                            throw new OMException("Unexpected End of Stream while searching for first Mime Boundary");
                        }
                        if (boundaryIndex != this.boundary.length) continue;
                        break block7;
                    }
                    if ((byte)value == -1) break;
                }
                throw new OMException("Mime parts not found. Stream ended while searching for the boundary");
            }
            this.pushbackInStream.read();
        }
        catch (IOException e1) {
            throw new OMException("Stream Error" + e1.toString(), e1);
        }
    }

    public MIMEHelper(InputStream inStream, String contentTypeString) throws OMException {
        this(inStream, contentTypeString, false, null, null);
    }

    public String getAttachmentSpecType() {
        if (this.applicationType == null) {
            this.applicationType = this.contentType.getParameter("type");
            if ("application/xop+xml".equalsIgnoreCase(this.applicationType)) {
                this.applicationType = "application/xop+xml";
            } else if ("text/xml".equalsIgnoreCase(this.applicationType)) {
                this.applicationType = "text/xml";
            } else {
                throw new OMException("Invalid Application type. Support available for MTOM/SOAP 1.2 & SwA/SOAP 1.l only.");
            }
        }
        return this.applicationType;
    }

    public InputStream getSOAPPartInputStream() throws OMException {
        try {
            DataHandler dh = this.getDataHandler(this.getSOAPPartContentID());
            if (dh == null) {
                throw new OMException("Mandatory Root MIME part containing the SOAP Envelope is missing");
            }
            return dh.getInputStream();
        }
        catch (IOException e) {
            throw new OMException("Problem with DataHandler of the Root Mime Part. ", e);
        }
    }

    private String getSOAPPartContentID() {
        String rootContentID = this.contentType.getParameter("start");
        if (rootContentID == null) {
            if (this.partIndex == 0) {
                this.getNextPart();
            }
            rootContentID = this.firstPartId;
        } else {
            rootContentID.trim();
            if (rootContentID.indexOf("<") > -1 & rootContentID.indexOf(">") > -1) {
                rootContentID = rootContentID.substring(1, rootContentID.length() - 1);
            }
        }
        if ("cid".equalsIgnoreCase(rootContentID.substring(0, 3))) {
            rootContentID = rootContentID.substring(4);
        }
        return rootContentID;
    }

    public String getSOAPPartContentType() {
        Part soapPart = this.getPart(this.getSOAPPartContentID());
        try {
            return soapPart.getContentType();
        }
        catch (MessagingException e) {
            this.log.error((Object)e.getMessage());
            throw new OMException(e);
        }
    }

    public DataHandler getDataHandler(String blobContentID) throws OMException {
        try {
            return this.getPart(blobContentID).getDataHandler();
        }
        catch (MessagingException e) {
            throw new OMException("Problem with Mime Body Part No " + this.partIndex + ".  ", e);
        }
    }

    public Part getPart(String blobContentID) {
        Part bodyPart;
        if (this.bodyPartsMap.containsKey(blobContentID)) {
            Part bodyPart2 = (Part)this.bodyPartsMap.get(blobContentID);
            return bodyPart2;
        }
        do {
            if ((bodyPart = this.getNextPart()) != null) continue;
            return null;
        } while (!this.bodyPartsMap.containsKey(blobContentID));
        bodyPart = (Part)this.bodyPartsMap.get(blobContentID);
        return bodyPart;
    }

    protected void setEndOfStream(boolean value) {
        this.endOfStreamReached = value;
    }

    private Part getNextPart() throws OMException {
        Part nextPart = this.getPart();
        if (nextPart != null) {
            try {
                String partContentID = nextPart.getContentID();
                if (partContentID == null & this.partIndex == 1) {
                    this.bodyPartsMap.put("firstPart", nextPart);
                    this.firstPartId = "firstPart";
                    return nextPart;
                }
                if (partContentID == null) {
                    throw new OMException("Part content ID cannot be blank for non root MIME parts");
                }
                if (partContentID.indexOf("<") > -1 & partContentID.indexOf(">") > -1) {
                    partContentID = partContentID.substring(1, partContentID.length() - 1);
                } else if (this.partIndex == 1) {
                    this.firstPartId = partContentID;
                }
                if (this.bodyPartsMap.containsKey(partContentID)) {
                    throw new OMException("Two MIME parts with the same Content-ID not allowed.");
                }
                this.bodyPartsMap.put(partContentID, nextPart);
                return nextPart;
            }
            catch (MessagingException e) {
                throw new OMException("Error reading Content-ID from the Part." + (Object)((Object)e));
            }
        }
        return null;
    }

    private Part getPart() throws OMException {
        if (this.endOfStreamReached) {
            throw new OMException("Referenced MIME part not found.End of Stream reached.");
        }
        Part part = null;
        try {
            if (this.fileCacheEnable) {
                try {
                    int count;
                    byte[] buffer = new byte[this.fileStorageThreshold];
                    MIMEBodyPartInputStream partStream = new MIMEBodyPartInputStream(this.pushbackInStream, this.boundary, this);
                    for (count = 0; count != this.fileStorageThreshold && !partStream.getBoundaryStatus(); ++count) {
                        int value = partStream.read();
                        buffer[count] = (byte)value;
                    }
                    if (count == this.fileStorageThreshold) {
                        PushbackFilePartInputStream filePartStream = new PushbackFilePartInputStream(partStream, buffer);
                        part = new PartOnFile(filePartStream, this.attachmentRepoDir);
                    }
                    ByteArrayInputStream byteArrayInStream = new ByteArrayInputStream(buffer, 0, count - 1);
                    part = new PartOnMemory(byteArrayInStream);
                }
                catch (Exception e) {
                    throw new OMException("Error creating temporary File.", e);
                }
            } else {
                MIMEBodyPartInputStream partStream = new MIMEBodyPartInputStream(this.pushbackInStream, this.boundary, this);
                part = new PartOnMemory(partStream);
            }
            if (part.getSize() <= 0) {
                throw new OMException("Referenced MIME part not found.End of Stream reached.");
            }
        }
        catch (MessagingException e) {
            throw new OMException(e);
        }
        ++this.partIndex;
        return part;
    }
}

