/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.attachments;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.MessagingException;
import org.apache.axis2.attachments.Part;
import org.apache.axis2.attachments.PushbackFilePartInputStream;
import org.apache.axis2.om.OMException;

public class PartOnFile
implements Part {
    File cacheFile;
    Part bodyPart;
    String contentType;
    String contentID;
    HashMap headers = new HashMap();

    public PartOnFile(PushbackFilePartInputStream inStream, String repoDir) {
        if (repoDir == null) {
            repoDir = ".";
        }
        try {
            this.cacheFile = File.createTempFile("Axis2", ".att", repoDir == null ? null : new File(repoDir));
            FileOutputStream fileOutStream = new FileOutputStream(this.cacheFile);
            int value = this.parseTheHeaders(inStream);
            fileOutStream.write(value);
            while (!inStream.getBoundaryStatus()) {
                value = inStream.read();
                if (inStream.getBoundaryStatus()) continue;
                fileOutStream.write(value);
            }
            fileOutStream.flush();
            fileOutStream.close();
        }
        catch (IOException e) {
            throw new OMException("Error creating temporary File.", e);
        }
    }

    private int parseTheHeaders(InputStream inStream) throws IOException {
        int value;
        boolean readingHeaders = true;
        StringBuffer header = new StringBuffer();
        while (readingHeaders & (value = inStream.read()) != -1) {
            if (value == 13) {
                value = inStream.read();
                if (value == 10) {
                    value = inStream.read();
                    if (value == 13) {
                        value = inStream.read();
                        if (value != 10) continue;
                        this.putToMap(header);
                        readingHeaders = false;
                        continue;
                    }
                    this.putToMap(header);
                    header = new StringBuffer();
                    header.append((char)value);
                    continue;
                }
                header.append(13);
                header.append(value);
                continue;
            }
            header.append((char)value);
        }
        return value;
    }

    private void putToMap(StringBuffer header) {
        String headerString = header.toString();
        int delimiter = headerString.indexOf(":");
        this.headers.put(headerString.substring(0, delimiter).trim(), headerString.substring(delimiter + 1, headerString.length()).trim());
    }

    public String getContentID() {
        String cID = (String)this.headers.get("Content-ID");
        if (cID == null && (cID = (String)this.headers.get("Content-Id")) == null && (cID = (String)this.headers.get("Content-id")) == null) {
            cID = (String)this.headers.get("content-id");
        }
        return cID;
    }

    public int getSize() throws MessagingException {
        return (int)this.cacheFile.length();
    }

    public int getLineCount() throws MessagingException {
        throw new UnsupportedOperationException();
    }

    public String getDescription() throws MessagingException {
        throw new UnsupportedOperationException();
    }

    public void setDescription(String arg0) throws MessagingException {
        throw new UnsupportedOperationException();
    }

    public String getFileName() throws MessagingException {
        return this.cacheFile.getAbsolutePath();
    }

    public InputStream getInputStream() throws IOException, MessagingException {
        return new FileInputStream(this.cacheFile);
    }

    public DataHandler getDataHandler() throws MessagingException {
        return new DataHandler((DataSource)new FileDataSource(this.cacheFile));
    }

    public Object getContent() throws IOException, MessagingException {
        return this.getDataHandler().getContent();
    }

    public void writeTo(OutputStream outStream) throws IOException, MessagingException {
        this.getDataHandler().writeTo(outStream);
    }

    public String getHeader(String arg0) throws MessagingException {
        String header = (String)this.headers.get(arg0);
        return header;
    }

    public Enumeration getAllHeaders() throws MessagingException {
        return null;
    }

    public String getContentType() throws MessagingException {
        String cType = (String)this.headers.get("Content-Type");
        if (cType == null && (cType = (String)this.headers.get("Content-type")) == null) {
            cType = (String)this.headers.get("content-type");
        }
        return cType;
    }
}

