/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.client;

import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.ListenerManager;
import org.apache.axis2.client.MEPClient;
import org.apache.axis2.client.async.AsyncResult;
import org.apache.axis2.client.async.Callback;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.om.OMException;
import org.apache.axis2.soap.SOAPBody;
import org.apache.axis2.soap.SOAPEnvelope;
import org.apache.axis2.soap.SOAPFault;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.util.CallbackReceiver;
import org.apache.axis2.util.UUIDGenerator;

public class InOutMEPClient
extends MEPClient {
    protected CallbackReceiver callbackReceiver = new CallbackReceiver();

    public InOutMEPClient(ServiceContext serviceContext) {
        super(serviceContext, "http://www.w3.org/2004/08/wsdl/out-in");
    }

    private void checkTransport(MessageContext msgctx) throws AxisFault {
        if (this.clientOptions.getTranportOut() == null) {
            this.clientOptions.setTranportOut(this.inferTransport(msgctx.getTo()));
        }
        if (this.clientOptions.isUseSeparateListener() && this.clientOptions.getTransportIn() == null) {
            this.clientOptions.setTransportIn(this.serviceContext.getConfigurationContext().getAxisConfiguration().getTransportIn(this.clientOptions.getTranportOut().getName()));
        }
        if (msgctx.getTransportIn() == null) {
            msgctx.setTransportIn(this.clientOptions.getTransportIn());
        }
        if (msgctx.getTransportOut() == null) {
            msgctx.setTransportOut(this.clientOptions.getTranportOut());
        }
    }

    public void close() throws AxisFault {
        if (this.clientOptions.isUseSeparateListener()) {
            ListenerManager.stop(this.serviceContext.getConfigurationContext(), this.clientOptions.getTransportIn().getName().getLocalPart());
        }
    }

    protected void configureTransportInformation(MessageContext msgCtx) throws AxisFault {
        AxisConfiguration axisConfig = this.serviceContext.getConfigurationContext().getAxisConfiguration();
        String listenerTransportProtocol = this.clientOptions.getTransportInProtocol();
        if (axisConfig != null) {
            if (this.clientOptions.isUseSeparateListener() && listenerTransportProtocol != null && !"".equals(listenerTransportProtocol)) {
                TransportInDescription transportIn = axisConfig.getTransportIn(new QName(listenerTransportProtocol));
                if (transportIn == null) {
                    throw new AxisFault(Messages.getMessage("unknownTransport", listenerTransportProtocol));
                }
                this.clientOptions.setTransportIn(transportIn);
            }
            this.inferTransportOutDescription(msgCtx);
        }
        if (this.clientOptions.isUseSeparateListener()) {
            if (!this.serviceContext.getConfigurationContext().getAxisConfiguration().isEngaged(new QName("addressing"))) {
                throw new AxisFault(Messages.getMessage("2channelNeedAddressing"));
            }
            ListenerManager.makeSureStarted(this.clientOptions.getTransportInProtocol(), this.serviceContext.getConfigurationContext());
        }
    }

    public MessageContext invokeBlocking(AxisOperation axisop, MessageContext msgctx) throws AxisFault {
        String messageID = String.valueOf("uuid:" + UUIDGenerator.getUUID());
        msgctx.setMessageID(messageID);
        if (this.clientOptions.isUseSeparateListener()) {
            SyncCallBack callback = new SyncCallBack();
            this.invokeNonBlocking(axisop, msgctx, callback);
            long timeout = this.clientOptions.getTimeOutInMilliSeconds();
            if (timeout < 0L) {
                while (!callback.isComplete()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        throw new AxisFault(e);
                    }
                }
            } else {
                long index = timeout / 100L;
                while (!callback.isComplete()) {
                    if (index-- >= 0L) {
                        try {
                            Thread.sleep(100L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            throw new AxisFault(e);
                        }
                    }
                    throw new AxisFault(Messages.getMessage("responseTimeOut"));
                }
            }
            if (callback.envelope != null) {
                MessageContext resMsgctx = new MessageContext();
                resMsgctx.setConfigurationContext(this.serviceContext.getConfigurationContext());
                resMsgctx.setEnvelope(callback.envelope);
                return resMsgctx;
            }
            if (callback.error instanceof AxisFault) {
                throw (AxisFault)callback.error;
            }
            throw new AxisFault(callback.error);
        }
        msgctx.setServiceContext(this.serviceContext);
        this.prepareInvocation(axisop, msgctx);
        ConfigurationContext syscontext = this.serviceContext.getConfigurationContext();
        msgctx.setConfigurationContext(syscontext);
        this.checkTransport(msgctx);
        OperationContext operationContext = new OperationContext(axisop, this.serviceContext);
        axisop.registerOperationContext(msgctx, operationContext);
        operationContext.setProperties(this.clientOptions.getProperties());
        MessageContext response = this.send(msgctx, this.clientOptions.getTransportIn());
        SOAPEnvelope resenvelope = response.getEnvelope();
        if (resenvelope.getBody().hasFault()) {
            SOAPFault soapFault = resenvelope.getBody().getFault();
            Exception ex = soapFault.getException();
            if (this.clientOptions.isExceptionToBeThrownOnSOAPFault()) {
                if (ex != null) {
                    throw new AxisFault(ex);
                }
                String message = "";
                String string = message + "Code =" + soapFault.getCode() == null ? "" : (message = soapFault.getCode().getValue() == null ? "" : soapFault.getCode().getValue().getText());
                message = message + "Reason =" + soapFault.getReason() == null ? "" : (soapFault.getReason().getSOAPText() == null ? "" : soapFault.getReason().getSOAPText().getText());
                throw new AxisFault(message);
            }
        }
        return response;
    }

    public void invokeNonBlocking(AxisOperation axisop, MessageContext msgctx, Callback callback) throws AxisFault {
        this.prepareInvocation(axisop, msgctx);
        try {
            ConfigurationContext syscontext = this.serviceContext.getConfigurationContext();
            AxisEngine engine = new AxisEngine(syscontext);
            this.checkTransport(msgctx);
            String messageID = String.valueOf("uuid:" + UUIDGenerator.getUUID());
            msgctx.setMessageID(messageID);
            if (this.clientOptions.isUseSeparateListener()) {
                axisop.setMessageReceiver(this.callbackReceiver);
                this.callbackReceiver.addCallback(messageID, callback);
                EndpointReference replyToFromTransport = ListenerManager.replyToEPR(this.serviceContext.getConfigurationContext(), this.serviceContext.getAxisService().getName() + "/" + axisop.getName().getLocalPart(), this.clientOptions.getTransportIn().getName().getLocalPart());
                if (msgctx.getReplyTo() == null) {
                    msgctx.setReplyTo(replyToFromTransport);
                } else {
                    msgctx.getReplyTo().setAddress(replyToFromTransport.getAddress());
                }
                msgctx.setOperationContext(axisop.findOperationContext(msgctx, this.serviceContext));
                msgctx.setServiceContext(this.serviceContext);
                msgctx.getOperationContext().setProperties(this.clientOptions.getProperties());
                engine.send(msgctx);
            } else {
                OperationContext opcontxt = new OperationContext(axisop, this.serviceContext);
                msgctx.setOperationContext(opcontxt);
                msgctx.setServiceContext(this.serviceContext);
                opcontxt.setProperties(this.clientOptions.getProperties());
                this.serviceContext.getConfigurationContext().getThreadPool().execute(new NonBlockingInvocationWorker(callback, axisop, msgctx));
            }
        }
        catch (OMException e) {
            throw new AxisFault(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new AxisFault(e.getMessage(), e);
        }
    }

    public MessageContext send(MessageContext msgctx, TransportInDescription transportIn) throws AxisFault {
        AxisEngine engine = new AxisEngine(msgctx.getConfigurationContext());
        engine.send(msgctx);
        MessageContext responseMessageContext = new MessageContext();
        responseMessageContext.setConfigurationContext(msgctx.getConfigurationContext());
        responseMessageContext.setSessionContext(msgctx.getSessionContext());
        responseMessageContext.setTransportIn(msgctx.getTransportIn());
        responseMessageContext.setTransportOut(msgctx.getTransportOut());
        responseMessageContext.setProperty("TRANSPORT_IN", msgctx.getProperty("TRANSPORT_IN"));
        msgctx.getAxisOperation().registerOperationContext(responseMessageContext, msgctx.getOperationContext());
        responseMessageContext.setServerSide(false);
        responseMessageContext.setServiceContext(msgctx.getServiceContext());
        responseMessageContext.setServiceGroupContext(msgctx.getServiceGroupContext());
        responseMessageContext.setDoingREST(msgctx.isDoingREST());
        SOAPEnvelope resenvelope = TransportUtils.createSOAPMessage(responseMessageContext, msgctx.getEnvelope().getNamespace().getName());
        if (resenvelope == null) {
            throw new AxisFault(Messages.getMessage("blockingInvocationExpectsResponse"));
        }
        responseMessageContext.setEnvelope(resenvelope);
        engine = new AxisEngine(msgctx.getConfigurationContext());
        engine.receive(responseMessageContext);
        return responseMessageContext;
    }

    public class SyncCallBack
    extends Callback {
        private SOAPEnvelope envelope;
        private Exception error;

        public void onComplete(AsyncResult result) {
            this.envelope = result.getResponseEnvelope();
        }

        public void onError(Exception e) {
            this.error = e;
        }
    }

    private class NonBlockingInvocationWorker
    implements Runnable {
        private Callback callback;
        private MessageContext msgctx;

        public NonBlockingInvocationWorker(Callback callback, AxisOperation axisop, MessageContext msgctx) {
            this.callback = callback;
            this.msgctx = msgctx;
        }

        public void run() {
            try {
                MessageContext response = InOutMEPClient.this.send(this.msgctx, InOutMEPClient.this.clientOptions.getTransportIn());
                SOAPEnvelope resenvelope = response.getEnvelope();
                SOAPBody body = resenvelope.getBody();
                if (body.hasFault()) {
                    Exception ex = body.getFault().getException();
                    if (ex != null) {
                        this.callback.onError(ex);
                    } else {
                        this.callback.onError(new Exception(body.getFault().getReason().getText()));
                    }
                } else {
                    AsyncResult asyncResult = new AsyncResult(response);
                    this.callback.onComplete(asyncResult);
                }
                this.callback.setComplete(true);
            }
            catch (Exception e) {
                this.callback.onError(e);
            }
        }
    }
}

