/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.client;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.TransportListener;

public class ListenerManager {
    public static Map configurationContextMap = new HashMap();

    public static synchronized void makeSureStarted(String transport, ConfigurationContext configurationContext) throws AxisFault {
        HashMap<String, TransportListenerState> listeners = (HashMap<String, TransportListenerState>)configurationContextMap.get(configurationContext);
        if (listeners == null) {
            listeners = new HashMap<String, TransportListenerState>();
            configurationContextMap.put(configurationContext, listeners);
        } else {
            TransportListenerState tsState = (TransportListenerState)listeners.get(transport);
            if (tsState != null) {
                ++tsState.waitingCalls;
                return;
            }
        }
        TransportInDescription tranportIn = configurationContext.getAxisConfiguration().getTransportIn(new QName(transport));
        TransportListener listener = tranportIn.getReceiver();
        listener.start();
        TransportListenerState tsState = new TransportListenerState(listener);
        listeners.put(transport, tsState);
        ++tsState.waitingCalls;
    }

    public static ServerSocket openSocket(int port) throws AxisFault {
        for (int i = 0; i < 5; ++i) {
            try {
                return new ServerSocket(port + i);
            }
            catch (IOException iOException) {
                continue;
            }
        }
        throw new AxisFault(Messages.getMessage("failedToOpenSocket"));
    }

    public static EndpointReference replyToEPR(ConfigurationContext configurationContext, String serviceName, String transport) throws AxisFault {
        HashMap listeners = (HashMap)configurationContextMap.get(configurationContext);
        if (listeners != null) {
            TransportListenerState tsState = (TransportListenerState)listeners.get(transport);
            if (tsState != null) {
                return tsState.listener.getReplyToEPR(serviceName);
            }
            throw new AxisFault(Messages.getMessage("replyNeedStarting", transport));
        }
        throw new AxisFault("Can not find listeners for " + transport + " for the given config" + " context " + configurationContext + ". So can not provide a replyTo epr here. ");
    }

    public static synchronized void stop(ConfigurationContext configurationContext, String transport) throws AxisFault {
        TransportListenerState tsState;
        HashMap listeners = (HashMap)configurationContextMap.get(configurationContext);
        if (listeners != null && (tsState = (TransportListenerState)listeners.get(transport)) != null) {
            --tsState.waitingCalls;
            if (tsState.waitingCalls == 0) {
                tsState.listener.stop();
                listeners.remove(transport);
            }
        }
    }

    public static class TransportListenerState {
        public int waitingCalls = 0;
        public TransportListener listener;

        public TransportListenerState(TransportListener listener) {
            this.listener = listener;
        }
    }
}

