/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.client;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.om.OMAbstractFactory;
import org.apache.axis2.om.OMElement;
import org.apache.axis2.soap.SOAPEnvelope;
import org.apache.axis2.soap.SOAPFactory;
import org.apache.axis2.soap.SOAPHeader;
import org.apache.axis2.util.UUIDGenerator;

public abstract class MEPClient {
    private static final String ANONYMOUS_SERVICE = "AnonymousService";
    protected Options clientOptions;
    protected final String mep;
    ServiceContext serviceContext;
    private List soapHeaderList;

    public MEPClient(ServiceContext service, String mep) {
        this.serviceContext = service;
        this.mep = mep;
    }

    public void addSOAPHeader(OMElement soapHeaderBlock) {
        if (soapHeaderBlock == null) {
            return;
        }
        if (this.soapHeaderList == null) {
            this.soapHeaderList = new ArrayList();
        }
        this.soapHeaderList.add(soapHeaderBlock);
    }

    public void addSOAPHeader(QName soapHeaderQName, String soapHeaderText) {
        OMElement omElement = OMAbstractFactory.getOMFactory().createOMElement(soapHeaderQName, null);
        omElement.setText(soapHeaderText);
        if (this.soapHeaderList == null) {
            this.soapHeaderList = new ArrayList();
        }
        this.soapHeaderList.add(omElement);
    }

    protected void addUserAddedSOAPHeaders(MessageContext msgCtx, Options options) {
        if (this.soapHeaderList != null && this.soapHeaderList.size() > 0 && msgCtx.getEnvelope() != null) {
            SOAPHeader header = msgCtx.getEnvelope().getHeader();
            if (header == null) {
                SOAPFactory soapFactory = this.getCorrectSOAPFactory(msgCtx);
                header = soapFactory.createSOAPHeader(msgCtx.getEnvelope());
            }
            if (!header.isComplete()) {
                header.build();
            }
            for (int i = 0; i < this.soapHeaderList.size(); ++i) {
                OMElement headerBlock = (OMElement)this.soapHeaderList.get(i);
                header.addChild(headerBlock);
            }
        }
    }

    protected void assumeServiceContext(String clientHome) throws AxisFault {
        ConfigurationContext configurationContext = new ConfigurationContextFactory().createConfigurationContextFromFileSystem(clientHome);
        AxisService axisService = configurationContext.getAxisConfiguration().getService(ANONYMOUS_SERVICE);
        if (axisService == null) {
            axisService = new AxisService(ANONYMOUS_SERVICE);
        }
        configurationContext.getAxisConfiguration().addService(axisService);
        this.serviceContext = new ServiceGroupContext(configurationContext, axisService.getParent()).getServiceContext(axisService);
    }

    protected abstract void configureTransportInformation(MessageContext var1) throws AxisFault;

    protected SOAPEnvelope createDefaultSOAPEnvelope() throws AxisFault {
        if (this.clientOptions == null) {
            throw new AxisFault("Can not proceed without options being set for invocation. Set theproperties for this invocation via MEPClient.setOptions(Options) first.");
        }
        String soapVersionURI = this.clientOptions.getSoapVersionURI();
        String soapFactory = (String)this.clientOptions.getProperty("soap.factory");
        if ("http://www.w3.org/2003/05/soap-envelope".equals(soapVersionURI)) {
            String factory = (String)this.clientOptions.getProperty("soap12.factory");
            if (factory != null) {
                return OMAbstractFactory.getSOAPFactory(soapFactory).getDefaultEnvelope();
            }
            return OMAbstractFactory.getSOAP12Factory().getDefaultEnvelope();
        }
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(soapVersionURI)) {
            String factory = (String)this.clientOptions.getProperty("soap11.factory");
            if (factory != null) {
                return OMAbstractFactory.getSOAPFactory(soapFactory).getDefaultEnvelope();
            }
            return OMAbstractFactory.getSOAP11Factory().getDefaultEnvelope();
        }
        if ("".equals(soapVersionURI) || soapVersionURI == null) {
            return OMAbstractFactory.getSOAP11Factory().getDefaultEnvelope();
        }
        throw new AxisFault(Messages.getMessage("invaidSOAPversion"));
    }

    public void engageModule(QName name) throws AxisFault {
        AxisConfiguration axisConf = this.serviceContext.getConfigurationContext().getAxisConfiguration();
        if (!axisConf.isEngaged(name)) {
            axisConf.engageModule(name);
        }
    }

    protected TransportOutDescription inferTransport(EndpointReference epr) throws AxisFault {
        if (epr != null) {
            return this.inferTransport(epr.getAddress());
        }
        throw new AxisFault(Messages.getMessage("cannotInferTransport"));
    }

    protected TransportOutDescription inferTransport(String uri) throws AxisFault {
        int index;
        String transport = null;
        if (uri != null && (index = uri.indexOf(58)) > 0) {
            transport = uri.substring(0, index);
        }
        if (transport != null) {
            return this.serviceContext.getConfigurationContext().getAxisConfiguration().getTransportOut(new QName(transport));
        }
        throw new AxisFault(Messages.getMessage("cannotInferTransport"));
    }

    protected void inferTransportOutDescription(MessageContext msgCtx) throws AxisFault {
        if (this.clientOptions.getTranportOut() == null) {
            AxisConfiguration axisConfig = this.serviceContext.getConfigurationContext().getAxisConfiguration();
            String senderTrasportProtocol = this.clientOptions.getSenderTransportProtocol();
            if (axisConfig != null) {
                if (senderTrasportProtocol == null || "".equals(senderTrasportProtocol)) {
                    this.clientOptions.setTranportOut(this.inferTransport(msgCtx.getTo()));
                } else {
                    this.clientOptions.setTranportOut(axisConfig.getTransportOut(new QName(senderTrasportProtocol)));
                }
            }
            if (this.clientOptions.getTranportOut() == null) {
                throw new AxisFault(Messages.getMessage("unknownTransport", senderTrasportProtocol));
            }
        }
    }

    protected void prepareInvocation(AxisOperation axisop, MessageContext msgCtx) throws AxisFault {
        String messageId;
        if (!(msgCtx != null && msgCtx.getTo() != null || this.clientOptions != null && this.clientOptions.getTo() != null)) {
            throw new AxisFault("Can not proceed without options being set for invocation. Set theproperties for this invocation via MEPClient.setOptions(Options) first.");
        }
        if (axisop == null) {
            throw new AxisFault(Messages.getMessage("cannotBeNullAxisOperation"));
        }
        if (this.mep.equals(axisop.getMessageExchangePattern())) {
            throw new AxisFault(Messages.getMessage("mepClientSupportOnly", this.mep, axisop.getMessageExchangePattern()));
        }
        if (this.serviceContext.getAxisService().getOperation(axisop.getName()) == null) {
            this.serviceContext.getAxisService().addOperation(axisop);
        }
        if ((messageId = this.clientOptions.getMessageId()) == null || "".equals(messageId)) {
            this.clientOptions.setMessageId(UUIDGenerator.getUUID());
        }
        msgCtx.setOptions(this.clientOptions);
        this.addUserAddedSOAPHeaders(msgCtx, this.clientOptions);
        this.configureTransportInformation(msgCtx);
    }

    protected MessageContext prepareTheSOAPEnvelope(OMElement toSend) throws AxisFault {
        MessageContext msgctx = new MessageContext();
        msgctx.setConfigurationContext(this.serviceContext.getConfigurationContext());
        SOAPEnvelope envelope = this.createDefaultSOAPEnvelope();
        if (toSend != null) {
            envelope.getBody().addChild(toSend);
        }
        msgctx.setEnvelope(envelope);
        return msgctx;
    }

    public Options getClientOptions() {
        return this.clientOptions;
    }

    private SOAPFactory getCorrectSOAPFactory(MessageContext msgCtx) {
        String soapNSURI = msgCtx.getEnvelope().getNamespace().getName();
        if ("http://www.w3.org/2003/05/soap-envelope".equals(soapNSURI)) {
            return OMAbstractFactory.getSOAP11Factory();
        }
        return OMAbstractFactory.getSOAP12Factory();
    }

    public ServiceContext getServiceContext() {
        return this.serviceContext;
    }

    public void setClientOptions(Options clientOptions) {
        this.clientOptions = clientOptions;
    }

    public void setServiceContext(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }
}

