/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.client;

import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.InOnlyMEPClient;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.deployment.util.PhasesInfo;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.OutOnlyAxisOperation;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.om.OMElement;
import org.apache.axis2.soap.SOAPEnvelope;

public class MessageSender
extends InOnlyMEPClient {
    protected static AxisOperation axisOperationTemplate;

    public MessageSender() throws AxisFault {
        this((String)null);
    }

    public MessageSender(ServiceContext service) {
        super(service);
    }

    public MessageSender(String clientHome) throws AxisFault {
        super(null);
        this.assumeServiceContext(clientHome);
    }

    protected void assumeServiceContext(String clientHome) throws AxisFault {
        super.assumeServiceContext(clientHome);
        axisOperationTemplate = new OutOnlyAxisOperation(new QName("TemplateOperation"));
        AxisService axisService = this.serviceContext.getAxisService();
        AxisConfiguration axisConfiguration = this.serviceContext.getConfigurationContext().getAxisConfiguration();
        PhasesInfo info = axisConfiguration.getPhasesInfo();
        if (info != null) {
            info.setOperationPhases(axisOperationTemplate);
        }
        axisService.addOperation(axisOperationTemplate);
    }

    public void send(String opName, OMElement toSend) throws AxisFault {
        SOAPEnvelope envelope = this.createDefaultSOAPEnvelope();
        if (toSend != null) {
            envelope.getBody().addChild(toSend);
        }
        this.send(opName, envelope);
    }

    public void send(String opName, SOAPEnvelope soapEnvelope) throws AxisFault {
        if (soapEnvelope == null) {
            throw new AxisFault("Can not send null SOAP envelope");
        }
        AxisOperation axisOp = this.serviceContext.getAxisService().getOperation(new QName(opName));
        if (axisOp == null) {
            axisOp = new OutOnlyAxisOperation(new QName(opName));
            this.serviceContext.getAxisService().addOperation(axisOp);
            axisOp = AxisOperationFactory.getAxisOperation(10);
            axisOp.setName(new QName(opName));
            axisOp.setRemainingPhasesInFlow(axisOperationTemplate.getRemainingPhasesInFlow());
            axisOp.setPhasesOutFlow(axisOperationTemplate.getPhasesOutFlow());
            axisOp.setPhasesInFaultFlow(axisOperationTemplate.getPhasesInFaultFlow());
            axisOp.setPhasesOutFaultFlow(axisOperationTemplate.getPhasesOutFaultFlow());
            this.serviceContext.getAxisService().addOperation(axisOp);
        }
        MessageContext msgctx = new MessageContext();
        msgctx.setConfigurationContext(this.serviceContext.getConfigurationContext());
        msgctx.setEnvelope(soapEnvelope);
        super.send(axisOp, msgctx);
    }
}

