/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.client;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.ListenerManager;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.async.AsyncResult;
import org.apache.axis2.client.async.Callback;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.ClientUtils;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.axis2.description.OutOnlyAxisOperation;
import org.apache.axis2.description.RobustOutOnlyAxisOperation;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.om.OMAbstractFactory;
import org.apache.axis2.om.OMElement;
import org.apache.axis2.soap.SOAPEnvelope;
import org.apache.axis2.soap.SOAPFactory;
import org.apache.axis2.soap.SOAPHeader;
import org.apache.axis2.util.CallbackReceiver;

public class ServiceClient {
    public static final String ANON_SERVICE = "__ANONYMOUS_SERVICE__";
    public static final QName ANON_OUT_ONLY_OP = new QName("__OPERATION_OUT_ONLY__");
    public static final QName ANON_ROBUST_OUT_ONLY_OP = new QName("__OPERATION_ROBUST_OUT_ONLY__");
    public static final QName ANON_OUT_IN_OP = new QName("__OPERATION_OUT_IN__");
    AxisService axisService;
    AxisConfiguration axisConfig;
    ConfigurationContext configContext;
    ServiceContext serviceContext;
    Options options = new Options();
    ArrayList headers;
    private CallbackReceiver callbackReceiver;

    public ServiceClient(ConfigurationContext configContext, AxisService axisService) throws AxisFault {
        this.configContext = configContext != null ? configContext : new ConfigurationContextFactory().createConfigurationContextFromFileSystem(null);
        this.axisConfig = this.configContext.getAxisConfiguration();
        AxisService axisService2 = this.axisService = axisService != null ? axisService : this.createAnonymousService();
        if (this.axisConfig.getService(this.axisService.getName()) == null) {
            this.axisConfig.addService(this.axisService);
        }
        ServiceGroupContext sgc = new ServiceGroupContext(this.configContext, this.axisService.getParent());
        this.serviceContext = sgc.getServiceContext(this.axisService);
    }

    public ServiceClient(ConfigurationContext configContext, URL wsdlURL, QName wsdlServiceName, String portName) throws AxisFault {
        this.configContext = configContext != null ? configContext : new ConfigurationContextFactory().createConfigurationContextFromFileSystem(null);
        try {
            this.axisConfig = this.configContext.getAxisConfiguration();
            this.axisService = ClientUtils.creatAxisService(wsdlURL, wsdlServiceName, portName, this.options);
            if (this.axisConfig.getService(this.axisService.getName()) == null) {
                this.axisConfig.addService(this.axisService);
            }
            ServiceGroupContext sgc = new ServiceGroupContext(this.configContext, this.axisService.getParent());
            this.serviceContext = sgc.getServiceContext(this.axisService);
        }
        catch (IOException e) {
            throw new AxisFault(e);
        }
    }

    public ServiceClient() throws AxisFault {
        this(null, null);
    }

    private AxisService createAnonymousService() {
        AxisService axisService = new AxisService(ANON_SERVICE);
        RobustOutOnlyAxisOperation robustoutoonlyOperation = new RobustOutOnlyAxisOperation(ANON_ROBUST_OUT_ONLY_OP);
        axisService.addOperation(robustoutoonlyOperation);
        OutOnlyAxisOperation outOnlyOperation = new OutOnlyAxisOperation(ANON_OUT_ONLY_OP);
        axisService.addOperation(outOnlyOperation);
        OutInAxisOperation outInOperation = new OutInAxisOperation(ANON_OUT_IN_OP);
        axisService.addOperation(outInOperation);
        return axisService;
    }

    public AxisService getAxisService() {
        return this.axisService;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public Options getOptions() {
        return this.options;
    }

    public void engageModule(QName moduleName) throws AxisFault {
        this.axisService.engageModule(this.axisConfig.getModule(moduleName), this.axisConfig);
    }

    public void addHeader(OMElement header) {
        if (this.headers == null) {
            this.headers = new ArrayList();
        }
        this.headers.add(header);
    }

    public void addStringHeader(QName headerName, String headerText) {
        OMElement omElement = OMAbstractFactory.getOMFactory().createOMElement(headerName, null);
        omElement.setText(headerText);
        this.addHeader(omElement);
    }

    public void sendRobust(OMElement elem) throws AxisFault {
        this.sendRobust(ANON_ROBUST_OUT_ONLY_OP, elem);
    }

    public void sendRobust(QName operation, OMElement elem) throws AxisFault {
        throw new UnsupportedOperationException("ServiceClient.sendRobust is not yet implemented");
    }

    public void fireAndForget(OMElement elem) throws AxisFault {
        this.fireAndForget(ANON_OUT_ONLY_OP, elem);
    }

    public void fireAndForget(QName operation, OMElement elem) throws AxisFault {
        OperationClient mepClient = this.createClient(operation);
        MessageContext mc = new MessageContext();
        this.fillSoapEnvelope(mc, elem);
        mepClient.addMessageContext(mc);
        mepClient.execute(true);
    }

    public OMElement sendReceive(OMElement elem) throws AxisFault {
        return this.sendReceive(ANON_OUT_IN_OP, elem);
    }

    public OMElement sendReceive(QName operation, OMElement elem) throws AxisFault {
        if (this.options.isUseSeparateListener()) {
            SyncCallBack callback = new SyncCallBack();
            this.sendReceiveNonBlocking(operation, elem, callback);
            long timeout = this.options.getTimeOutInMilliSeconds();
            if (timeout < 0L) {
                while (!callback.isComplete()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        throw new AxisFault(e);
                    }
                }
            } else {
                long index = timeout / 100L;
                while (!callback.isComplete()) {
                    if (index-- >= 0L) {
                        try {
                            Thread.sleep(100L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            throw new AxisFault(e);
                        }
                    }
                    throw new AxisFault(Messages.getMessage("responseTimeOut"));
                }
            }
            if (callback.envelope != null) {
                MessageContext resMsgctx = callback.getMsgctx();
                callback.envelope.build();
                this.finalizeInvoke(resMsgctx);
                return callback.envelope.getBody().getFirstElement();
            }
            if (callback.error instanceof AxisFault) {
                throw (AxisFault)callback.error;
            }
            throw new AxisFault(callback.error);
        }
        MessageContext mc = new MessageContext();
        this.fillSoapEnvelope(mc, elem);
        OperationClient mepClient = this.createClient(operation);
        mepClient.addMessageContext(mc);
        mepClient.execute(true);
        MessageContext response = mepClient.getMessageContext("In");
        return response.getEnvelope().getBody().getFirstElement();
    }

    public void sendReceiveNonblocking(OMElement elem, Callback callback) throws AxisFault {
        this.sendReceiveNonBlocking(ANON_OUT_IN_OP, elem, callback);
    }

    public void sendReceiveNonBlocking(QName operation, OMElement elem, Callback callback) throws AxisFault {
        MessageContext mc = new MessageContext();
        this.fillSoapEnvelope(mc, elem);
        OperationClient mepClient = this.createClient(operation);
        mepClient.setCallback(callback);
        mepClient.addMessageContext(mc);
        if (this.options.isUseSeparateListener()) {
            if (this.callbackReceiver == null) {
                this.callbackReceiver = new CallbackReceiver();
            }
            this.axisService.getOperation(operation).setMessageReceiver(this.callbackReceiver);
        }
        mepClient.execute(false);
    }

    public OperationClient createClient(QName operation) throws AxisFault {
        AxisOperation axisOp = this.axisService.getOperation(operation);
        if (axisOp == null) {
            throw new AxisFault("Operation '" + operation + "' not found");
        }
        return axisOp.createClient(this.serviceContext, this.options);
    }

    private void finalizeInvoke(MessageContext msgCtx) throws AxisFault {
        if (this.options.getTransportInProtocol() != null) {
            ListenerManager.stop(msgCtx.getConfigurationContext(), msgCtx.getTransportIn().getName().getLocalPart());
        }
    }

    private SOAPFactory getSOAPFactory() {
        String soapVersionURI = this.options.getSoapVersionURI();
        if ("http://www.w3.org/2003/05/soap-envelope".equals(soapVersionURI)) {
            return OMAbstractFactory.getSOAP12Factory();
        }
        return OMAbstractFactory.getSOAP11Factory();
    }

    private void fillSoapEnvelope(MessageContext mc, OMElement elem) throws AxisFault {
        mc.setServiceContext(this.serviceContext);
        SOAPFactory sf = this.getSOAPFactory();
        SOAPEnvelope se = sf.getDefaultEnvelope();
        if (elem != null) {
            se.getBody().addChild(elem);
        }
        if (this.headers != null) {
            SOAPHeader sh = se.getHeader();
            for (int i = 0; i < this.headers.size(); ++i) {
                sh.addChild((OMElement)this.headers.get(i));
            }
        }
        mc.setEnvelope(se);
    }

    private class SyncCallBack
    extends Callback {
        private SOAPEnvelope envelope;
        private MessageContext msgctx;
        private Exception error;

        private SyncCallBack() {
        }

        public void onComplete(AsyncResult result) {
            this.envelope = result.getResponseEnvelope();
            this.msgctx = result.getResponseMessageContext();
        }

        public void onError(Exception e) {
            this.error = e;
        }

        public MessageContext getMsgctx() {
            return this.msgctx;
        }
    }
}

