/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.client;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.om.OMAbstractFactory;
import org.apache.axis2.om.OMElement;
import org.apache.axis2.om.impl.llom.builder.StAXOMBuilder;
import org.apache.axis2.om.impl.llom.factory.OMXMLBuilderFactory;
import org.apache.axis2.soap.SOAPBody;
import org.apache.axis2.soap.SOAPEnvelope;
import org.apache.axis2.soap.SOAPFactory;
import org.apache.axis2.soap.SOAPProcessingException;

public abstract class Stub {
    protected static AxisService _service;
    protected ArrayList modules = new ArrayList();
    protected Options _options = new Options();
    protected ServiceClient _serviceClient;

    public Options _getOptions() {
        return this._options;
    }

    public void _setOptions(Options _clientOptions) {
        this._options = _clientOptions;
    }

    protected SOAPEnvelope createEnvelope() throws SOAPProcessingException {
        return this.getFactory(this._options.getSoapVersionURI()).getDefaultEnvelope();
    }

    public void engageModule(QName moduleName) throws AxisFault {
        this._serviceClient.engageModule(moduleName);
    }

    protected OMElement getElement(SOAPEnvelope env, String type) {
        SOAPBody body = env.getBody();
        OMElement element = body.getFirstElement();
        if ("rpc".equals(type)) {
            return element.getFirstElement();
        }
        if ("doc".equals(type)) {
            return element;
        }
        throw new UnsupportedOperationException("Unsupported type");
    }

    protected OMElement getElementFromReader(XMLStreamReader reader) {
        StAXOMBuilder builder = OMXMLBuilderFactory.createStAXOMBuilder(OMAbstractFactory.getOMFactory(), reader);
        return builder.getDocumentElement();
    }

    protected SOAPFactory getFactory(String soapNamespaceURI) {
        String soapVersionURI = this._options.getSoapVersionURI();
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(soapVersionURI)) {
            return OMAbstractFactory.getSOAP11Factory();
        }
        if ("http://www.w3.org/2003/05/soap-envelope".equals(soapVersionURI)) {
            return OMAbstractFactory.getSOAP12Factory();
        }
        throw new RuntimeException("Unknown SOAP version");
    }
}

