/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.client;

import java.net.URL;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.InOnlyMEPClient;
import org.apache.axis2.client.InOutMEPClient;
import org.apache.axis2.client.MEPClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.wsdl.WSDLVersionWrapper;
import org.apache.axis2.wsdl.builder.WOMBuilder;
import org.apache.axis2.wsdl.builder.WOMBuilderFactory;
import org.apache.wsdl.WSDLBinding;
import org.apache.wsdl.WSDLBindingOperation;
import org.apache.wsdl.WSDLDescription;
import org.apache.wsdl.WSDLEndpoint;
import org.apache.wsdl.WSDLInterface;
import org.apache.wsdl.WSDLOperation;
import org.apache.wsdl.WSDLService;
import org.apache.wsdl.extensions.SOAPAddress;
import org.apache.wsdl.extensions.SOAPOperation;

public class WSDLMEPClientBuilder {
    private boolean isoneway;
    private ConfigurationContext configurationContext;
    private WSDLDescription description;

    public WSDLMEPClientBuilder(String clienthome) throws AxisFault {
        try {
            this.configurationContext = new ConfigurationContextFactory().createConfigurationContextFromFileSystem(clienthome);
        }
        catch (DeploymentException e) {
            throw new AxisFault(e);
        }
    }

    public MEPClient createMEPClient(String operationname) throws AxisFault {
        return this.createMEPClient(null, null, operationname);
    }

    public MEPClient createMEPClient(QName endpointname, String operationname) throws AxisFault {
        return this.createMEPClient(null, endpointname, operationname);
    }

    /*
     * WARNING - void declaration
     */
    public MEPClient createMEPClient(QName servicename, QName endpointname, String operationname) throws AxisFault {
        void var18_18;
        MEPClient mepclient;
        if (this.description == null) {
            throw new AxisFault("You need to call public void defineDescription(URL wsdlurl before this method)");
        }
        WSDLService service = this.findService(servicename);
        AxisService serviceDesc = new AxisService();
        WSDLEndpoint endpoint = this.findEndpoint(endpointname, service);
        EndpointReference toepr = null;
        Options op = new Options();
        Iterator elements = endpoint.getExtensibilityElements().iterator();
        while (elements.hasNext()) {
            Object obj = elements.next();
            if (!(obj instanceof SOAPAddress)) continue;
            SOAPAddress soapAddress = (SOAPAddress)obj;
            toepr = new EndpointReference(soapAddress.getLocationURI());
        }
        if (toepr == null) {
            throw new AxisFault("To Address not found");
        }
        op.setTo(toepr);
        WSDLBinding binding = endpoint.getBinding();
        Iterator bindings = binding.getBindingOperations().values().iterator();
        while (bindings.hasNext()) {
            WSDLBindingOperation wsdlbop = (WSDLBindingOperation)bindings.next();
            WSDLOperation wsdlop = wsdlbop.getOperation();
            AxisOperation axisOp = AxisOperationFactory.getAxisOperation(this.findMEP(wsdlop));
            axisOp.setName(wsdlop.getName());
            serviceDesc.addOperation(axisOp);
        }
        this.configurationContext.getAxisConfiguration().addService(serviceDesc);
        AxisServiceGroup serviceGroup = new AxisServiceGroup(this.configurationContext.getAxisConfiguration());
        ServiceGroupContext serviceGroupContext = new ServiceGroupContext(this.configurationContext, serviceGroup);
        ServiceContext serviceContext = new ServiceContext(serviceDesc, serviceGroupContext);
        WSDLOperation wsdlop = this.getOperation(operationname, endpoint);
        WSDLBindingOperation bop = binding.getBindingOperation(wsdlop.getName());
        Iterator elments = bop.getExtensibilityElements().iterator();
        while (elments.hasNext()) {
            Object obj = elments.next();
            if (!(obj instanceof SOAPOperation)) continue;
            SOAPOperation soapOp = (SOAPOperation)obj;
            op.setSoapAction(soapOp.getSoapAction());
            break;
        }
        if (wsdlop.getInputMessage() != null && wsdlop.getOutputMessage() != null && !this.isoneway) {
            mepclient = new InOutMEPClient(serviceContext);
        } else if (wsdlop.getInputMessage() != null || this.isoneway) {
            mepclient = new InOnlyMEPClient(serviceContext);
        } else {
            throw new AxisFault("Unknown MEP");
        }
        var18_18.setClientOptions(op);
        return var18_18;
    }

    public void defineDescription(URL wsdlurl) throws AxisFault {
        try {
            WOMBuilder buider = WOMBuilderFactory.getBuilder(1);
            WSDLVersionWrapper vw = buider.build(wsdlurl.openStream());
            this.description = vw.getDescription();
        }
        catch (Exception e) {
            throw new AxisFault(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private WSDLEndpoint findEndpoint(QName endpointname, WSDLService service) throws AxisFault {
        WSDLEndpoint endpoint;
        if (endpointname == null) {
            Iterator endpoints = service.getEndpoints().values().iterator();
            if (!endpoints.hasNext()) throw new AxisFault("No Endpoint Found in Service, " + service.getName());
            endpoint = (WSDLEndpoint)endpoints.next();
        } else {
            endpoint = service.getEndpoint(endpointname);
        }
        if (endpoint != null) return endpoint;
        throw new AxisFault("Endpoint Not found");
    }

    private int findMEP(WSDLOperation wsdlOp) throws AxisFault {
        if (wsdlOp.getInputMessage() == null) {
            throw new AxisFault("Unsupported MEP");
        }
        if (wsdlOp.getOutputMessage() == null) {
            return 10;
        }
        return 12;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private WSDLService findService(QName serviceName) throws AxisFault {
        WSDLService service;
        if (serviceName == null) {
            Iterator services = this.description.getServices().values().iterator();
            if (!services.hasNext()) throw new AxisFault("No service found");
            service = (WSDLService)services.next();
        } else {
            service = this.description.getService(serviceName);
        }
        if (service != null) return service;
        throw new AxisFault("No service found");
    }

    public WSDLDescription getDescription() {
        return this.description;
    }

    private WSDLOperation getOperation(String operation, WSDLEndpoint endpoint) throws AxisFault {
        WSDLInterface wsdlinterface = endpoint.getBinding().getBoundInterface();
        Iterator operations = wsdlinterface.getAllOperations().values().iterator();
        while (operations.hasNext()) {
            WSDLOperation wsdlOp = (WSDLOperation)operations.next();
            if (!wsdlOp.getName().getLocalPart().equals(operation)) continue;
            return wsdlOp;
        }
        throw new AxisFault("Operation Not found");
    }

    public void setIsoneway(boolean isoneway) {
        this.isoneway = isoneway;
    }
}

