/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractContext {
    protected long lastTouchedTime;
    protected AbstractContext parent;
    protected Map properties = new HashMap();

    protected AbstractContext(AbstractContext parent) {
        this.parent = parent;
    }

    public AbstractContext getParent() {
        return this.parent;
    }

    public Map getProperties() {
        return this.properties;
    }

    public Object getProperty(String key) {
        Object obj = null;
        obj = this.properties.get(key);
        if (obj == null && this.parent != null) {
            obj = this.parent.getProperty(key);
        }
        return obj;
    }

    public void setParent(AbstractContext context) {
        this.parent = context;
    }

    public void setProperties(Map properties) {
        if (properties == null) {
            this.properties = null;
        } else {
            Boolean copyProperties = (Boolean)properties.get("CopyProperties");
            if (copyProperties != null && copyProperties.booleanValue()) {
                Iterator iterator = properties.keySet().iterator();
                while (iterator.hasNext()) {
                    Object key = iterator.next();
                    this.properties.put(key, properties.get(key));
                }
            } else {
                this.properties = properties;
            }
        }
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    protected void touch() {
        this.lastTouchedTime = new Date().getTime();
        if (this.parent != null) {
            this.parent.touch();
        }
    }

    public long getLastTouchedTime() {
        return this.lastTouchedTime;
    }
}

