/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.FileSystemConfigurator;
import org.apache.axis2.description.ModuleDescription;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.axis2.modules.Module;
import org.apache.axis2.phaseresolver.PhaseException;
import org.apache.axis2.phaseresolver.PhaseResolver;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.TransportSender;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationContextFactory {
    private Log log = LogFactory.getLog(this.getClass());

    public ConfigurationContext createConfigurationContext(AxisConfigurator axisConfigurator) throws AxisFault {
        AxisConfiguration axisConfig = axisConfigurator.getAxisConfiguration();
        ConfigurationContext configContext = new ConfigurationContext(axisConfig);
        this.init(configContext);
        return configContext;
    }

    public ConfigurationContext createConfigurationContextFromFileSystem(String path) throws AxisFault {
        return this.createConfigurationContext(new FileSystemConfigurator(path, true));
    }

    private void init(ConfigurationContext configContext) throws AxisFault {
        try {
            PhaseResolver phaseResolver = new PhaseResolver(configContext.getAxisConfiguration());
            phaseResolver.buildTranspotsChains();
            this.initModules(configContext);
            this.initTransports(configContext);
        }
        catch (PhaseException e) {
            throw new AxisFault(e);
        }
        catch (DeploymentException e) {
            throw new AxisFault(e);
        }
    }

    private void initModules(ConfigurationContext context) throws DeploymentException {
        try {
            HashMap modules = context.getAxisConfiguration().getModules();
            Collection col = modules.values();
            Iterator iterator = col.iterator();
            while (iterator.hasNext()) {
                ModuleDescription axismodule = (ModuleDescription)iterator.next();
                Module module = axismodule.getModule();
                if (module == null) continue;
                module.init(context.getAxisConfiguration());
            }
        }
        catch (AxisFault e) {
            throw new DeploymentException(e);
        }
    }

    public void initTransports(ConfigurationContext configContext) {
        AxisConfiguration axisConf = configContext.getAxisConfiguration();
        HashMap transportIns = axisConf.getTransportsIn();
        Iterator values = transportIns.values().iterator();
        while (values.hasNext()) {
            TransportInDescription transportIn = (TransportInDescription)values.next();
            TransportListener listener = transportIn.getReceiver();
            if (listener == null) continue;
            try {
                listener.init(configContext, transportIn);
            }
            catch (AxisFault axisFault) {
                this.log.info((Object)("Transport-IN initialization error : " + transportIn.getName().getLocalPart()));
            }
        }
        HashMap transportOuts = axisConf.getTransportsOut();
        values = transportOuts.values().iterator();
        while (values.hasNext()) {
            TransportOutDescription transportOut = (TransportOutDescription)values.next();
            TransportSender sender = transportOut.getSender();
            if (sender == null) continue;
            try {
                sender.init(configContext, transportOut);
            }
            catch (AxisFault axisFault) {
                this.log.info((Object)("Transport-OUT initialization error : " + transportOut.getName().getLocalPart()));
            }
        }
    }

    public ConfigurationContext createEmptyConfigurationContext() {
        return new ConfigurationContext(new AxisConfiguration());
    }
}

