/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.policy.Policy;
import org.apache.ws.policy.PolicyReference;
import org.apache.ws.policy.util.DOMPolicyReader;
import org.apache.ws.policy.util.PolicyFactory;
import org.apache.wsdl.impl.WSDLProcessingException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AxisServiceBuilder {
    private static final String XMLSCHEMA_NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema";
    private static final String XMLSCHEMA_NAMESPACE_PREFIX = "xs";
    private static final String XML_SCHEMA_LOCAL_NAME = "schema";
    private static final String XML_SCHEMA_SEQUENCE_LOCAL_NAME = "sequence";
    private static final String XML_SCHEMA_COMPLEX_TYPE_LOCAL_NAME = "complexType";
    private static final String XML_SCHEMA_ELEMENT_LOCAL_NAME = "element";
    private static final String XML_SCHEMA_IMPORT_LOCAL_NAME = "import";
    private static final String XSD_NAME = "name";
    private static final String XSD_ELEMENT_FORM_DEFAULT = "elementFormDefault";
    private static final String XSD_UNQUALIFIED = "unqualified";
    private static final String XSD_TARGETNAMESPACE = "targetNamespace";
    private static final String XSD_TYPE = "type";
    private static final String XSD_REF = "ref";
    private static final String AXIS2WRAPPED = "axis2wrapped";
    private static final String XMLNS_AXIS2WRAPPED = "xmlns:axis2wrapped";
    private static final String WSA_NS_URI = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
    private static final String WSA_ACTION = "Action";
    private Log logger = LogFactory.getLog((String)this.getClass().getName());
    private int nsCount = 1;

    public AxisService getAxisService(InputStream wsdlInputStream) throws DeploymentException {
        this.logger.debug((Object)"Entering AxisServiceBuilder:getAxisService(java.io.InputStream)");
        try {
            Document doc = XMLUtils.newDocument(wsdlInputStream);
            WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
            reader.setFeature("javax.wsdl.importDocuments", true);
            Definition wsdlDefinition = reader.readWSDL(null, doc);
            return this.getAxisService(wsdlDefinition);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)"Exception occured when creating the Document from WSDL", (Throwable)e);
            throw new DeploymentException(e);
        }
    }

    public AxisService getAxisService(Definition wsdlDefinition) throws DeploymentException {
        Map ports;
        HashMap resolvedRPCWrapperElements;
        XmlSchema xmlSchemaForWrappedElements;
        this.logger.debug((Object)"Entering AxisServiceBuilder:getAxisService(javax.wsdl.Definition)");
        AxisService axisService = new AxisService();
        axisService.setWSDLDefinition(wsdlDefinition);
        Map services = wsdlDefinition.getServices();
        if (services.isEmpty()) {
            this.logger.error((Object)"No javax.wsdl.Service element found");
            throw new DeploymentException("No javax.wsdl.Service element is found");
        }
        Iterator serviceIterator = services.values().iterator();
        Service wsdl4jService = (Service)serviceIterator.next();
        axisService.setName(wsdl4jService.getQName().getLocalPart());
        PolicyInclude policyInclude = new PolicyInclude();
        List wsdlPolicies = this.getPoliciesAsExtElements(wsdlDefinition.getExtensibilityElements());
        Iterator wsdlPolicyIterator = wsdlPolicies.iterator();
        while (wsdlPolicyIterator.hasNext()) {
            Policy wsdlPolicy = (Policy)wsdlPolicyIterator.next();
            if (wsdlPolicy.getPolicyURI() == null) continue;
            policyInclude.registerPolicy(wsdlPolicy);
        }
        axisService.setPolicyInclude(policyInclude);
        Types types = wsdlDefinition.getTypes();
        if (types != null) {
            Iterator extElements = types.getExtensibilityElements().iterator();
            while (extElements.hasNext()) {
                ExtensibilityElement extElement = (ExtensibilityElement)extElements.next();
                if (!(extElement instanceof Schema)) continue;
                Element schemaElement = ((Schema)extElement).getElement();
                axisService.setSchema(this.getXMLSchema(schemaElement));
            }
        }
        if ((xmlSchemaForWrappedElements = this.generateWrapperSchema(wsdlDefinition, resolvedRPCWrapperElements = new HashMap())) != null) {
            axisService.setSchema(xmlSchemaForWrappedElements);
        }
        if ((ports = wsdl4jService.getPorts()).isEmpty()) {
            this.logger.error((Object)"atleast one port should be specified");
            throw new WSDLProcessingException("atleast one Port should be specified");
        }
        Port wsdl4jPort = this.getPortWithSoapBinding(ports);
        if (wsdl4jPort == null) {
            this.logger.error((Object)"atleast one port with a soap binding should be specified");
            throw new WSDLProcessingException("no port with soap binding found");
        }
        Binding wsdl4jBinding = wsdl4jPort.getBinding();
        PortType wsdl4jPortType = wsdl4jBinding.getPortType();
        List axisServicePolicies = this.getPoliciesAsExtElements(wsdl4jService.getExtensibilityElements());
        this.addPolicyElements(3, axisServicePolicies, policyInclude);
        axisServicePolicies = this.getPoliciesAsExtElements(wsdl4jPort.getExtensibilityElements());
        this.addPolicyElements(4, axisServicePolicies, policyInclude);
        axisServicePolicies = this.getPoliciesAsExtAttributes(wsdl4jPortType.getExtensionAttributes());
        this.addPolicyElements(5, axisServicePolicies, policyInclude);
        axisServicePolicies = this.getPoliciesAsExtElements(wsdl4jBinding.getExtensibilityElements());
        this.addPolicyElements(6, axisServicePolicies, policyInclude);
        Iterator wsdl4jOperations = wsdl4jPortType.getOperations().iterator();
        while (wsdl4jOperations.hasNext()) {
            AxisOperation axisOperation;
            Operation wsdl4jOperation = (Operation)wsdl4jOperations.next();
            BindingOperation wsdl4jBindingOperation = wsdl4jBinding.getBindingOperation(wsdl4jOperation.getName(), null, null);
            try {
                axisOperation = AxisOperationFactory.getAxisOperation(this.getMessageExchangePattern(wsdl4jOperation));
                axisOperation.setParent(axisService);
                axisOperation.setName(new QName(wsdl4jOperation.getName()));
                PolicyInclude operationPolicyInclude = new PolicyInclude(axisService.getPolicyInclude());
                List operationPolicies = this.getPoliciesAsExtElements(wsdl4jOperation.getExtensibilityElements());
                this.addPolicyElements(7, operationPolicies, operationPolicyInclude);
                operationPolicies = this.getPoliciesAsExtElements(wsdl4jBindingOperation.getExtensibilityElements());
                this.addPolicyElements(8, operationPolicies, operationPolicyInclude);
                axisOperation.setPolicyInclude(operationPolicyInclude);
                String soapActionURI = this.getSOAPActionURI(wsdl4jBindingOperation.getExtensibilityElements());
                if (soapActionURI != null) {
                    axisService.mapActionToOperation(soapActionURI, axisOperation);
                }
                Input wsdl4jInput = wsdl4jOperation.getInput();
                BindingInput wsdl4jBindingInput = wsdl4jBindingOperation.getBindingInput();
                Message wsdl4jInputMessage = wsdl4jInput.getMessage();
                AxisMessage axisInputMessage = axisOperation.getMessage("In");
                PolicyInclude inputPolicyInclue = new PolicyInclude(axisOperation.getPolicyInclude());
                List inputMessagePolicies = this.getPoliciesAsExtAttributes(wsdl4jInput.getExtensionAttributes());
                this.addPolicyElements(9, inputMessagePolicies, inputPolicyInclue);
                inputMessagePolicies = this.getPoliciesAsExtElements(wsdl4jBindingInput.getExtensibilityElements());
                this.addPolicyElements(11, inputMessagePolicies, inputPolicyInclue);
                inputMessagePolicies = this.getPoliciesAsExtElements(wsdl4jInputMessage.getExtensibilityElements());
                this.addPolicyElements(13, inputMessagePolicies, inputPolicyInclue);
                axisInputMessage.setPolicyInclude(policyInclude);
                axisInputMessage.setElementQName(this.generateReferenceQname(new QName(wsdl4jPortType.getQName().getNamespaceURI(), wsdl4jOperation.getName()), wsdl4jInputMessage, this.findWrapppable(wsdl4jInputMessage), resolvedRPCWrapperElements));
                String wsaActionForInput = this.getWsaAction(wsdl4jInput.getExtensionAttributes());
                if (wsaActionForInput != null && wsaActionForInput.length() != 0) {
                    axisService.mapActionToOperation(wsaActionForInput, axisOperation);
                }
                Output wsdl4jOutput = wsdl4jOperation.getOutput();
                BindingOutput wsdl4jBindingOutput = wsdl4jBindingOperation.getBindingOutput();
                if (wsdl4jOutput != null) {
                    AxisMessage axisOutputMessage = axisOperation.getMessage("Out");
                    Message wsdl4jOutputMessage = wsdl4jOutput.getMessage();
                    PolicyInclude outputPolicyInclude = new PolicyInclude(axisService.getPolicyInclude());
                    List outputPolicies = this.getPoliciesAsExtAttributes(wsdl4jOutput.getExtensionAttributes());
                    this.addPolicyElements(10, outputPolicies, outputPolicyInclude);
                    outputPolicies = this.getPoliciesAsExtElements(wsdl4jBindingOutput.getExtensibilityElements());
                    this.addPolicyElements(12, outputPolicies, outputPolicyInclude);
                    outputPolicies = this.getPoliciesAsExtElements(wsdl4jOutputMessage.getExtensibilityElements());
                    this.addPolicyElements(13, outputPolicies, outputPolicyInclude);
                    axisOutputMessage.setPolicyInclude(outputPolicyInclude);
                    axisOutputMessage.setElementQName(this.generateReferenceQname(new QName(wsdl4jOperation.getName()), wsdl4jOutputMessage, this.findWrapppable(wsdl4jOutputMessage), resolvedRPCWrapperElements));
                    String wsaActionForOutput = this.getWsaAction(wsdl4jOutput.getExtensionAttributes());
                    if (wsaActionForOutput != null && wsaActionForOutput.length() != 0) {
                        axisService.mapActionToOperation(wsaActionForOutput, axisOperation);
                    }
                }
            }
            catch (AxisFault axisFault) {
                this.logger.error((Object)"Exception when creating AxisOperation for the AxisService", (Throwable)axisFault);
                throw new DeploymentException(axisFault.getMessage());
            }
            axisService.addOperation(axisOperation);
        }
        return axisService;
    }

    private int getMessageExchangePattern(Operation wsdl4jOperation) {
        this.logger.debug((Object)"AxisServiceBuilder.getMessageExchangePattern");
        if (wsdl4jOperation.getOutput() == null) {
            return 10;
        }
        return 12;
    }

    private XmlSchema getXMLSchema(Element element) {
        this.logger.debug((Object)"AxisServiceBuilder:getXMLSchema");
        return new XmlSchemaCollection().read(element);
    }

    private Document getDOMDocument() throws DeploymentException {
        this.logger.debug((Object)"AxisServiceBuilder:getDOMDocument");
        try {
            DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
            fac.setNamespaceAware(true);
            return fac.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException ex) {
            this.logger.error((Object)"Exception occured when creating a Decument element", (Throwable)ex);
            throw new DeploymentException(ex.getMessage());
        }
    }

    private String getTempPrefix() {
        return "ns" + this.nsCount++;
    }

    private XmlSchema generateWrapperSchema(Definition wsdl4jDefinition, Map resolvedRpcWrappedElementMap) throws DeploymentException {
        this.logger.debug((Object)"AxisServiceBuilder.generateWrapperSchema");
        Map declaredNameSpaces = wsdl4jDefinition.getNamespaces();
        HashMap<QName, Message> messagesMap = new HashMap<QName, Message>();
        HashMap<String, Message> inputOperationsMap = new HashMap<String, Message>();
        HashMap<String, Message> outputOperationsMap = new HashMap<String, Message>();
        HashMap<String, Element> namespaceImportsMap = new HashMap<String, Element>();
        HashMap<QName, Element> complexTypeElementsMap = new HashMap<QName, Element>();
        ArrayList<Element> elementElementsList = new ArrayList<Element>();
        HashMap<String, String> namespacePrefixMap = new HashMap<String, String>();
        String targetNamespaceUri = wsdl4jDefinition.getTargetNamespace();
        Map porttypeMap = wsdl4jDefinition.getPortTypes();
        PortType[] porttypesArray = porttypeMap.values().toArray(new PortType[porttypeMap.size()]);
        for (int j = 0; j < porttypesArray.length; ++j) {
            List operations = porttypesArray[j].getOperations();
            for (int k = 0; k < operations.size(); ++k) {
                Output output;
                Message message;
                Operation op = (Operation)operations.get(k);
                Input input = op.getInput();
                if (input != null) {
                    message = input.getMessage();
                    messagesMap.put(message.getQName(), message);
                    inputOperationsMap.put(op.getName(), message);
                }
                if ((output = op.getOutput()) == null) continue;
                message = output.getMessage();
                messagesMap.put(message.getQName(), message);
                outputOperationsMap.put(op.getName(), message);
            }
        }
        QName[] keys = messagesMap.keySet().toArray(new QName[messagesMap.size()]);
        boolean noMessagesTobeProcessed = true;
        for (int i = 0; i < keys.length; ++i) {
            if (!this.findWrapppable((Message)messagesMap.get(keys[i]))) continue;
            noMessagesTobeProcessed = false;
            break;
        }
        if (noMessagesTobeProcessed) {
            return null;
        }
        ArrayList<QName> resolvedMessageQNames = new ArrayList<QName>();
        String xsdPrefix = this.findSchemaPrefix(declaredNameSpaces);
        Document document = this.getDOMDocument();
        for (int i = 0; i < keys.length; ++i) {
            Message wsdl4jMessage = (Message)messagesMap.get(keys[i]);
            if (resolvedMessageQNames.contains(wsdl4jMessage.getQName())) continue;
            Map parts = wsdl4jMessage.getParts();
            String name = wsdl4jMessage.getQName().getLocalPart();
            Element newComplexType = document.createElementNS(XMLSCHEMA_NAMESPACE_URI, xsdPrefix + ":" + XML_SCHEMA_COMPLEX_TYPE_LOCAL_NAME);
            newComplexType.setAttribute(XSD_NAME, name);
            Element cmplxContentSequence = document.createElementNS(XMLSCHEMA_NAMESPACE_URI, xsdPrefix + ":" + XML_SCHEMA_SEQUENCE_LOCAL_NAME);
            Iterator iterator = parts.keySet().iterator();
            while (iterator.hasNext()) {
                String prefix;
                QName schemaTypeName;
                Part part = (Part)parts.get(iterator.next());
                String elementName = part.getName();
                boolean isTyped = true;
                if (part.getTypeName() != null) {
                    schemaTypeName = part.getTypeName();
                } else if (part.getElementName() != null) {
                    schemaTypeName = part.getElementName();
                    isTyped = false;
                } else {
                    this.logger.error((Object)"Exception occured while creating wrapper element");
                    throw new RuntimeException(" Unqualified Message part!");
                }
                Element child = document.createElementNS(XMLSCHEMA_NAMESPACE_URI, xsdPrefix + ":" + XML_SCHEMA_ELEMENT_LOCAL_NAME);
                if (XMLSCHEMA_NAMESPACE_URI.equals(schemaTypeName.getNamespaceURI())) {
                    prefix = xsdPrefix;
                } else {
                    String uri = schemaTypeName.getNamespaceURI();
                    if (!namespaceImportsMap.containsKey(uri)) {
                        Element namespaceImport = document.createElementNS(XMLSCHEMA_NAMESPACE_URI, xsdPrefix + ":" + XML_SCHEMA_IMPORT_LOCAL_NAME);
                        namespaceImport.setAttribute("namespace", uri);
                        namespaceImportsMap.put(uri, namespaceImport);
                        prefix = this.getTempPrefix();
                        namespacePrefixMap.put(uri, prefix);
                    } else {
                        prefix = (String)namespacePrefixMap.get(uri);
                    }
                }
                if (isTyped) {
                    child.setAttribute(XSD_NAME, elementName);
                    child.setAttribute(XSD_TYPE, prefix + ":" + schemaTypeName.getLocalPart());
                } else {
                    child.setAttribute(XSD_REF, prefix + ":" + schemaTypeName.getLocalPart());
                }
                cmplxContentSequence.appendChild(child);
            }
            newComplexType.appendChild(cmplxContentSequence);
            complexTypeElementsMap.put(wsdl4jMessage.getQName(), newComplexType);
            resolvedMessageQNames.add(wsdl4jMessage.getQName());
        }
        String[] inputOperationtNames = inputOperationsMap.keySet().toArray(new String[inputOperationsMap.size()]);
        for (int j = 0; j < inputOperationtNames.length; ++j) {
            String inputOpName = inputOperationtNames[j];
            Element elementDeclaration = document.createElementNS(XMLSCHEMA_NAMESPACE_URI, xsdPrefix + ":" + XML_SCHEMA_ELEMENT_LOCAL_NAME);
            elementDeclaration.setAttribute(XSD_NAME, inputOpName);
            String typeValue = ((Message)inputOperationsMap.get(inputOpName)).getQName().getLocalPart();
            elementDeclaration.setAttribute(XSD_TYPE, "axis2wrapped:" + typeValue);
            elementElementsList.add(elementDeclaration);
            resolvedRpcWrappedElementMap.put(inputOpName, new QName(targetNamespaceUri, inputOpName, AXIS2WRAPPED));
        }
        String[] outputOperationtNames = outputOperationsMap.keySet().toArray(new String[outputOperationsMap.size()]);
        for (int j = 0; j < outputOperationtNames.length; ++j) {
            String baseoutputOpName = outputOperationtNames[j];
            String outputOpName = baseoutputOpName + "Response";
            Element elementDeclaration = document.createElementNS(XMLSCHEMA_NAMESPACE_URI, xsdPrefix + ":" + XML_SCHEMA_ELEMENT_LOCAL_NAME);
            elementDeclaration.setAttribute(XSD_NAME, outputOpName);
            String typeValue = ((Message)outputOperationsMap.get(baseoutputOpName)).getQName().getLocalPart();
            elementDeclaration.setAttribute(XSD_TYPE, "axis2wrapped:" + typeValue);
            elementElementsList.add(elementDeclaration);
            resolvedRpcWrappedElementMap.put(outputOpName, new QName(targetNamespaceUri, outputOpName, AXIS2WRAPPED));
        }
        Element schemaElement = document.createElementNS(XMLSCHEMA_NAMESPACE_URI, xsdPrefix + ":" + XML_SCHEMA_LOCAL_NAME);
        String[] nameSpaceDeclarationArray = namespacePrefixMap.keySet().toArray(new String[namespacePrefixMap.size()]);
        for (int i = 0; i < nameSpaceDeclarationArray.length; ++i) {
            String s = nameSpaceDeclarationArray[i];
            schemaElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + namespacePrefixMap.get(s).toString(), s);
        }
        schemaElement.setAttributeNS("http://www.w3.org/2000/xmlns/", XMLNS_AXIS2WRAPPED, targetNamespaceUri);
        schemaElement.setAttribute(XSD_TARGETNAMESPACE, targetNamespaceUri);
        schemaElement.setAttribute(XSD_ELEMENT_FORM_DEFAULT, XSD_UNQUALIFIED);
        Element[] namespaceImports = namespaceImportsMap.values().toArray(new Element[namespaceImportsMap.size()]);
        for (int i = 0; i < namespaceImports.length; ++i) {
            schemaElement.appendChild(namespaceImports[i]);
        }
        Element[] complexTypeElements = complexTypeElementsMap.values().toArray(new Element[complexTypeElementsMap.size()]);
        for (int i = 0; i < complexTypeElements.length; ++i) {
            schemaElement.appendChild(complexTypeElements[i]);
        }
        Element[] elementDeclarations = elementElementsList.toArray(new Element[elementElementsList.size()]);
        for (int i = 0; i < elementDeclarations.length; ++i) {
            schemaElement.appendChild(elementDeclarations[i]);
        }
        XmlSchemaCollection schemaCollection = new XmlSchemaCollection();
        Iterator prefixes = declaredNameSpaces.keySet().iterator();
        while (prefixes.hasNext()) {
            String prefix = (String)prefixes.next();
            String u = (String)declaredNameSpaces.get(prefix);
            schemaCollection.mapNamespace(prefix, u);
        }
        return schemaCollection.read(schemaElement);
    }

    private boolean findWrapppable(Message message) {
        boolean wrappable;
        Map partsMap = message.getParts();
        Iterator parts = partsMap.values().iterator();
        boolean bl = wrappable = partsMap.size() > 1;
        while (!wrappable && parts.hasNext()) {
            Part part = (Part)parts.next();
            wrappable = part.getTypeName() != null || wrappable;
        }
        return wrappable;
    }

    private String findSchemaPrefix(Map declaredNameSpaces) {
        this.logger.debug((Object)"AxisServiceBuilder.findSchemaPerfix");
        String xsdPrefix = null;
        if (declaredNameSpaces.containsValue(XMLSCHEMA_NAMESPACE_URI)) {
            Iterator it = declaredNameSpaces.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (!XMLSCHEMA_NAMESPACE_URI.equals(declaredNameSpaces.get(key))) continue;
                xsdPrefix = key;
                break;
            }
        } else {
            xsdPrefix = XMLSCHEMA_NAMESPACE_PREFIX;
        }
        return xsdPrefix;
    }

    private QName generateReferenceQname(QName outerName, Message wsdl4jMessage, boolean isWrappable, Map resolvedRpcWrappedElementMap) {
        QName referenceQName = null;
        if (isWrappable) {
            referenceQName = (QName)resolvedRpcWrappedElementMap.get(outerName.getLocalPart());
        } else {
            Iterator outputIterator = wsdl4jMessage.getParts().values().iterator();
            if (outputIterator.hasNext()) {
                Part outPart = (Part)outputIterator.next();
                QName typeName = outPart.getTypeName();
                referenceQName = null != typeName ? typeName : outPart.getElementName();
            }
        }
        return referenceQName;
    }

    private List getPoliciesAsExtElements(List extElementsList) throws DeploymentException {
        ArrayList<Object> policies = new ArrayList<Object>();
        Iterator extElements = extElementsList.iterator();
        DOMPolicyReader reader = (DOMPolicyReader)PolicyFactory.getPolicyReader((int)3);
        while (extElements.hasNext()) {
            Object extElement = extElements.next();
            if (!(extElement instanceof UnknownExtensibilityElement)) continue;
            UnknownExtensibilityElement e = (UnknownExtensibilityElement)extElement;
            Element element = e.getElement();
            if ("http://schemas.xmlsoap.org/ws/2004/09/policy".equals(element.getNamespaceURI()) && "Policy".equals(element.getLocalName())) {
                policies.add(reader.readPolicy(element));
                continue;
            }
            if (!"http://schemas.xmlsoap.org/ws/2004/09/policy".equals(element.getNamespaceURI()) || !"PolicyReference".equals(element.getLocalName())) continue;
            try {
                policies.add(reader.readPolicyReference(element));
            }
            catch (Exception ex) {
                this.logger.debug((Object)"Exception occured when processing policy elements");
                throw new DeploymentException(ex.getMessage());
            }
        }
        return policies;
    }

    private List getPoliciesAsExtAttributes(Map extAttributes) {
        ArrayList<PolicyReference> policies = new ArrayList<PolicyReference>();
        Object policyURIsString = extAttributes.get(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "PolicyURIs"));
        if (policyURIsString != null) {
            String[] policyURIs = ((QName)policyURIsString).getLocalPart().trim().split(" ");
            for (int i = 0; i < policyURIs.length; ++i) {
                policies.add(new PolicyReference(policyURIs[i]));
            }
        }
        return policies;
    }

    private void addPolicyElements(int type, List policyElements, PolicyInclude policyInclude) {
        Iterator policyElementIterator = policyElements.iterator();
        while (policyElementIterator.hasNext()) {
            Object policyElement = policyElementIterator.next();
            if (policyElement instanceof Policy) {
                policyInclude.addPolicyElement(type, (Policy)policyElement);
                continue;
            }
            if (!(policyElement instanceof PolicyReference)) continue;
            policyInclude.addPolicyRefElement(type, (PolicyReference)policyElement);
        }
    }

    private String getWsaAction(Map extAttributes) {
        Object wsaAction = extAttributes.get(new QName(WSA_NS_URI, WSA_ACTION));
        if (wsaAction != null) {
            return ((QName)wsaAction).getLocalPart();
        }
        return null;
    }

    private String getSOAPActionURI(List extElements) {
        Iterator iterator = extElements.iterator();
        while (iterator.hasNext()) {
            String soapActionURI;
            Object extElement = iterator.next();
            if (!(extElement instanceof SOAPOperation) || (soapActionURI = ((SOAPOperation)extElement).getSoapActionURI()) == null || soapActionURI.length() == 0) continue;
            return soapActionURI;
        }
        return null;
    }

    private Port getPortWithSoapBinding(Map ports) {
        Iterator iterator = ports.values().iterator();
        while (iterator.hasNext()) {
            Port port = (Port)iterator.next();
            Binding wsdl4jBinding = port.getBinding();
            Iterator extElements = wsdl4jBinding.getExtensibilityElements().iterator();
            while (extElements.hasNext()) {
                Object extElement = extElements.next();
                if (!(extElement instanceof SOAPBinding)) continue;
                return port;
            }
        }
        return null;
    }
}

