/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.axis2.i18n.Messages;

public class DeploymentClassLoader
extends URLClassLoader {
    private ArrayList lib_jars_list;
    private HashMap loadedClass;
    private boolean parentFirst = false;
    private URL[] urls;

    public DeploymentClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.urls = urls;
        this.lib_jars_list = new ArrayList();
        this.loadedClass = new HashMap();
        this.findLibJars();
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        block13: {
            Class<?> cla = (Class<?>)this.loadedClass.get(name);
            if (cla != null) {
                return cla;
            }
            if (this.parentFirst) {
                try {
                    cla = super.findClass(name);
                    this.loadedClass.put(name, cla);
                    return cla;
                }
                catch (ClassNotFoundException e) {
                    boolean foundClass = false;
                    if (!foundClass) {
                        try {
                            byte[] raw = this.getClassByteCodes(name);
                            cla = this.defineClass(name, raw, 0, raw.length);
                            this.loadedClass.put(name, cla);
                            return cla;
                        }
                        catch (Exception e2) {
                            foundClass = false;
                        }
                        catch (ClassFormatError classFormatError) {
                            foundClass = false;
                        }
                    }
                    if (!foundClass) {
                        throw new ClassNotFoundException(Messages.getMessage("classnotfound", name));
                    }
                    break block13;
                }
            }
            try {
                byte[] raw = this.getClassByteCodes(name);
                cla = this.defineClass(name, raw, 0, raw.length);
                this.loadedClass.put(name, cla);
                return cla;
            }
            catch (ClassFormatError e) {
                throw e;
            }
            catch (Exception exception) {
                cla = super.findClass(name);
                this.loadedClass.put(name, cla);
                return cla;
            }
        }
        return null;
    }

    private void findLibJars() {
        File file = new File(this.urls[0].getFile());
        try {
            ZipEntry entry;
            ZipInputStream zin = new ZipInputStream(new FileInputStream(file));
            while ((entry = zin.getNextEntry()) != null) {
                String entryName = entry.getName();
                if (entryName == null || !entryName.toLowerCase().startsWith("lib/") || !entryName.toLowerCase().endsWith(".jar")) continue;
                this.lib_jars_list.add(entryName);
            }
            zin.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getBytes(String resourceName) {
        zin = null;
        i = 0;
        while (i < this.lib_jars_list.size()) {
            block15: {
                block14: {
                    libjar_name = (String)this.lib_jars_list.get(i);
                    in = super.getResourceAsStream(libjar_name);
                    try {
                        try {
                            zin = new ZipInputStream(in);
                            while ((entry = zin.getNextEntry()) != null) {
                                entryName = entry.getName();
                                if (entryName == null || !entryName.endsWith(resourceName)) continue;
                                data = new byte[2048];
                                out = new ByteArrayOutputStream();
                                while ((count = zin.read(data, 0, 2048)) != -1) {
                                    out.write(data, 0, count);
                                }
                                raw = out.toByteArray();
                                out.close();
                                var12_15 = raw;
                                var14_9 = null;
                                break block14;
                            }
                            break block15;
                        }
                        catch (IOException e) {
                            var8_8 = null;
                            var14_9 = null;
                            try {
                                if (zin == null) return var8_8;
                                zin.close();
                                return var8_8;
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                            return var8_8;
                        }
                    }
                    catch (Throwable var13_16) {
                        var14_9 = null;
                        ** try [egrp 2[TRYBLOCK] [5 : 173->184)] { 
lbl39:
                        // 1 sources

                        if (zin == null) throw var13_16;
                        zin.close();
                        throw var13_16;
lbl42:
                        // 1 sources

                        catch (IOException e) {
                            // empty catch block
                        }
                        throw var13_16;
                    }
                }
                try {}
                catch (IOException e) {
                    // empty catch block
                    return var12_15;
                }
                if (zin == null) return var12_15;
                zin.close();
                return var12_15;
            }
            var14_9 = null;
            try {}
            catch (IOException e) {}
            if (zin != null) {
                zin.close();
            }
            ++i;
        }
        return null;
    }

    private byte[] getClassByteCodes(String filename) throws Exception {
        String completeFileName = filename;
        byte[] byteCodes = this.getBytes(completeFileName = completeFileName.replace('.', '/').concat(".class"));
        if (byteCodes != null) {
            return byteCodes;
        }
        throw new ClassNotFoundException(Messages.getMessage("classnotfound", filename));
    }

    public InputStream getResourceAsStream(String name) {
        if (name == null) {
            return null;
        }
        if (this.parentFirst) {
            InputStream is = super.getResourceAsStream(name);
            if (is == null) {
                byte[] data = this.getBytes(name);
                if (data == null) {
                    return null;
                }
                return new ByteArrayInputStream(data);
            }
            return is;
        }
        byte[] data = this.getBytes(name);
        if (data != null) {
            return new ByteArrayInputStream(data);
        }
        return super.getResourceAsStream(name);
    }

    public void setParentFirst(boolean parentFirst) {
        this.parentFirst = parentFirst;
    }
}

