/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.AxisConfigBuilder;
import org.apache.axis2.deployment.DeploymentConstants;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.ServiceBuilder;
import org.apache.axis2.deployment.listener.RepositoryListener;
import org.apache.axis2.deployment.listener.RepositoryListenerImpl;
import org.apache.axis2.deployment.repository.util.ArchiveFileData;
import org.apache.axis2.deployment.repository.util.ArchiveReader;
import org.apache.axis2.deployment.repository.util.WSInfo;
import org.apache.axis2.deployment.scheduler.DeploymentIterator;
import org.apache.axis2.deployment.scheduler.Scheduler;
import org.apache.axis2.deployment.scheduler.SchedulerTask;
import org.apache.axis2.deployment.util.PhasesInfo;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Flow;
import org.apache.axis2.description.ModuleDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Phase;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.modules.Module;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeploymentEngine
implements DeploymentConstants {
    private Log log = LogFactory.getLog(this.getClass());
    private boolean hotUpdate = true;
    private boolean hotDeployment = true;
    public String axis2repository = null;
    private List wsToDeploy = new ArrayList();
    private List wsToUnDeploy = new ArrayList();
    private PhasesInfo phasesinfo = new PhasesInfo();
    private ArrayList modulelist = new ArrayList();
    private AxisConfiguration axisConfig;
    private ArchiveFileData currentArchiveFile;
    private String engineConfigName;

    public DeploymentEngine() {
    }

    public DeploymentEngine(String repositoryName) throws DeploymentException {
        this(repositoryName, "axis2.xml");
    }

    public DeploymentEngine(String repositoryName, String xmlFile) throws DeploymentException {
        if (repositoryName == null || "".equals(repositoryName.trim())) {
            throw new DeploymentException(Messages.getMessage("repocannotbebull"));
        }
        this.axis2repository = repositoryName;
        this.prepareRepository(repositoryName, xmlFile);
        this.engineConfigName = repositoryName + '/' + xmlFile;
    }

    public void addModule(QName moduleName) {
        this.modulelist.add(moduleName);
    }

    private void addNewModule(ModuleDescription modulemetadata) throws AxisFault {
        Flow faultOutFlow;
        Flow faultInFlow;
        Flow outFlow;
        Flow inflow = modulemetadata.getInFlow();
        ClassLoader moduleClassLoader = modulemetadata.getModuleClassLoader();
        if (inflow != null) {
            Utils.addFlowHandlers(inflow, moduleClassLoader);
        }
        if ((outFlow = modulemetadata.getOutFlow()) != null) {
            Utils.addFlowHandlers(outFlow, moduleClassLoader);
        }
        if ((faultInFlow = modulemetadata.getFaultInFlow()) != null) {
            Utils.addFlowHandlers(faultInFlow, moduleClassLoader);
        }
        if ((faultOutFlow = modulemetadata.getFaultOutFlow()) != null) {
            Utils.addFlowHandlers(faultOutFlow, moduleClassLoader);
        }
        this.axisConfig.addModule(modulemetadata);
        this.log.debug((Object)Messages.getMessage("addingnewmodule"));
    }

    private void addServiceGroup(AxisServiceGroup serviceGroup, ArrayList serviceList) throws AxisFault {
        serviceGroup.setParent(this.axisConfig);
        Iterator itr_global_modules = this.axisConfig.getEngagedModules().iterator();
        while (itr_global_modules.hasNext()) {
            QName qName = (QName)itr_global_modules.next();
            serviceGroup.engageModule(this.axisConfig.getModule(qName));
        }
        ArrayList groupModules = serviceGroup.getModuleRefs();
        for (int i = 0; i < groupModules.size(); ++i) {
            QName moduleName = (QName)groupModules.get(i);
            ModuleDescription module = this.axisConfig.getModule(moduleName);
            if (module == null) {
                throw new DeploymentException(Messages.getMessage("badModuleFromService", serviceGroup.getServiceGroupName(), moduleName.getLocalPart()));
            }
            serviceGroup.engageModule(this.axisConfig.getModule(moduleName));
        }
        Iterator services = serviceList.iterator();
        while (services.hasNext()) {
            AxisService axisService = (AxisService)services.next();
            axisService.setUseDefaultChains(false);
            axisService.setFileName(this.currentArchiveFile.getFile().getAbsolutePath());
            serviceGroup.addService(axisService);
            ArrayList list = axisService.getModules();
            for (int i = 0; i < list.size(); ++i) {
                ModuleDescription module = this.axisConfig.getModule((QName)list.get(i));
                if (module == null) {
                    throw new DeploymentException(Messages.getMessage("badModuleFromService", axisService.getName(), ((QName)list.get(i)).getLocalPart()));
                }
                axisService.engageModule(module, this.axisConfig);
            }
            HashMap operations = axisService.getOperations();
            Collection opCol = operations.values();
            Iterator iterator = opCol.iterator();
            while (iterator.hasNext()) {
                AxisOperation opDesc = (AxisOperation)iterator.next();
                ArrayList modules = opDesc.getModuleRefs();
                for (int i = 0; i < modules.size(); ++i) {
                    QName moduleName = (QName)modules.get(i);
                    ModuleDescription module = this.axisConfig.getModule(moduleName);
                    if (module == null) {
                        throw new DeploymentException(Messages.getMessage("badModuleFromOperation", opDesc.getName().getLocalPart(), moduleName.getLocalPart()));
                    }
                    opDesc.engageModule(module, this.axisConfig);
                }
            }
        }
        this.axisConfig.addServiceGroup(serviceGroup);
    }

    public void addWSToDeploy(ArchiveFileData file) {
        this.wsToDeploy.add(file);
    }

    public void addWSToUndeploy(WSInfo file) {
        this.wsToUnDeploy.add(file);
    }

    public ModuleDescription buildModule(File modulearchive, AxisConfiguration config) throws DeploymentException {
        ModuleDescription axismodule;
        try {
            Module module;
            Flow faultOutFlow;
            Flow faultInFlow;
            Flow outFlow;
            this.setPhasesinfo(config.getPhasesInfo());
            this.currentArchiveFile = new ArchiveFileData(modulearchive, 1);
            axismodule = new ModuleDescription();
            axismodule.setModuleClassLoader(this.currentArchiveFile.getClassLoader());
            ArchiveReader archiveReader = new ArchiveReader();
            ClassLoader moduleClassLoader = config.getModuleClassLoader();
            this.currentArchiveFile.setClassLoader(false, moduleClassLoader);
            archiveReader.readModuleArchive(this.currentArchiveFile.getAbsolutePath(), this, axismodule, false, this.axisConfig);
            Flow inflow = axismodule.getInFlow();
            if (inflow != null) {
                Utils.addFlowHandlers(inflow, moduleClassLoader);
            }
            if ((outFlow = axismodule.getOutFlow()) != null) {
                Utils.addFlowHandlers(outFlow, moduleClassLoader);
            }
            if ((faultInFlow = axismodule.getFaultInFlow()) != null) {
                Utils.addFlowHandlers(faultInFlow, moduleClassLoader);
            }
            if ((faultOutFlow = axismodule.getFaultOutFlow()) != null) {
                Utils.addFlowHandlers(faultOutFlow, moduleClassLoader);
            }
            if ((module = axismodule.getModule()) != null) {
                module.init(this.axisConfig);
            }
        }
        catch (AxisFault axisFault) {
            throw new DeploymentException(axisFault);
        }
        this.currentArchiveFile = null;
        return axismodule;
    }

    public AxisService buildService(AxisService axisService, InputStream serviceInputStream, ClassLoader classLoader, AxisConfiguration axisConfig) throws DeploymentException {
        try {
            this.currentArchiveFile = new ArchiveFileData(0, "");
            this.currentArchiveFile.setClassLoader(classLoader);
            ServiceBuilder builder = new ServiceBuilder(serviceInputStream, axisConfig, axisService);
            builder.populateService(builder.buildOM());
        }
        catch (AxisFault axisFault) {
            throw new DeploymentException(axisFault);
        }
        catch (XMLStreamException e) {
            throw new DeploymentException(e);
        }
        return axisService;
    }

    private void checkClientHome(String repositoryName) throws DeploymentException {
        this.prepareRepository(repositoryName, "axis2.xml");
        this.engineConfigName = repositoryName + '/' + "axis2.xml";
    }

    private AxisConfiguration createEngineConfig() {
        return new AxisConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doDeploy() {
        if (this.wsToDeploy.size() > 0) {
            for (int i = 0; i < this.wsToDeploy.size(); ++i) {
                this.currentArchiveFile = (ArchiveFileData)this.wsToDeploy.get(i);
                boolean explodedDir = this.currentArchiveFile.getFile().isDirectory();
                int type = this.currentArchiveFile.getType();
                try {
                    StringWriter errorWriter = new StringWriter();
                    switch (type) {
                        case 0: {
                            Object var11_16;
                            this.currentArchiveFile.setClassLoader(explodedDir, this.axisConfig.getServiceClassLoader());
                            ArchiveReader archiveReader = new ArchiveReader();
                            String serviceStatus = "";
                            try {
                                PrintWriter error_ptintWriter;
                                try {
                                    HashMap wsdlservice = archiveReader.processWSDLs(this.currentArchiveFile, this);
                                    AxisServiceGroup sericeGroup = new AxisServiceGroup(this.axisConfig);
                                    sericeGroup.setServiceGroupClassLoader(this.currentArchiveFile.getClassLoader());
                                    ArrayList serviceList = archiveReader.processServiceGroup(this.currentArchiveFile.getAbsolutePath(), this, sericeGroup, explodedDir, wsdlservice, this.axisConfig);
                                    this.addServiceGroup(sericeGroup, serviceList);
                                    this.log.debug((Object)Messages.getMessage("deployingws", this.currentArchiveFile.getName()));
                                }
                                catch (DeploymentException de) {
                                    this.log.info((Object)Messages.getMessage("invalidservice", this.currentArchiveFile.getName(), de.getMessage()));
                                    error_ptintWriter = new PrintWriter(errorWriter);
                                    de.printStackTrace(error_ptintWriter);
                                    serviceStatus = "Error:\n" + errorWriter.toString();
                                    var11_16 = null;
                                    if (serviceStatus.startsWith("Error:")) {
                                        this.axisConfig.getFaultyServices().put(this.getAxisServiceName(this.currentArchiveFile.getName()), serviceStatus);
                                    }
                                    this.currentArchiveFile = null;
                                    break;
                                }
                                catch (AxisFault axisFault) {
                                    this.log.info((Object)Messages.getMessage("invalidservice", this.currentArchiveFile.getName(), axisFault.getMessage()));
                                    error_ptintWriter = new PrintWriter(errorWriter);
                                    axisFault.printStackTrace(error_ptintWriter);
                                    serviceStatus = "Error:\n" + errorWriter.toString();
                                    var11_16 = null;
                                    if (serviceStatus.startsWith("Error:")) {
                                        this.axisConfig.getFaultyServices().put(this.getAxisServiceName(this.currentArchiveFile.getName()), serviceStatus);
                                    }
                                    this.currentArchiveFile = null;
                                    break;
                                }
                                catch (Exception e) {
                                    this.log.info((Object)Messages.getMessage("invalidservice", this.currentArchiveFile.getName(), e.getMessage()));
                                    error_ptintWriter = new PrintWriter(errorWriter);
                                    e.printStackTrace(error_ptintWriter);
                                    serviceStatus = "Error:\n" + errorWriter.toString();
                                    var11_16 = null;
                                    if (serviceStatus.startsWith("Error:")) {
                                        this.axisConfig.getFaultyServices().put(this.getAxisServiceName(this.currentArchiveFile.getName()), serviceStatus);
                                    }
                                    this.currentArchiveFile = null;
                                    break;
                                }
                                var11_16 = null;
                                if (serviceStatus.startsWith("Error:")) {
                                    this.axisConfig.getFaultyServices().put(this.getAxisServiceName(this.currentArchiveFile.getName()), serviceStatus);
                                }
                                this.currentArchiveFile = null;
                                break;
                            }
                            catch (Throwable throwable) {
                                var11_16 = null;
                                if (serviceStatus.startsWith("Error:")) {
                                    this.axisConfig.getFaultyServices().put(this.getAxisServiceName(this.currentArchiveFile.getName()), serviceStatus);
                                }
                                this.currentArchiveFile = null;
                                throw throwable;
                            }
                        }
                        case 1: {
                            Object var13_17;
                            this.currentArchiveFile.setClassLoader(explodedDir, this.axisConfig.getModuleClassLoader());
                            ArchiveReader archiveReader = new ArchiveReader();
                            String moduleStatus = "";
                            try {
                                PrintWriter error_ptintWriter;
                                try {
                                    ModuleDescription metaData = new ModuleDescription();
                                    metaData.setModuleClassLoader(this.currentArchiveFile.getClassLoader());
                                    metaData.setParent(this.axisConfig);
                                    archiveReader.readModuleArchive(this.currentArchiveFile.getAbsolutePath(), this, metaData, explodedDir, this.axisConfig);
                                    this.addNewModule(metaData);
                                    this.log.info((Object)Messages.getMessage("deployeingmodule", metaData.getName().getLocalPart()));
                                }
                                catch (DeploymentException e) {
                                    this.log.info((Object)Messages.getMessage("invalidmodule", this.currentArchiveFile.getName(), e.getMessage()));
                                    error_ptintWriter = new PrintWriter(errorWriter);
                                    e.printStackTrace(error_ptintWriter);
                                    moduleStatus = "Error:\n" + errorWriter.toString();
                                    var13_17 = null;
                                    if (moduleStatus.startsWith("Error:")) {
                                        this.axisConfig.getFaultyModules().put(this.getAxisServiceName(this.currentArchiveFile.getName()), moduleStatus);
                                    }
                                    this.currentArchiveFile = null;
                                    break;
                                }
                                catch (AxisFault axisFault) {
                                    this.log.info((Object)Messages.getMessage("invalidmodule", this.currentArchiveFile.getName(), axisFault.getMessage()));
                                    error_ptintWriter = new PrintWriter(errorWriter);
                                    axisFault.printStackTrace(error_ptintWriter);
                                    moduleStatus = "Error:\n" + errorWriter.toString();
                                    var13_17 = null;
                                    if (moduleStatus.startsWith("Error:")) {
                                        this.axisConfig.getFaultyModules().put(this.getAxisServiceName(this.currentArchiveFile.getName()), moduleStatus);
                                    }
                                    this.currentArchiveFile = null;
                                    break;
                                }
                                var13_17 = null;
                                if (moduleStatus.startsWith("Error:")) {
                                    this.axisConfig.getFaultyModules().put(this.getAxisServiceName(this.currentArchiveFile.getName()), moduleStatus);
                                }
                                this.currentArchiveFile = null;
                                break;
                            }
                            catch (Throwable throwable) {
                                var13_17 = null;
                                if (moduleStatus.startsWith("Error:")) {
                                    this.axisConfig.getFaultyModules().put(this.getAxisServiceName(this.currentArchiveFile.getName()), moduleStatus);
                                }
                                this.currentArchiveFile = null;
                                throw throwable;
                            }
                        }
                    }
                    continue;
                }
                catch (AxisFault axisFault) {
                    this.log.info((Object)Messages.getMessage("settingcl", axisFault.getMessage()));
                }
            }
        }
        this.wsToDeploy.clear();
    }

    private void engageModules() throws AxisFault {
        Iterator iterator = this.modulelist.iterator();
        while (iterator.hasNext()) {
            QName name = (QName)iterator.next();
            this.axisConfig.engageModule(name);
        }
    }

    public AxisConfiguration load() throws DeploymentException {
        if (this.engineConfigName == null) {
            throw new DeploymentException(Messages.getMessage("pathtoconfigcanotnull"));
        }
        File tempfile = new File(this.engineConfigName);
        try {
            FileInputStream in = new FileInputStream(tempfile);
            this.axisConfig = this.createEngineConfig();
            AxisConfigBuilder builder = new AxisConfigBuilder(in, this, this.axisConfig);
            builder.populateConfig();
            this.axisConfig.setPhasesinfo(this.phasesinfo);
            this.setClassLoaders(this.axis2repository);
        }
        catch (FileNotFoundException e) {
            throw new DeploymentException(e);
        }
        this.setDeploymentFeatures();
        RepositoryListenerImpl repoListener = new RepositoryListenerImpl(this.axis2repository, this);
        try {
            this.axisConfig.setRepository(this.axis2repository);
            this.validateSystemPredefinedPhases();
            this.engageModules();
        }
        catch (AxisFault axisFault) {
            this.log.info((Object)Messages.getMessage("modulevalfailed", axisFault.getMessage()));
            throw new DeploymentException(axisFault);
        }
        repoListener.checkServices();
        if (this.hotDeployment) {
            this.startSearch(repoListener);
        }
        return this.axisConfig;
    }

    public AxisConfiguration loadClient(String clientHome) throws DeploymentException {
        InputStream in;
        this.axis2repository = clientHome;
        boolean isRepositoryExist = false;
        RepositoryListenerImpl repoListener = null;
        if (clientHome != null && !"".equals(clientHome.trim())) {
            this.checkClientHome(clientHome);
            isRepositoryExist = true;
            try {
                File tempfile = new File(this.engineConfigName);
                in = new FileInputStream(tempfile);
            }
            catch (FileNotFoundException e) {
                throw new DeploymentException(e);
            }
        } else {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            in = cl.getResourceAsStream("org/apache/axis2/deployment/axis2.xml");
            if (in == null) {
                throw new DeploymentException(Messages.getMessage("confignotfound"));
            }
        }
        this.axisConfig = this.createEngineConfig();
        AxisConfigBuilder builder = new AxisConfigBuilder(in, this, this.axisConfig);
        this.axisConfig.setPhasesinfo(this.phasesinfo);
        builder.populateConfig();
        if (isRepositoryExist) {
            this.hotDeployment = false;
            this.hotUpdate = false;
            this.setClassLoaders(this.axis2repository);
            repoListener = new RepositoryListenerImpl(this.axis2repository, this);
        }
        try {
            this.axisConfig.setRepository(this.axis2repository);
            this.validateSystemPredefinedPhases();
            this.engageModules();
        }
        catch (AxisFault axisFault) {
            this.log.info((Object)Messages.getMessage("modulevalfailed", axisFault.getMessage()));
            throw new DeploymentException(axisFault);
        }
        if (repoListener != null) {
            repoListener.checkServices();
        }
        return this.axisConfig;
    }

    private void startSearch(RepositoryListener listener) {
        Scheduler scheduler = new Scheduler();
        scheduler.schedule(new SchedulerTask(listener), new DeploymentIterator());
    }

    public void unDeploy() {
        String serviceName = "";
        try {
            if (this.wsToUnDeploy.size() > 0) {
                for (int i = 0; i < this.wsToUnDeploy.size(); ++i) {
                    WSInfo wsInfo = (WSInfo)this.wsToUnDeploy.get(i);
                    if (wsInfo.getType() == 0) {
                        serviceName = this.getAxisServiceName(wsInfo.getFileName());
                        this.log.info((Object)Messages.getMessage("serviceremoved", wsInfo.getFileName()));
                    }
                    this.axisConfig.getFaultyServices().remove(serviceName);
                }
            }
        }
        catch (Exception e) {
            this.log.info((Object)e);
        }
        this.wsToUnDeploy.clear();
    }

    private void validateSystemPredefinedPhases() throws DeploymentException {
        ArrayList inPhases = this.phasesinfo.getINPhases();
        try {
            String phase1 = ((Phase)inPhases.get(0)).getPhaseName();
            String phases = ((Phase)inPhases.get(1)).getPhaseName();
            String phase3 = ((Phase)inPhases.get(2)).getPhaseName();
            if (!(phase1.equals("TransportIn") && phases.equals("PreDispatch") && phase3.equals("Dispatch"))) {
                throw new DeploymentException(Messages.getMessage("invalidphase"));
            }
        }
        catch (Exception e) {
            throw new DeploymentException(Messages.getMessage("invalidphase"));
        }
        this.axisConfig.setInPhasesUptoAndIncludingPostDispatch(this.phasesinfo.getGlobalInflow());
        this.axisConfig.setInFaultPhases(this.phasesinfo.getIN_FaultPhases());
        this.axisConfig.setGlobalOutPhase(this.phasesinfo.getGlobalOutPhaseList());
    }

    public AxisConfiguration getAxisConfig() {
        return this.axisConfig;
    }

    private String getAxisServiceName(String fileName) {
        int seperator = 46;
        int index = fileName.indexOf(seperator);
        if (index > 0) {
            String value = fileName.substring(0, index);
            return value;
        }
        return fileName;
    }

    public ArchiveFileData getCurrentFileItem() {
        return this.currentArchiveFile;
    }

    public ModuleDescription getModule(QName moduleName) throws AxisFault {
        return this.axisConfig.getModule(moduleName);
    }

    public PhasesInfo getPhasesinfo() {
        return this.phasesinfo;
    }

    public boolean isHotUpdate() {
        return this.hotUpdate;
    }

    private void setClassLoaders(String axis2repo) throws DeploymentException {
        ClassLoader sysClassLoader = Utils.getClassLoader(Thread.currentThread().getContextClassLoader(), axis2repo);
        this.axisConfig.setSystemClassLoader(sysClassLoader);
        File services = new File(axis2repo, "services");
        if (services.exists()) {
            this.axisConfig.setServiceClassLoader(Utils.getClassLoader(this.axisConfig.getSystemClassLoader(), services));
        } else {
            this.axisConfig.setServiceClassLoader(this.axisConfig.getSystemClassLoader());
        }
        File modules = new File(axis2repo, "modules");
        if (modules.exists()) {
            this.axisConfig.setModuleClassLoader(Utils.getClassLoader(this.axisConfig.getSystemClassLoader(), modules));
        } else {
            this.axisConfig.setModuleClassLoader(this.axisConfig.getSystemClassLoader());
        }
    }

    private void setDeploymentFeatures() {
        String value;
        Parameter parahotdeployment = this.axisConfig.getParameter("hotdeployment");
        Parameter parahotupdate = this.axisConfig.getParameter("hotupdate");
        if (parahotdeployment != null && "false".equalsIgnoreCase(value = (String)parahotdeployment.getValue())) {
            this.hotDeployment = false;
        }
        if (parahotupdate != null && "false".equalsIgnoreCase(value = (String)parahotupdate.getValue())) {
            this.hotUpdate = false;
        }
    }

    public void setPhasesinfo(PhasesInfo phasesinfo) {
        this.phasesinfo = phasesinfo;
    }

    /*
     * Loose catch block
     */
    private void prepareRepository(String repositoryName, String xmlFile) throws DeploymentException {
        block14: {
            block15: {
                IOException e2;
                FileOutputStream out;
                InputStream in;
                block13: {
                    int read;
                    File serverConf;
                    File repository = new File(repositoryName);
                    if (!repository.exists()) {
                        repository.mkdirs();
                        File services = new File(repository, "services");
                        File modules = new File(repository, "modules");
                        modules.mkdirs();
                        services.mkdirs();
                    }
                    if ((serverConf = new File(repository, xmlFile)).exists()) break block14;
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    in = cl.getResourceAsStream("org/apache/axis2/deployment/axis2.xml");
                    out = null;
                    if (in == null) break block15;
                    serverConf.createNewFile();
                    out = new FileOutputStream(serverConf);
                    int BUFSIZE = 512;
                    byte[] buf = new byte[BUFSIZE];
                    while ((read = in.read(buf)) > 0) {
                        out.write(buf, 0, read);
                    }
                    in.close();
                    out.close();
                    Object var12_12 = null;
                    if (out == null) break block13;
                    try {
                        out.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
                try {
                    in.close();
                }
                catch (IOException e2) {}
                break block14;
                {
                    catch (IOException e3) {
                        throw new DeploymentException(e3);
                    }
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                    }
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            throw new DeploymentException(Messages.getMessage("confignotfound"));
        }
    }
}

