/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentConstants;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Flow;
import org.apache.axis2.description.FlowImpl;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterImpl;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.om.OMAbstractFactory;
import org.apache.axis2.om.OMAttribute;
import org.apache.axis2.om.OMElement;
import org.apache.axis2.om.OMFactory;
import org.apache.axis2.om.impl.llom.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.policy.Policy;
import org.apache.ws.policy.PolicyReference;
import org.apache.ws.policy.util.OMPolicyReader;
import org.apache.ws.policy.util.PolicyFactory;

public class DescriptionBuilder
implements DeploymentConstants {
    protected Log log = LogFactory.getLog(this.getClass());
    protected AxisConfiguration axisConfig;
    protected InputStream descriptionStream;

    public DescriptionBuilder() {
    }

    public DescriptionBuilder(InputStream serviceInputStream, AxisConfiguration axisConfig) {
        this.descriptionStream = serviceInputStream;
        this.axisConfig = axisConfig;
    }

    public OMElement buildOM() throws XMLStreamException {
        XMLStreamReader xmlReader = XMLInputFactory.newInstance().createXMLStreamReader(this.descriptionStream);
        OMFactory fac = OMAbstractFactory.getOMFactory();
        StAXOMBuilder staxOMBuilder = new StAXOMBuilder(fac, xmlReader);
        OMElement element = staxOMBuilder.getDocumentElement();
        element.build();
        return element;
    }

    protected MessageReceiver loadDefaultMessageReceiver(String mepURL, AxisService service) {
        MessageReceiver messageReceiver;
        if (mepURL == null) {
            mepURL = "http://www.w3.org/2004/08/wsdl/in-out";
        }
        if (service != null && (messageReceiver = service.getMessageReceiver(mepURL)) != null) {
            return messageReceiver;
        }
        return this.axisConfig.getMessageReceiver(mepURL);
    }

    protected HashMap processMessageReceivers(OMElement messageReceivers) throws DeploymentException {
        HashMap<String, MessageReceiver> mr_mep = new HashMap<String, MessageReceiver>();
        Iterator msgRecives = messageReceivers.getChildrenWithName(new QName("messageReceiver"));
        while (msgRecives.hasNext()) {
            OMElement msgRev = (OMElement)msgRecives.next();
            MessageReceiver msgrecivere = this.loadMessageReceiver(Thread.currentThread().getContextClassLoader(), msgRev);
            OMAttribute mepAtt = msgRev.getAttribute(new QName("mep"));
            mr_mep.put(mepAtt.getAttributeValue(), msgrecivere);
        }
        return mr_mep;
    }

    protected HashMap processMessageReceivers(ClassLoader loader, OMElement element) throws DeploymentException {
        HashMap<String, MessageReceiver> meps = new HashMap<String, MessageReceiver>();
        Iterator iterator = element.getChildrenWithName(new QName("messageReceiver"));
        while (iterator.hasNext()) {
            OMElement receiverElement = (OMElement)iterator.next();
            MessageReceiver receiver = this.loadMessageReceiver(loader, receiverElement);
            OMAttribute mepAtt = receiverElement.getAttribute(new QName("mep"));
            meps.put(mepAtt.getAttributeValue(), receiver);
        }
        return meps;
    }

    protected MessageReceiver loadMessageReceiver(ClassLoader loader, OMElement element) throws DeploymentException {
        OMAttribute receiverName = element.getAttribute(new QName("class"));
        String className = receiverName.getAttributeValue();
        MessageReceiver receiver = null;
        try {
            if (className != null && !"".equals(className)) {
                Class<?> messageReceiver = Class.forName(className, true, loader);
                receiver = (MessageReceiver)messageReceiver.newInstance();
            }
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException(Messages.getMessage("errorinloadingmr", "ClassNotFoundException", className));
        }
        catch (IllegalAccessException e) {
            throw new DeploymentException(Messages.getMessage("errorinloadingmr", "IllegalAccessException", className));
        }
        catch (InstantiationException e) {
            throw new DeploymentException(Messages.getMessage("errorinloadingmr", "InstantiationException", className));
        }
        return receiver;
    }

    protected Flow processFlow(OMElement flowelement, ParameterInclude parent) throws DeploymentException {
        FlowImpl flow = new FlowImpl();
        if (flowelement == null) {
            return flow;
        }
        Iterator handlers = flowelement.getChildrenWithName(new QName("handler"));
        while (handlers.hasNext()) {
            OMElement handlerElement = (OMElement)handlers.next();
            flow.addHandler(this.processHandler(handlerElement, parent));
        }
        return flow;
    }

    protected HandlerDescription processHandler(OMElement handler_element, ParameterInclude parent) throws DeploymentException {
        HandlerDescription handler = new HandlerDescription();
        OMAttribute name_attribute = handler_element.getAttribute(new QName("name"));
        if (name_attribute == null) {
            throw new DeploymentException(Messages.getMessage("invalidhandler", "Name missing"));
        }
        handler.setName(new QName(name_attribute.getAttributeValue()));
        OMAttribute class_attribute = handler_element.getAttribute(new QName("class"));
        if (class_attribute == null) {
            throw new DeploymentException(Messages.getMessage("invalidhandler", "class name is missing"));
        }
        handler.setClassName(class_attribute.getAttributeValue());
        OMElement order_element = handler_element.getFirstChildWithName(new QName("order"));
        if (order_element == null) {
            throw new DeploymentException(Messages.getMessage("invalidhandler", "phase rule has not been specified"));
        }
        Iterator order_itr = order_element.getAllAttributes();
        while (order_itr.hasNext()) {
            String boolval;
            OMAttribute orderAttribute = (OMAttribute)order_itr.next();
            String name = orderAttribute.getQName().getLocalPart();
            String value = orderAttribute.getAttributeValue();
            if ("after".equals(name)) {
                handler.getRules().setAfter(value);
                continue;
            }
            if ("before".equals(name)) {
                handler.getRules().setBefore(value);
                continue;
            }
            if ("phase".equals(name)) {
                handler.getRules().setPhaseName(value);
                continue;
            }
            if ("phaseFirst".equals(name)) {
                boolval = this.getValue(value);
                if (boolval.equals("true")) {
                    handler.getRules().setPhaseFirst(true);
                    continue;
                }
                if (!boolval.equals("false")) continue;
                handler.getRules().setPhaseFirst(false);
                continue;
            }
            if (!"phaseLast".equals(name)) continue;
            boolval = this.getValue(value);
            if (boolval.equals("true")) {
                handler.getRules().setPhaseLast(true);
                continue;
            }
            if (!boolval.equals("false")) continue;
            handler.getRules().setPhaseLast(false);
        }
        Iterator parameters = handler_element.getChildrenWithName(new QName("parameter"));
        this.processParameters(parameters, handler, parent);
        handler.setParent(parent);
        return handler;
    }

    protected void processOperationModuleRefs(Iterator moduleRefs, AxisOperation operation) throws DeploymentException {
        try {
            while (moduleRefs.hasNext()) {
                OMElement moduleref = (OMElement)moduleRefs.next();
                OMAttribute moduleRefAttribute = moduleref.getAttribute(new QName("ref"));
                if (moduleRefAttribute == null) continue;
                String refName = moduleRefAttribute.getAttributeValue();
                if (this.axisConfig.getModule(new QName(refName)) == null) {
                    throw new DeploymentException(Messages.getMessage("modulenotfound", refName));
                }
                operation.addModule(new QName(refName));
            }
        }
        catch (AxisFault axisFault) {
            throw new DeploymentException(Messages.getMessage("modulenotfound", axisFault.getMessage()));
        }
    }

    protected ArrayList processParameters(Iterator parameters, ParameterInclude parameterInclude, ParameterInclude parent) throws DeploymentException {
        ArrayList<ParameterImpl> wsamapping = new ArrayList<ParameterImpl>();
        while (parameters.hasNext()) {
            OMElement parameterElement = (OMElement)parameters.next();
            ParameterImpl parameter = new ParameterImpl();
            parameter.setParameterElement(parameterElement);
            OMAttribute paramName = parameterElement.getAttribute(new QName("name"));
            if (paramName == null) {
                throw new DeploymentException(Messages.getMessage("badparaagu"));
            }
            parameter.setName(paramName.getAttributeValue());
            OMElement paramValue = parameterElement.getFirstElement();
            if (paramValue != null) {
                parameter.setValue(parameterElement);
                parameter.setParameterType(1);
            } else {
                String paratextValue = parameterElement.getText();
                parameter.setValue(paratextValue);
                parameter.setParameterType(0);
            }
            OMAttribute paramLocked = parameterElement.getAttribute(new QName("locked"));
            Parameter parentParam = null;
            if (parent != null) {
                parentParam = parent.getParameter(parameter.getName());
            }
            if (paramLocked != null) {
                String lockedValue = paramLocked.getAttributeValue();
                if ("true".equals(lockedValue)) {
                    if (parent != null && parent.isParameterLocked(parameter.getName())) {
                        throw new DeploymentException(Messages.getMessage("confignotfound", parameter.getName()));
                    }
                    parameter.setLocked(true);
                } else {
                    parameter.setLocked(false);
                }
            }
            if ("wsamapping".equals(paramName.getAttributeValue())) {
                wsamapping.add(parameter);
                continue;
            }
            try {
                if (parent != null) {
                    if (parentParam != null && parent.isParameterLocked(parameter.getName())) continue;
                    parameterInclude.addParameter(parameter);
                    continue;
                }
                parameterInclude.addParameter(parameter);
            }
            catch (AxisFault axisFault) {
                throw new DeploymentException(axisFault);
            }
        }
        return wsamapping;
    }

    protected void processPolicyElements(int type, Iterator policyElements, PolicyInclude policyInclude) {
        OMPolicyReader reader = (OMPolicyReader)PolicyFactory.getPolicyReader((int)1);
        while (policyElements.hasNext()) {
            Policy p = reader.readPolicy((OMElement)policyElements.next());
            policyInclude.addPolicyElement(type, p);
        }
    }

    protected void processPolicyRefElements(int type, Iterator policyRefElements, PolicyInclude policyInclude) {
        OMPolicyReader reader = (OMPolicyReader)PolicyFactory.getPolicyReader((int)1);
        while (policyRefElements.hasNext()) {
            PolicyReference policyReference = reader.readPolicyReference((OMElement)policyRefElements.next());
            policyInclude.addPolicyRefElement(type, policyReference);
        }
    }

    public static String getShortFileName(String fileName) {
        int seperator = 46;
        int index = fileName.lastIndexOf(seperator);
        if (index > 0) {
            String value = fileName.substring(0, index);
            return value;
        }
        return fileName;
    }

    protected String getValue(String in) {
        int seperator = 58;
        int index = in.indexOf(seperator);
        if (index > 0) {
            String value = in.substring(index + 1, in.length());
            return value;
        }
        return in;
    }
}

